/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import sqlline.DispatchCallback;
import sqlline.Rows;
import sqlline.SqlLine;
import sqlline.WrappedSqlException;

class IncrementalRows
extends Rows {
    private final ResultSet rs;
    private final Rows.Row labelRow;
    private final Rows.Row maxRow;
    private Rows.Row nextRow;
    private boolean endOfResult;
    private boolean normalizingWidths;
    private DispatchCallback dispatchCallback;

    IncrementalRows(SqlLine sqlLine, ResultSet rs, DispatchCallback dispatchCallback) throws SQLException {
        super(sqlLine, rs);
        this.rs = rs;
        this.dispatchCallback = dispatchCallback;
        this.labelRow = new Rows.Row(this, this.rsMeta.getColumnCount());
        this.maxRow = new Rows.Row(this, this.rsMeta.getColumnCount());
        for (int i = 0; i < this.maxRow.sizes.length; ++i) {
            this.maxRow.sizes[i] = Math.max(this.maxRow.sizes[i], this.rsMeta.getColumnDisplaySize(i + 1));
        }
        this.nextRow = this.labelRow;
        this.endOfResult = false;
    }

    public boolean hasNext() {
        if (this.endOfResult || this.dispatchCallback.isCanceled()) {
            return false;
        }
        if (this.nextRow == null) {
            try {
                if (this.rs.next()) {
                    this.nextRow = new Rows.Row(this, this.labelRow.sizes.length, this.rs);
                    if (this.normalizingWidths) {
                        this.nextRow.sizes = this.labelRow.sizes;
                    }
                } else {
                    this.endOfResult = true;
                }
            }
            catch (SQLException ex) {
                throw new WrappedSqlException(ex);
            }
        }
        return this.nextRow != null;
    }

    public Rows.Row next() {
        if (!this.hasNext() && !this.dispatchCallback.isCanceled()) {
            throw new NoSuchElementException();
        }
        Rows.Row ret = this.nextRow;
        this.nextRow = null;
        return ret;
    }

    void normalizeWidths() {
        this.labelRow.sizes = this.maxRow.sizes;
        this.normalizingWidths = true;
    }
}

