/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HiveRecordReader;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;

public class HiveTextRecordReader
extends HiveRecordReader {
    public final byte delimiter;
    public final List<Integer> columnIds;
    private final int numCols;

    public HiveTextRecordReader(Table table, Partition partition, InputSplit inputSplit, List<SchemaPath> projectedColumns, FragmentContext context) throws ExecutionSetupException {
        super(table, partition, inputSplit, projectedColumns, context, null, null);
        String d = (String)table.getSd().getSerdeInfo().getParameters().get("field.delim");
        this.delimiter = d != null ? d.getBytes()[0] : (byte)1;
        assert (this.delimiter > 0);
        ArrayList ids = Lists.newArrayList();
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            if (!this.selectedColumnNames.contains(this.tableColumns.get(i))) continue;
            ids.add(i);
        }
        this.columnIds = ids;
        this.numCols = this.tableColumns.size();
    }

    public void setValue(PrimitiveObjectInspector.PrimitiveCategory pCat, ValueVector vv, int index, byte[] bytes, int start) {
        switch (pCat) {
            case BINARY: {
                throw new UnsupportedOperationException();
            }
            case BOOLEAN: {
                throw new UnsupportedOperationException();
            }
            case BYTE: {
                throw new UnsupportedOperationException();
            }
            case DECIMAL: {
                throw new UnsupportedOperationException();
            }
            case DOUBLE: {
                throw new UnsupportedOperationException();
            }
            case FLOAT: {
                throw new UnsupportedOperationException();
            }
            case INT: {
                byte b;
                int value = 0;
                int i = start;
                while ((b = bytes[i]) != this.delimiter) {
                    value = value * 10 + b - 48;
                    ++i;
                }
                ((NullableIntVector)vv).getMutator().setSafe(index, value);
            }
            case LONG: {
                byte b;
                long value = 0L;
                int i = start;
                while ((b = bytes[i]) != this.delimiter) {
                    value = value * 10L + (long)b - 48L;
                    ++i;
                }
                ((NullableBigIntVector)vv).getMutator().setSafe(index, value);
            }
            case SHORT: {
                throw new UnsupportedOperationException();
            }
            case STRING: {
                int end = start;
                for (int i = start; i < bytes.length; ++i) {
                    if (bytes[i] == this.delimiter) {
                        end = i;
                        break;
                    }
                    end = bytes.length;
                }
                ((NullableVarCharVector)vv).getMutator().setSafe(index, bytes, start, end - start);
            }
            case TIMESTAMP: {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException("Could not determine type");
    }

    @Override
    public int next() {
        for (ValueVector vv : this.vectors) {
            AllocationHelper.allocateNew((ValueVector)vv, (int)4000);
        }
        try {
            boolean success;
            int p;
            int[] delimPositions;
            byte[] bytes;
            int recordCount = 0;
            if (this.redoRecord != null) {
                int length = ((Text)this.value).getLength();
                bytes = ((Text)this.value).getBytes();
                delimPositions = new int[this.numCols];
                delimPositions[0] = -1;
                p = 0;
                for (int i = 0; i < length; ++i) {
                    if (bytes[i] != this.delimiter) continue;
                    delimPositions[p++] = i;
                }
                for (int id : this.columnIds) {
                    success = false;
                    if (success) continue;
                    throw new DrillRuntimeException(String.format("Failed to write value for column %s", this.selectedColumnNames.get(id)));
                }
                this.redoRecord = null;
            }
            while (recordCount < 4000 && this.reader.next(this.key, this.value)) {
                int i;
                int length = ((Text)this.value).getLength();
                bytes = ((Text)this.value).getBytes();
                delimPositions = new int[this.numCols + 1];
                delimPositions[0] = -1;
                p = 1;
                for (i = 0; i < length; ++i) {
                    if (bytes[i] != this.delimiter) continue;
                    delimPositions[p++] = i;
                }
                for (i = 0; i < this.columnIds.size(); ++i) {
                    int id;
                    id = this.columnIds.get(i);
                    success = false;
                    if (success) continue;
                    this.redoRecord = this.value;
                    if (this.partition != null) {
                        this.populatePartitionVectors(recordCount);
                    }
                    return recordCount;
                }
                ++recordCount;
            }
            if (this.partition != null) {
                this.populatePartitionVectors(recordCount);
            }
            return recordCount;
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }
}

