/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hive-scan")
public class HiveScan
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(HiveScan.class);
    private static int HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN = 20;
    @JsonProperty(value="hive-table")
    public HiveReadEntry hiveReadEntry;
    @JsonIgnore
    protected List<InputSplit> inputSplits = Lists.newArrayList();
    @JsonIgnore
    public HiveStoragePlugin storagePlugin;
    @JsonProperty(value="storage-plugin")
    public String storagePluginName;
    @JsonIgnore
    private final Collection<CoordinationProtos.DrillbitEndpoint> endpoints;
    @JsonProperty(value="columns")
    public List<SchemaPath> columns;
    @JsonProperty(value="numPartitions")
    public final int numPartitions;
    @JsonIgnore
    List<List<InputSplit>> mappings;
    @JsonIgnore
    Map<InputSplit, Partition> partitionMap = new HashMap<InputSplit, Partition>();
    @JsonIgnore
    private long rowCount = 0L;

    @JsonCreator
    public HiveScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="hive-table") HiveReadEntry hiveReadEntry, @JsonProperty(value="storage-plugin") String storagePluginName, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="numPartitions") int numPartitions, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.storagePluginName = storagePluginName;
        this.storagePlugin = (HiveStoragePlugin)pluginRegistry.getPlugin(storagePluginName);
        this.columns = columns;
        this.getSplitsWithUGI();
        this.endpoints = this.storagePlugin.getContext().getBits();
        this.numPartitions = numPartitions;
    }

    public HiveScan(String userName, HiveReadEntry hiveReadEntry, HiveStoragePlugin storagePlugin, List<SchemaPath> columns) throws ExecutionSetupException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.columns = columns;
        this.storagePlugin = storagePlugin;
        this.getSplitsWithUGI();
        this.endpoints = storagePlugin.getContext().getBits();
        this.storagePluginName = storagePlugin.getName();
        List<HiveTable.HivePartition> partitions = hiveReadEntry.getHivePartitionWrappers();
        this.numPartitions = partitions == null ? 0 : partitions.size();
    }

    public HiveScan(HiveScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.endpoints = that.endpoints;
        this.hiveReadEntry = that.hiveReadEntry;
        this.inputSplits = that.inputSplits;
        this.mappings = that.mappings;
        this.partitionMap = that.partitionMap;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginName = that.storagePluginName;
        this.rowCount = that.rowCount;
        this.numPartitions = that.numPartitions;
    }

    public HiveScan clone(HiveReadEntry hiveReadEntry) throws ExecutionSetupException {
        return new HiveScan(this.getUserName(), hiveReadEntry, this.storagePlugin, this.columns);
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    private void getSplitsWithUGI() throws ExecutionSetupException {
        UserGroupInformation ugi = ImpersonationUtil.createProxyUgi((String)this.getUserName());
        try {
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HiveScan.this.getSplits();
                    return null;
                }
            });
        }
        catch (IOException | InterruptedException e) {
            String errMsg = String.format("Failed to create input splits: %s", e.getMessage());
            logger.error(errMsg, (Throwable)e);
            throw new DrillRuntimeException(errMsg, (Throwable)e);
        }
    }

    private void getSplits() throws ExecutionSetupException {
        try {
            List<Partition> partitions = this.hiveReadEntry.getPartitions();
            Table table = this.hiveReadEntry.getTable();
            if (partitions == null || partitions.size() == 0) {
                Properties properties = MetaStoreUtils.getTableMetadata((Table)table);
                this.splitInput(properties, table.getSd(), null);
            } else {
                for (Partition partition : partitions) {
                    Properties properties = MetaStoreUtils.getPartitionMetadata((Partition)partition, (Table)table);
                    this.splitInput(properties, partition.getSd(), partition);
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    private void splitInput(Properties properties, StorageDescriptor sd, Partition partition) throws ReflectiveOperationException, IOException {
        long numRows;
        JobConf job = new JobConf();
        for (Object object : properties.keySet()) {
            job.set((String)object, (String)properties.get(object));
        }
        for (Map.Entry entry : this.hiveReadEntry.hiveConfigOverride.entrySet()) {
            job.set((String)entry.getKey(), (String)entry.getValue());
        }
        InputFormat format = (InputFormat)Class.forName(sd.getInputFormat()).getConstructor(new Class[0]).newInstance(new Object[0]);
        job.setInputFormat(format.getClass());
        Path path = new Path(sd.getLocation());
        FileSystem fs = path.getFileSystem((Configuration)job);
        if (fs.exists(path)) {
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
            format = job.getInputFormat();
            for (InputSplit split : format.getSplits(job, 1)) {
                this.inputSplits.add(split);
                this.partitionMap.put(split, partition);
            }
        }
        String numRowsProp = properties.getProperty("numRows");
        logger.trace("HiveScan num rows property = {}", (Object)numRowsProp);
        if (numRowsProp != null && (numRows = Long.valueOf(numRowsProp).longValue()) > 0L) {
            this.rowCount += numRows;
        }
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = Lists.newArrayList();
        for (int i = 0; i < endpoints.size(); ++i) {
            this.mappings.add(new ArrayList());
        }
        int count = endpoints.size();
        for (int i = 0; i < this.inputSplits.size(); ++i) {
            this.mappings.get(i % count).add(this.inputSplits.get(i));
        }
    }

    public static String serializeInputSplit(InputSplit split) throws IOException {
        ByteArrayDataOutput byteArrayOutputStream = ByteStreams.newDataOutput();
        split.write((DataOutput)byteArrayOutputStream);
        String encoded = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
        logger.debug("Encoded split string for split {} : {}", (Object)split, (Object)encoded);
        return encoded;
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            List<InputSplit> splits = this.mappings.get(minorFragmentId);
            ArrayList parts = Lists.newArrayList();
            ArrayList encodedInputSplits = Lists.newArrayList();
            ArrayList splitTypes = Lists.newArrayList();
            for (InputSplit split : splits) {
                HiveTable.HivePartition partition = null;
                if (this.partitionMap.get(split) != null) {
                    partition = new HiveTable.HivePartition(this.partitionMap.get(split));
                }
                parts.add(partition);
                encodedInputSplits.add(HiveScan.serializeInputSplit(split));
                splitTypes.add(split.getClass().getName());
            }
            if (parts.contains(null)) {
                parts = null;
            }
            HiveReadEntry subEntry = new HiveReadEntry(this.hiveReadEntry.table, parts, this.hiveReadEntry.hiveConfigOverride);
            return new HiveSubScan(this.getUserName(), encodedInputSplits, subEntry, splitTypes, this.columns);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int getMaxParallelizationWidth() {
        return this.inputSplits.size();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.endpoints) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("endpoing address: {}", (Object)endpoint.getAddress());
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        try {
            long totalSize = 0L;
            for (InputSplit split : this.inputSplits) {
                totalSize += Math.max(1L, split.getLength());
            }
            for (InputSplit split : this.inputSplits) {
                float affinity = (float)Math.max(1L, split.getLength()) / (float)totalSize;
                for (String loc : split.getLocations()) {
                    logger.debug("split location: {}", (Object)loc);
                    CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(loc);
                    if (endpoint == null) continue;
                    if (affinityMap.containsKey(endpoint)) {
                        ((EndpointAffinity)affinityMap.get(endpoint)).addAffinity((double)affinity);
                        continue;
                    }
                    affinityMap.put(endpoint, new EndpointAffinity(endpoint, (double)affinity));
                }
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
        for (CoordinationProtos.DrillbitEndpoint ep : affinityMap.keySet()) {
            Preconditions.checkNotNull((Object)ep);
        }
        for (EndpointAffinity a : affinityMap.values()) {
            Preconditions.checkNotNull((Object)a.getEndpoint());
        }
        return Lists.newArrayList(affinityMap.values());
    }

    public ScanStats getScanStats() {
        try {
            long data = 0L;
            for (InputSplit split : this.inputSplits) {
                data += split.getLength();
            }
            long estRowCount = this.rowCount;
            if (estRowCount == 0L) {
                estRowCount = data / 1024L;
            }
            float cpuCost = 1 * this.getSerDeOverheadFactor();
            logger.debug("estimated row count = {}, stats row count = {}", (Object)estRowCount, (Object)this.rowCount);
            return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, estRowCount, cpuCost, (float)data);
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    protected int getSerDeOverheadFactor() {
        int projectedColumnCount;
        if (AbstractRecordReader.isStarQuery(this.columns)) {
            Table hiveTable = this.hiveReadEntry.getTable();
            projectedColumnCount = hiveTable.getSd().getColsSize() + hiveTable.getPartitionKeysSize();
        } else {
            projectedColumnCount = this.columns.size();
        }
        return projectedColumnCount * HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new HiveScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        List<HiveTable.HivePartition> partitions = this.hiveReadEntry.getHivePartitionWrappers();
        int numPartitions = partitions == null ? 0 : partitions.size();
        return "HiveScan [table=" + this.hiveReadEntry.getHiveTableWrapper() + ", inputSplits=" + this.inputSplits + ", columns=" + this.columns + ", numPartitions=" + numPartitions + ", partitions= " + partitions + "]";
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveScan newScan = new HiveScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public boolean supportsPartitionFilterPushdown() {
        List partitionKeys = this.hiveReadEntry.getTable().getPartitionKeys();
        return partitionKeys != null && partitionKeys.size() != 0;
    }

    @JsonIgnore
    public boolean isNativeReader() {
        return false;
    }
}

