/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hive.HiveFieldConverter;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(HiveRecordReader.class);
    private final DrillBuf managedBuffer;
    protected Table table;
    protected Partition partition;
    protected InputSplit inputSplit;
    protected List<String> selectedColumnNames;
    protected List<TypeInfo> selectedColumnTypes = Lists.newArrayList();
    protected List<ObjectInspector> selectedColumnObjInspectors = Lists.newArrayList();
    protected List<HiveFieldConverter> selectedColumnFieldConverters = Lists.newArrayList();
    protected List<String> selectedPartitionNames = Lists.newArrayList();
    protected List<TypeInfo> selectedPartitionTypes = Lists.newArrayList();
    protected List<Object> selectedPartitionValues = Lists.newArrayList();
    protected List<String> tableColumns;
    protected SerDe serde;
    protected StructObjectInspector sInspector;
    protected Object key;
    protected Object value;
    protected RecordReader reader;
    protected List<ValueVector> vectors = Lists.newArrayList();
    protected List<ValueVector> pVectors = Lists.newArrayList();
    protected Object redoRecord;
    protected boolean empty;
    private Map<String, String> hiveConfigOverride;
    private FragmentContext fragmentContext;
    private String defaultPartitionValue;
    private final UserGroupInformation proxyUgi;
    protected static final int TARGET_RECORD_COUNT = 4000;

    public HiveRecordReader(Table table, Partition partition, InputSplit inputSplit, List<SchemaPath> projectedColumns, FragmentContext context, Map<String, String> hiveConfigOverride, UserGroupInformation proxyUgi) throws ExecutionSetupException {
        this.table = table;
        this.partition = partition;
        this.inputSplit = inputSplit;
        this.empty = inputSplit == null && partition == null;
        this.hiveConfigOverride = hiveConfigOverride;
        this.fragmentContext = context;
        this.proxyUgi = proxyUgi;
        this.managedBuffer = this.fragmentContext.getManagedBuffer().reallocIfNeeded(256);
        this.setColumns(projectedColumns);
    }

    private void init() throws ExecutionSetupException {
        InputFormat format;
        Properties properties;
        JobConf job = new JobConf();
        if (this.partition != null) {
            properties = MetaStoreUtils.getPartitionMetadata((Partition)this.partition, (Table)this.table);
            for (Map.Entry entry : this.table.getParameters().entrySet()) {
                if (entry.getKey() == null || entry.getKey() == null) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        } else {
            properties = MetaStoreUtils.getTableMetadata((Table)this.table);
        }
        for (Object object : properties.keySet()) {
            job.set((String)object, (String)properties.get(object));
        }
        for (Map.Entry entry : this.hiveConfigOverride.entrySet()) {
            job.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.defaultPartitionValue = HiveUtilities.getDefaultPartitionValue(this.hiveConfigOverride);
        String string = this.partition == null ? this.table.getSd().getSerdeInfo().getSerializationLib() : this.partition.getSd().getSerdeInfo().getSerializationLib();
        String inputFormatName = this.partition == null ? this.table.getSd().getInputFormat() : this.partition.getSd().getInputFormat();
        try {
            format = (InputFormat)Class.forName(inputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> c = Class.forName(string);
            this.serde = (SerDe)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.serde.initialize((Configuration)job, properties);
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw new ExecutionSetupException("Unable to instantiate InputFormat", e);
        }
        job.setInputFormat(format.getClass());
        List partitionKeys = this.table.getPartitionKeys();
        ArrayList partitionNames = Lists.newArrayList();
        for (FieldSchema field : partitionKeys) {
            partitionNames.add(field.getName());
        }
        try {
            ObjectInspector oi = this.serde.getObjectInspector();
            if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new UnsupportedOperationException(String.format("%s category not supported", oi.getCategory()));
            }
            this.sInspector = (StructObjectInspector)oi;
            StructTypeInfo sTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.sInspector);
            ArrayList columnIds = Lists.newArrayList();
            if (this.isStarQuery()) {
                this.selectedColumnNames = sTypeInfo.getAllStructFieldNames();
                this.tableColumns = this.selectedColumnNames;
                for (int i = 0; i < this.selectedColumnNames.size(); ++i) {
                    columnIds.add(i);
                }
            } else {
                this.tableColumns = sTypeInfo.getAllStructFieldNames();
                this.selectedColumnNames = Lists.newArrayList();
                for (SchemaPath field : this.getColumns()) {
                    String columnName = field.getRootSegment().getPath();
                    if (!this.tableColumns.contains(columnName)) {
                        if (partitionNames.contains(columnName)) {
                            this.selectedPartitionNames.add(columnName);
                            continue;
                        }
                        throw new ExecutionSetupException(String.format("Column %s does not exist", columnName));
                    }
                    columnIds.add(this.tableColumns.indexOf(columnName));
                    this.selectedColumnNames.add(columnName);
                }
            }
            ColumnProjectionUtils.appendReadColumns((Configuration)job, (List)columnIds, this.selectedColumnNames);
            for (String columnName : this.selectedColumnNames) {
                ObjectInspector fieldOI = this.sInspector.getStructFieldRef(columnName).getFieldObjectInspector();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)fieldOI.getTypeName());
                this.selectedColumnObjInspectors.add(fieldOI);
                this.selectedColumnTypes.add(typeInfo);
                this.selectedColumnFieldConverters.add(HiveFieldConverter.create(typeInfo, this.fragmentContext));
            }
            if (this.isStarQuery()) {
                this.selectedPartitionNames = partitionNames;
            }
            for (int i = 0; i < this.table.getPartitionKeys().size(); ++i) {
                SchemaPath field;
                field = (FieldSchema)this.table.getPartitionKeys().get(i);
                if (!this.selectedPartitionNames.contains(field.getName())) continue;
                TypeInfo pType = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
                this.selectedPartitionTypes.add(pType);
                if (this.partition == null) continue;
                this.selectedPartitionValues.add(HiveUtilities.convertPartitionType(pType, (String)this.partition.getValues().get(i), this.defaultPartitionValue));
            }
        }
        catch (Exception e) {
            throw new ExecutionSetupException("Failure while initializing HiveRecordReader: " + e.getMessage(), (Throwable)e);
        }
        if (!this.empty) {
            try {
                this.reader = format.getRecordReader(this.inputSplit, job, Reporter.NULL);
            }
            catch (IOException e) {
                throw new ExecutionSetupException("Failed to get o.a.hadoop.mapred.RecordReader from Hive InputFormat", (Throwable)e);
            }
            this.key = this.reader.createKey();
            this.value = this.reader.createValue();
        }
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        Callable<Void> readerInitializer = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HiveRecordReader.this.init();
                return null;
            }
        };
        ListenableFuture result = context.runCallableAs(this.proxyUgi, (Callable)readerInitializer);
        try {
            result.get();
        }
        catch (InterruptedException e) {
            result.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw ExecutionSetupException.fromThrowable((String)e.getMessage(), (Throwable)e);
        }
        try {
            Class vvClass;
            MaterializedField field;
            TypeProtos.MajorType type;
            int i;
            OptionManager options = this.fragmentContext.getOptions();
            for (i = 0; i < this.selectedColumnNames.size(); ++i) {
                type = HiveUtilities.getMajorTypeFromHiveTypeInfo(this.selectedColumnTypes.get(i), options);
                field = MaterializedField.create((SchemaPath)SchemaPath.getSimplePath((String)this.selectedColumnNames.get(i)), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)type.getMinorType(), (TypeProtos.DataMode)type.getMode());
                this.vectors.add(output.addField(field, vvClass));
            }
            for (i = 0; i < this.selectedPartitionNames.size(); ++i) {
                type = HiveUtilities.getMajorTypeFromHiveTypeInfo(this.selectedPartitionTypes.get(i), options);
                field = MaterializedField.create((SchemaPath)SchemaPath.getSimplePath((String)this.selectedPartitionNames.get(i)), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)field.getType().getMinorType(), (TypeProtos.DataMode)field.getDataMode());
                this.pVectors.add(output.addField(field, vvClass));
            }
        }
        catch (SchemaChangeException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int next() {
        for (ValueVector vv : this.vectors) {
            AllocationHelper.allocateNew((ValueVector)vv, (int)4000);
        }
        if (this.empty) {
            this.setValueCountAndPopulatePartitionVectors(0);
            return 0;
        }
        try {
            boolean status;
            Object deSerializedValue;
            int recordCount = 0;
            if (this.redoRecord != null) {
                deSerializedValue = this.serde.deserialize((Writable)this.redoRecord);
                status = this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, recordCount);
                if (!status) {
                    throw new DrillRuntimeException("Current record is too big to fit into allocated ValueVector buffer");
                }
                this.redoRecord = null;
                ++recordCount;
            }
            while (recordCount < 4000 && this.reader.next(this.key, this.value)) {
                deSerializedValue = this.serde.deserialize((Writable)this.value);
                status = this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, recordCount);
                if (!status) {
                    this.redoRecord = this.value;
                    this.setValueCountAndPopulatePartitionVectors(recordCount);
                    return recordCount;
                }
                ++recordCount;
            }
            this.setValueCountAndPopulatePartitionVectors(recordCount);
            return recordCount;
        }
        catch (IOException | SerDeException e) {
            throw new DrillRuntimeException(e);
        }
    }

    private boolean readHiveRecordAndInsertIntoRecordBatch(Object deSerializedValue, int outputRecordIndex) {
        for (int i = 0; i < this.selectedColumnNames.size(); ++i) {
            String columnName = this.selectedColumnNames.get(i);
            Object hiveValue = this.sInspector.getStructFieldData(deSerializedValue, this.sInspector.getStructFieldRef(columnName));
            if (hiveValue == null) continue;
            this.selectedColumnFieldConverters.get(i).setSafeValue(this.selectedColumnObjInspectors.get(i), hiveValue, this.vectors.get(i), outputRecordIndex);
        }
        return true;
    }

    private void setValueCountAndPopulatePartitionVectors(int recordCount) {
        for (ValueVector v : this.vectors) {
            v.getMutator().setValueCount(recordCount);
        }
        if (this.partition != null) {
            this.populatePartitionVectors(recordCount);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (Exception e) {
            logger.warn("Failure while closing Hive Record reader.", (Throwable)e);
        }
    }

    protected void populatePartitionVectors(int recordCount) {
        for (int i = 0; i < this.pVectors.size(); ++i) {
            ValueVector vector = this.pVectors.get(i);
            Object val = this.selectedPartitionValues.get(i);
            AllocationHelper.allocateNew((ValueVector)vector, (int)recordCount);
            if (val != null) {
                HiveUtilities.populateVector(vector, this.managedBuffer, val, 0, recordCount);
            }
            vector.getMutator().setValueCount(recordCount);
        }
    }
}

