/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveReadEntry {
    @JsonProperty(value="table")
    public HiveTable table;
    @JsonProperty(value="partitions")
    public List<HiveTable.HivePartition> partitions;
    @JsonProperty(value="hiveConfigOverride")
    public Map<String, String> hiveConfigOverride;
    @JsonIgnore
    private List<Partition> partitionsUnwrapped = Lists.newArrayList();

    @JsonCreator
    public HiveReadEntry(@JsonProperty(value="table") HiveTable table, @JsonProperty(value="partitions") List<HiveTable.HivePartition> partitions, @JsonProperty(value="hiveConfigOverride") Map<String, String> hiveConfigOverride) {
        this.table = table;
        this.partitions = partitions;
        if (partitions != null) {
            for (HiveTable.HivePartition part : partitions) {
                this.partitionsUnwrapped.add(part.getPartition());
            }
        }
        this.hiveConfigOverride = hiveConfigOverride;
    }

    @JsonIgnore
    public Table getTable() {
        return this.table.getTable();
    }

    @JsonIgnore
    public List<Partition> getPartitions() {
        return this.partitionsUnwrapped;
    }

    @JsonIgnore
    public HiveTable getHiveTableWrapper() {
        return this.table;
    }

    @JsonIgnore
    public List<HiveTable.HivePartition> getHivePartitionWrappers() {
        return this.partitions;
    }

    @JsonIgnore
    public Schema.TableType getJdbcTableType() {
        if (this.table.getTable().getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
            return Schema.TableType.VIEW;
        }
        return Schema.TableType.TABLE;
    }

    public String getPartitionLocation(HiveTable.HivePartition partition) {
        String partitionPath = this.table.getTable().getSd().getLocation();
        for (String value : partition.values) {
            partitionPath = partitionPath + "/" + value;
        }
        return partitionPath;
    }
}

