/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import com.google.common.collect.Lists;
import io.netty.buffer.DrillBuf;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.util.BitSets;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.AbstractPartitionDescriptor;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.HivePartitionLocation;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HivePartitionDescriptor
extends AbstractPartitionDescriptor {
    private final Map<String, Integer> partitionMap = new HashMap<String, Integer>();
    private final int numPartitionLevels;
    private final DrillScanRel scanRel;
    private final String defaultPartitionValue;
    private final DrillBuf managedBuffer;

    public HivePartitionDescriptor(PlannerSettings settings, DrillScanRel scanRel, DrillBuf managedBuffer, String defaultPartitionValue) {
        int i = 0;
        this.scanRel = scanRel;
        this.managedBuffer = managedBuffer.reallocIfNeeded(256);
        this.defaultPartitionValue = defaultPartitionValue;
        for (HiveTable.FieldSchemaWrapper wrapper : ((HiveScan)scanRel.getGroupScan()).hiveReadEntry.table.partitionKeys) {
            this.partitionMap.put(wrapper.name, i);
            ++i;
        }
        this.numPartitionLevels = i;
    }

    public int getPartitionHierarchyIndex(String partitionName) {
        return this.partitionMap.get(partitionName);
    }

    public boolean isPartitionName(String name) {
        return this.partitionMap.get(name) != null;
    }

    public int getMaxHierarchyLevel() {
        return this.numPartitionLevels;
    }

    public String getBaseTableLocation() {
        HiveReadEntry origEntry = ((HiveScan)this.scanRel.getGroupScan()).hiveReadEntry;
        return origEntry.table.getTable().getSd().getLocation();
    }

    public GroupScan createNewGroupScan(List<String> newFiles) throws ExecutionSetupException {
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        HiveReadEntry origReadEntry = hiveScan.hiveReadEntry;
        List<HiveTable.HivePartition> oldPartitions = origReadEntry.partitions;
        LinkedList<HiveTable.HivePartition> newPartitions = new LinkedList<HiveTable.HivePartition>();
        for (HiveTable.HivePartition part : oldPartitions) {
            String partitionLocation = part.getPartition().getSd().getLocation();
            for (String newPartitionLocation : newFiles) {
                if (!partitionLocation.equals(newPartitionLocation)) continue;
                newPartitions.add(part);
            }
        }
        HiveReadEntry newReadEntry = new HiveReadEntry(origReadEntry.table, newPartitions, origReadEntry.hiveConfigOverride);
        return hiveScan.clone(newReadEntry);
    }

    public void populatePartitionVectors(ValueVector[] vectors, List<PartitionLocation> partitions, BitSet partitionColumnBitSet, Map<Integer, String> fieldNameMap) {
        int record = 0;
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        Map<String, String> partitionNameTypeMap = hiveScan.hiveReadEntry.table.getPartitionNameTypeMap();
        for (PartitionLocation partitionLocation : partitions) {
            Iterator i$ = BitSets.toIter((BitSet)partitionColumnBitSet).iterator();
            while (i$.hasNext()) {
                int partitionColumnIndex = (Integer)i$.next();
                String hiveType = partitionNameTypeMap.get(fieldNameMap.get(partitionColumnIndex));
                Object value = HiveUtilities.convertPartitionType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType), partitionLocation.getPartitionValue(partitionColumnIndex), this.defaultPartitionValue);
                if (value == null) continue;
                HiveUtilities.populateVector(vectors[partitionColumnIndex], this.managedBuffer, value, record, record + 1);
            }
            ++record;
        }
        for (ValueVector v : vectors) {
            if (v == null) continue;
            v.getMutator().setValueCount(partitions.size());
        }
    }

    public TypeProtos.MajorType getVectorType(SchemaPath column, PlannerSettings plannerSettings) {
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        String partitionName = column.getAsNamePart().getName();
        Map<String, String> partitionNameTypeMap = hiveScan.hiveReadEntry.table.getPartitionNameTypeMap();
        String hiveType = partitionNameTypeMap.get(partitionName);
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType);
        TypeProtos.MinorType partitionType = HiveUtilities.getMinorTypeFromHivePrimitiveTypeInfo(primitiveTypeInfo, plannerSettings.getOptions());
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(partitionType).build();
    }

    public Integer getIdIfValid(String name) {
        return this.partitionMap.get(name);
    }

    protected void createPartitionSublists() {
        LinkedList<HivePartitionLocation> locations = new LinkedList<HivePartitionLocation>();
        HiveReadEntry origEntry = ((HiveScan)this.scanRel.getGroupScan()).hiveReadEntry;
        for (Partition partition : origEntry.getPartitions()) {
            locations.add(new HivePartitionLocation(partition.getValues(), partition.getSd().getLocation()));
        }
        this.locationSuperList = Lists.partition(locations, (int)65535);
        this.sublistsCreated = true;
    }
}

