/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.mongodb.BasicDBObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="mongo-shard-read")
public class MongoSubScan
extends AbstractBase
implements SubScan {
    static final Logger logger = LoggerFactory.getLogger(MongoSubScan.class);
    @JsonProperty
    private final MongoStoragePluginConfig mongoPluginConfig;
    @JsonIgnore
    private final MongoStoragePlugin mongoStoragePlugin;
    private final List<SchemaPath> columns;
    private final List<MongoSubScanSpec> chunkScanSpecList;

    @JsonCreator
    public MongoSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="mongoPluginConfig") StoragePluginConfig mongoPluginConfig, @JsonProperty(value="chunkScanSpecList") LinkedList<MongoSubScanSpec> chunkScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) throws ExecutionSetupException {
        super(userName);
        this.columns = columns;
        this.mongoPluginConfig = (MongoStoragePluginConfig)mongoPluginConfig;
        this.mongoStoragePlugin = (MongoStoragePlugin)registry.getPlugin(mongoPluginConfig);
        this.chunkScanSpecList = chunkScanSpecList;
    }

    public MongoSubScan(String userName, MongoStoragePlugin storagePlugin, MongoStoragePluginConfig storagePluginConfig, List<MongoSubScanSpec> chunkScanSpecList, List<SchemaPath> columns) {
        super(userName);
        this.mongoStoragePlugin = storagePlugin;
        this.mongoPluginConfig = storagePluginConfig;
        this.columns = columns;
        this.chunkScanSpecList = chunkScanSpecList;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    @JsonIgnore
    public MongoStoragePluginConfig getMongoPluginConfig() {
        return this.mongoPluginConfig;
    }

    @JsonIgnore
    public MongoStoragePlugin getMongoStoragePlugin() {
        return this.mongoStoragePlugin;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public List<MongoSubScanSpec> getChunkScanSpecList() {
        return this.chunkScanSpecList;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new MongoSubScan(this.getUserName(), this.mongoStoragePlugin, this.mongoPluginConfig, this.chunkScanSpecList, this.columns);
    }

    public int getOperatorType() {
        return 1009;
    }

    public Iterator<PhysicalOperator> iterator() {
        return Iterators.emptyIterator();
    }

    public static class MongoSubScanSpec {
        protected String dbName;
        protected String collectionName;
        protected List<String> hosts;
        protected Map<String, Object> minFilters;
        protected Map<String, Object> maxFilters;
        protected BasicDBObject filter;

        @JsonCreator
        public MongoSubScanSpec(@JsonProperty(value="dbName") String dbName, @JsonProperty(value="collectionName") String collectionName, @JsonProperty(value="hosts") List<String> hosts, @JsonProperty(value="minFilters") Map<String, Object> minFilters, @JsonProperty(value="maxFilters") Map<String, Object> maxFilters, @JsonProperty(value="filters") BasicDBObject filters) {
            this.dbName = dbName;
            this.collectionName = collectionName;
            this.hosts = hosts;
            this.minFilters = minFilters;
            this.maxFilters = maxFilters;
            this.filter = filters;
        }

        MongoSubScanSpec() {
        }

        public String getDbName() {
            return this.dbName;
        }

        public MongoSubScanSpec setDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public String getCollectionName() {
            return this.collectionName;
        }

        public MongoSubScanSpec setCollectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public List<String> getHosts() {
            return this.hosts;
        }

        public MongoSubScanSpec setHosts(List<String> hosts) {
            this.hosts = hosts;
            return this;
        }

        public Map<String, Object> getMinFilters() {
            return this.minFilters;
        }

        public MongoSubScanSpec setMinFilters(Map<String, Object> minFilters) {
            this.minFilters = minFilters;
            return this;
        }

        public Map<String, Object> getMaxFilters() {
            return this.maxFilters;
        }

        public MongoSubScanSpec setMaxFilters(Map<String, Object> maxFilters) {
            this.maxFilters = maxFilters;
            return this;
        }

        public BasicDBObject getFilter() {
            return this.filter;
        }

        public MongoSubScanSpec setFilter(BasicDBObject filter) {
            this.filter = filter;
            return this;
        }

        public String toString() {
            return "MongoSubScanSpec [dbName=" + this.dbName + ", collectionName=" + this.collectionName + ", hosts=" + this.hosts + ", minFilters=" + this.minFilters + ", maxFilters=" + this.maxFilters + ", filter=" + this.filter + "]";
        }
    }
}

