/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.exec.store.mongo.MongoUtils;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(MongoRecordReader.class);
    private MongoCollection<Document> collection;
    private MongoCursor<Document> cursor;
    private JsonReader jsonReader;
    private VectorContainerWriter writer;
    private BasicDBObject filters;
    private final BasicDBObject fields = new BasicDBObject();
    private final FragmentContext fragmentContext;
    private OperatorContext operatorContext;
    private final MongoStoragePlugin plugin;
    private final boolean enableAllTextMode;
    private final boolean readNumbersAsDouble;
    private boolean unionEnabled;

    public MongoRecordReader(MongoSubScan.MongoSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, FragmentContext context, MongoStoragePlugin plugin) {
        this.fields.put((Object)"_id", (Object)0);
        this.setColumns(projectedColumns);
        this.fragmentContext = context;
        this.plugin = plugin;
        this.filters = new BasicDBObject();
        Map<String, List<BasicDBObject>> mergedFilters = MongoUtils.mergeFilters(subScanSpec.getMinFilters(), subScanSpec.getMaxFilters());
        this.buildFilters(subScanSpec.getFilter(), mergedFilters);
        this.enableAllTextMode = this.fragmentContext.getOptions().getOption((String)"store.mongo.all_text_mode").bool_val;
        this.readNumbersAsDouble = this.fragmentContext.getOptions().getOption((String)"store.mongo.read_numbers_as_double").bool_val;
        this.init(subScanSpec);
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projectedColumns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (!this.isStarQuery()) {
            for (SchemaPath column : projectedColumns) {
                String fieldName = column.getRootSegment().getPath();
                transformed.add(column);
                this.fields.put((Object)fieldName, (Object)1);
            }
        } else {
            this.fields.remove((Object)"_id");
            transformed.add(AbstractRecordReader.STAR_COLUMN);
        }
        return transformed;
    }

    private void buildFilters(BasicDBObject pushdownFilters, Map<String, List<BasicDBObject>> mergedFilters) {
        for (Map.Entry<String, List<BasicDBObject>> entry : mergedFilters.entrySet()) {
            List<BasicDBObject> list = entry.getValue();
            if (list.size() == 1) {
                this.filters.putAll(list.get(0).toMap());
                continue;
            }
            BasicDBObject andQueryFilter = new BasicDBObject();
            andQueryFilter.put((Object)"$and", list);
            this.filters.putAll(andQueryFilter.toMap());
        }
        if (pushdownFilters != null && !pushdownFilters.toMap().isEmpty()) {
            this.filters = !mergedFilters.isEmpty() ? MongoUtils.andFilterAtIndex(this.filters, pushdownFilters) : pushdownFilters;
        }
    }

    private void init(MongoSubScan.MongoSubScanSpec subScanSpec) {
        List<String> hosts = subScanSpec.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : hosts) {
            addresses.add(new ServerAddress(host));
        }
        MongoClient client = this.plugin.getClient(addresses);
        MongoDatabase db = client.getDatabase(subScanSpec.getDbName());
        this.collection = db.getCollection(subScanSpec.getCollectionName());
        this.unionEnabled = this.fragmentContext.getOptions().getOption(ExecConstants.ENABLE_UNION_TYPE);
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        this.operatorContext = context;
        this.writer = new VectorContainerWriter(output, this.unionEnabled);
        this.jsonReader = new JsonReader(this.fragmentContext.getManagedBuffer(), (List)Lists.newArrayList((Iterable)this.getColumns()), this.enableAllTextMode, false, this.readNumbersAsDouble);
    }

    public int next() {
        int docCount;
        if (this.cursor == null) {
            logger.info("Filters Applied : " + this.filters);
            logger.info("Fields Selected :" + this.fields);
            this.cursor = this.collection.find((Bson)this.filters).projection((Bson)this.fields).batchSize(100).iterator();
        }
        this.writer.allocate();
        this.writer.reset();
        Stopwatch watch = new Stopwatch();
        watch.start();
        try {
            for (docCount = 0; docCount < 4096 && this.cursor.hasNext(); ++docCount) {
                this.writer.setPosition(docCount);
                String doc = ((Document)this.cursor.next()).toJson();
                this.jsonReader.setSource(doc.getBytes(Charsets.UTF_8));
                this.jsonReader.write((BaseWriter.ComplexWriter)this.writer);
            }
            this.jsonReader.ensureAtLeastOneField((BaseWriter.ComplexWriter)this.writer);
            this.writer.setValueCount(docCount);
            logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)docCount);
            return docCount;
        }
        catch (IOException e) {
            String msg = "Failure while reading document. - Parser was at record: " + (docCount + 1);
            logger.error(msg, (Throwable)e);
            throw new DrillRuntimeException(msg, (Throwable)e);
        }
    }

    public void close() {
    }
}

