/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.remote.TypedValue;

public interface Meta {
    public Map<DatabaseProperty, Object> getDatabaseProperties();

    public MetaResultSet getTables(String var1, Pat var2, Pat var3, List<String> var4);

    public MetaResultSet getColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getSchemas(String var1, Pat var2);

    public MetaResultSet getCatalogs();

    public MetaResultSet getTableTypes();

    public MetaResultSet getProcedures(String var1, Pat var2, Pat var3);

    public MetaResultSet getProcedureColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getColumnPrivileges(String var1, String var2, String var3, Pat var4);

    public MetaResultSet getTablePrivileges(String var1, Pat var2, Pat var3);

    public MetaResultSet getBestRowIdentifier(String var1, String var2, String var3, int var4, boolean var5);

    public MetaResultSet getVersionColumns(String var1, String var2, String var3);

    public MetaResultSet getPrimaryKeys(String var1, String var2, String var3);

    public MetaResultSet getImportedKeys(String var1, String var2, String var3);

    public MetaResultSet getExportedKeys(String var1, String var2, String var3);

    public MetaResultSet getCrossReference(String var1, String var2, String var3, String var4, String var5, String var6);

    public MetaResultSet getTypeInfo();

    public MetaResultSet getIndexInfo(String var1, String var2, String var3, boolean var4, boolean var5);

    public MetaResultSet getUDTs(String var1, Pat var2, Pat var3, int[] var4);

    public MetaResultSet getSuperTypes(String var1, Pat var2, Pat var3);

    public MetaResultSet getSuperTables(String var1, Pat var2, Pat var3);

    public MetaResultSet getAttributes(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getClientInfoProperties();

    public MetaResultSet getFunctions(String var1, Pat var2, Pat var3);

    public MetaResultSet getFunctionColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getPseudoColumns(String var1, Pat var2, Pat var3, Pat var4);

    public Iterable<Object> createIterable(StatementHandle var1, Signature var2, List<TypedValue> var3, Frame var4);

    public StatementHandle prepare(ConnectionHandle var1, String var2, long var3);

    public ExecuteResult prepareAndExecute(StatementHandle var1, String var2, long var3, PrepareCallback var5);

    public Frame fetch(StatementHandle var1, List<TypedValue> var2, long var3, int var5);

    public StatementHandle createStatement(ConnectionHandle var1);

    public void closeStatement(StatementHandle var1);

    public void closeConnection(ConnectionHandle var1);

    public ConnectionProperties connectionSync(ConnectionHandle var1, ConnectionProperties var2);

    public static interface PrepareCallback {
        public Object getMonitor();

        public void clear() throws SQLException;

        public void assign(Signature var1, Frame var2, long var3) throws SQLException;

        public void execute() throws SQLException;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="connProps", defaultImpl=ConnectionPropertiesImpl.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionPropertiesImpl.class, name="connPropsImpl")})
    public static interface ConnectionProperties {
        public ConnectionProperties merge(ConnectionProperties var1);

        @JsonIgnore
        public boolean isEmpty();

        public ConnectionProperties setAutoCommit(boolean var1);

        public Boolean isAutoCommit();

        public ConnectionProperties setReadOnly(boolean var1);

        public Boolean isReadOnly();

        public ConnectionProperties setTransactionIsolation(int var1);

        public Integer getTransactionIsolation();

        public ConnectionProperties setCatalog(String var1);

        public String getCatalog();

        public ConnectionProperties setSchema(String var1);

        public String getSchema();
    }

    public static class StatementHandle {
        public final String connectionId;
        public final int id;
        public Signature signature;

        public String toString() {
            return this.connectionId + "::" + Integer.toString(this.id);
        }

        @JsonCreator
        public StatementHandle(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="id") int id, @JsonProperty(value="signature") Signature signature) {
            this.connectionId = connectionId;
            this.id = id;
            this.signature = signature;
        }
    }

    public static class ConnectionHandle {
        public final String id;

        public String toString() {
            return this.id;
        }

        @JsonCreator
        public ConnectionHandle(@JsonProperty(value="id") String id) {
            this.id = id;
        }
    }

    public static class Frame {
        public static final Frame EMPTY = new Frame(0L, true, Collections.emptyList());
        public static final Frame MORE = new Frame(0L, false, Collections.emptyList());
        public final long offset;
        public final boolean done;
        public final Iterable<Object> rows;

        public Frame(long offset, boolean done, Iterable<Object> rows) {
            this.offset = offset;
            this.done = done;
            this.rows = rows;
        }

        @JsonCreator
        public static Frame create(@JsonProperty(value="offset") int offset, @JsonProperty(value="done") boolean done, @JsonProperty(value="rows") List<Object> rows) {
            if (offset == 0 && done && rows.isEmpty()) {
                return EMPTY;
            }
            return new Frame(offset, done, rows);
        }
    }

    public static class Signature {
        public final List<ColumnMetaData> columns;
        public final String sql;
        public final List<AvaticaParameter> parameters;
        public final transient Map<String, Object> internalParameters;
        public final CursorFactory cursorFactory;

        public Signature(List<ColumnMetaData> columns, String sql, List<AvaticaParameter> parameters, Map<String, Object> internalParameters, CursorFactory cursorFactory) {
            this.columns = columns;
            this.sql = sql;
            this.parameters = parameters;
            this.internalParameters = internalParameters;
            this.cursorFactory = cursorFactory;
        }

        @JsonCreator
        public static Signature create(@JsonProperty(value="columns") List<ColumnMetaData> columns, @JsonProperty(value="sql") String sql, @JsonProperty(value="parameters") List<AvaticaParameter> parameters, @JsonProperty(value="cursorFactory") CursorFactory cursorFactory) {
            return new Signature(columns, sql, parameters, Collections.emptyMap(), cursorFactory);
        }

        public Signature setCursorFactory(CursorFactory cursorFactory) {
            return new Signature(this.columns, this.sql, this.parameters, this.internalParameters, cursorFactory);
        }

        public Signature sanitize() {
            if (this.columns == null || this.parameters == null || this.internalParameters == null) {
                return new Signature(this.sanitize(this.columns), this.sql, this.sanitize(this.parameters), this.sanitize(this.internalParameters), this.cursorFactory);
            }
            return this;
        }

        private <E> List<E> sanitize(List<E> list) {
            return list == null ? Collections.emptyList() : list;
        }

        private <K, V> Map<K, V> sanitize(Map<K, V> map) {
            return map == null ? Collections.emptyMap() : map;
        }
    }

    public static enum Style {
        OBJECT,
        RECORD,
        RECORD_PROJECTION,
        ARRAY,
        LIST,
        MAP;

    }

    public static final class CursorFactory {
        public final Style style;
        public final Class clazz;
        @JsonIgnore
        public final List<Field> fields;
        public final List<String> fieldNames;
        public static final CursorFactory OBJECT = new CursorFactory(Style.OBJECT, null, null, null);
        public static final CursorFactory ARRAY = new CursorFactory(Style.ARRAY, null, null, null);
        public static final CursorFactory LIST = new CursorFactory(Style.LIST, null, null, null);

        private CursorFactory(Style style, Class clazz, List<Field> fields, List<String> fieldNames) {
            assert (fieldNames != null == (style == Style.RECORD_PROJECTION || style == Style.MAP));
            assert (fields != null == (style == Style.RECORD_PROJECTION));
            this.style = Objects.requireNonNull(style);
            this.clazz = clazz;
            this.fields = fields;
            this.fieldNames = fieldNames;
        }

        @JsonCreator
        public static CursorFactory create(@JsonProperty(value="style") Style style, @JsonProperty(value="clazz") Class clazz, @JsonProperty(value="fieldNames") List<String> fieldNames) {
            switch (style) {
                case OBJECT: {
                    return OBJECT;
                }
                case ARRAY: {
                    return ARRAY;
                }
                case LIST: {
                    return LIST;
                }
                case RECORD: {
                    return CursorFactory.record(clazz);
                }
                case RECORD_PROJECTION: {
                    return CursorFactory.record(clazz, null, fieldNames);
                }
                case MAP: {
                    return CursorFactory.map(fieldNames);
                }
            }
            throw new AssertionError((Object)("unknown style: " + (Object)((Object)style)));
        }

        public static CursorFactory record(Class resultClazz) {
            return new CursorFactory(Style.RECORD, resultClazz, null, null);
        }

        public static CursorFactory record(Class resultClass, List<Field> fields, List<String> fieldNames) {
            if (fields == null) {
                fields = new ArrayList<Field>();
                for (String fieldName : fieldNames) {
                    try {
                        fields.add(resultClass.getField(fieldName));
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new CursorFactory(Style.RECORD_PROJECTION, resultClass, fields, fieldNames);
        }

        public static CursorFactory map(List<String> fieldNames) {
            return new CursorFactory(Style.MAP, null, null, fieldNames);
        }

        public static CursorFactory deduce(List<ColumnMetaData> columns, Class resultClazz) {
            if (columns.size() == 1) {
                return OBJECT;
            }
            if (resultClazz != null && !resultClazz.isArray()) {
                return CursorFactory.record(resultClazz);
            }
            return ARRAY;
        }
    }

    public static class MetaResultSet {
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Frame firstFrame;
        public final Signature signature;
        public final long updateCount;

        @Deprecated
        protected MetaResultSet(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame, int updateCount) {
            this(connectionId, statementId, ownStatement, signature, firstFrame, (long)updateCount);
        }

        protected MetaResultSet(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame, long updateCount) {
            this.signature = signature;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
        }

        public static MetaResultSet create(String connectionId, int statementId, boolean ownStatement, Signature signature, Frame firstFrame) {
            return new MetaResultSet(connectionId, statementId, ownStatement, Objects.requireNonNull(signature), firstFrame, -1L);
        }

        public static MetaResultSet count(String connectionId, int statementId, long updateCount) {
            assert (updateCount >= 0L);
            return new MetaResultSet(connectionId, statementId, false, null, null, updateCount);
        }
    }

    public static class ExecuteResult {
        public final List<MetaResultSet> resultSets;

        public ExecuteResult(List<MetaResultSet> resultSets) {
            this.resultSets = resultSets;
        }
    }

    public static final class DatabaseProperty
    extends Enum<DatabaseProperty> {
        public static final /* enum */ DatabaseProperty GET_NUMERIC_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_STRING_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_SYSTEM_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_TIME_DATE_FUNCTIONS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_S_Q_L_KEYWORDS = new DatabaseProperty("");
        public static final /* enum */ DatabaseProperty GET_DEFAULT_TRANSACTION_ISOLATION = new DatabaseProperty(0);
        public final Class<?> type;
        public final Object defaultValue;
        public final Method method;
        private static final /* synthetic */ DatabaseProperty[] $VALUES;

        public static DatabaseProperty[] values() {
            return (DatabaseProperty[])$VALUES.clone();
        }

        public static DatabaseProperty valueOf(String name) {
            return Enum.valueOf(DatabaseProperty.class, name);
        }

        private <T> DatabaseProperty(T defaultValue) {
            this.defaultValue = defaultValue;
            String methodName = AvaticaUtils.toCamelCase(this.name());
            try {
                this.method = DatabaseMetaData.class.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.type = AvaticaUtils.box(this.method.getReturnType());
            assert (defaultValue == null || defaultValue.getClass() == this.type);
        }

        public <T> T getProp(Meta meta, Class<T> aClass) {
            return this.getProp(meta.getDatabaseProperties(), aClass);
        }

        public <T> T getProp(Map<DatabaseProperty, Object> map, Class<T> aClass) {
            assert (aClass == this.type);
            Object v = map.get((Object)this);
            if (v == null) {
                v = this.defaultValue;
            }
            return aClass.cast(v);
        }

        static {
            $VALUES = new DatabaseProperty[]{GET_NUMERIC_FUNCTIONS, GET_STRING_FUNCTIONS, GET_SYSTEM_FUNCTIONS, GET_TIME_DATE_FUNCTIONS, GET_S_Q_L_KEYWORDS, GET_DEFAULT_TRANSACTION_ISOLATION};
        }
    }

    public static class Pat {
        public final String s;

        private Pat(String s) {
            this.s = s;
        }

        @JsonCreator
        public static Pat of(@JsonProperty(value="s") String name) {
            return new Pat(name);
        }
    }

    public static interface Factory {
        public Meta create(List<String> var1);
    }
}

