/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.config;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import java.io.IOException;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.mongo.config.MongoPStore;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.PStoreRegistry;
import org.apache.drill.exec.store.sys.local.LocalEStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPStoreProvider
implements PStoreProvider,
DrillMongoConstants {
    static final Logger logger = LoggerFactory.getLogger(MongoPStoreProvider.class);
    static final String pKey = "pKey";
    private MongoClient client;
    private DBCollection collection;
    private final String mongoURL;
    private final LocalEStoreProvider localEStoreProvider;

    public MongoPStoreProvider(PStoreRegistry registry) {
        this.mongoURL = registry.getConfig().getString("drill.exec.sys.store.provider.mongo.url");
        this.localEStoreProvider = new LocalEStoreProvider();
    }

    public void start() throws IOException {
        MongoClientURI clientURI = new MongoClientURI(this.mongoURL);
        this.client = new MongoClient(clientURI);
        DB db = this.client.getDB(clientURI.getDatabase());
        this.collection = db.getCollection(clientURI.getCollection());
        this.collection.setWriteConcern(WriteConcern.JOURNALED);
        BasicDBObject index = new BasicDBObject(1).append(pKey, (Object)1);
        this.collection.createIndex((DBObject)index);
    }

    public <V> PStore<V> getStore(PStoreConfig<V> config) throws IOException {
        switch (config.getMode()) {
            case BLOB_PERSISTENT: 
            case PERSISTENT: {
                return new MongoPStore<V>(config, this.collection);
            }
            case EPHEMERAL: {
                return this.localEStoreProvider.getStore(config);
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

