/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.config;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPStore<V>
implements PStore<V>,
DrillMongoConstants {
    static final Logger logger = LoggerFactory.getLogger(MongoPStore.class);
    private final PStoreConfig<V> config;
    private final DBCollection collection;

    public MongoPStore(PStoreConfig<V> config, DBCollection collection) throws IOException {
        throw new UnsupportedOperationException("Mongo DB PStore not currently supported");
    }

    public V get(String key) {
        try {
            BasicDBObject get = new BasicDBObject().append("_id", (Object)key);
            DBCursor cursor = this.collection.find((DBObject)get);
            if (cursor != null && cursor.hasNext()) {
                return this.value((byte[])cursor.next().get("pKey"));
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void put(String key, V value) {
        try {
            BasicDBObject putObj = new BasicDBObject(2);
            putObj.put("_id", (Object)key);
            putObj.put("pKey", (Object)this.bytes(value));
            this.collection.insert(new DBObject[]{putObj});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean putIfAbsent(String key, V value) {
        try {
            BasicDBObject check = new BasicDBObject(1).append("_id", (Object)key);
            BasicDBObject putObj = new BasicDBObject(2);
            putObj.put("pKey", (Object)this.bytes(value));
            WriteResult wr = this.collection.update((DBObject)check, (DBObject)putObj, true, false);
            return wr.getN() == 1;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(String key) {
        try {
            BasicDBObject delete = new BasicDBObject(1).append("_id", (Object)key);
            this.collection.remove((DBObject)delete);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] bytes(V value) {
        try {
            return this.config.getSerializer().serialize(value);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private V value(byte[] serialize) {
        try {
            return (V)this.config.getSerializer().deserialize(serialize);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Iterator<Map.Entry<String, V>> iterator() {
        return new MongoIterator();
    }

    public void close() {
    }

    private class DeferredEntry
    implements Map.Entry<String, V> {
        private DBObject result;

        public DeferredEntry(DBObject result) {
            this.result = result;
        }

        @Override
        public String getKey() {
            return this.result.get("_id").toString();
        }

        @Override
        public V getValue() {
            return MongoPStore.this.get(this.result.get("_id").toString());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class MongoIterator
    implements Iterator<Map.Entry<String, V>> {
        private DBCursor cursor;

        public MongoIterator() {
            this.cursor = MongoPStore.this.collection.find();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new DeferredEntry(this.cursor.next());
        }

        @Override
        public void remove() {
            this.cursor.remove();
        }
    }
}

