/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.exec.store.mongo.common.ChunkInfo;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.org.codehaus.jackson.annotate.JsonCreator;

@JsonTypeName(value="mongo-scan")
public class MongoGroupScan
extends AbstractGroupScan
implements DrillMongoConstants {
    private static final Integer select = 1;
    static final Logger logger = LoggerFactory.getLogger(MongoGroupScan.class);
    private static final Comparator<List<MongoSubScan.MongoSubScanSpec>> LIST_SIZE_COMPARATOR = new Comparator<List<MongoSubScan.MongoSubScanSpec>>(){

        @Override
        public int compare(List<MongoSubScan.MongoSubScanSpec> list1, List<MongoSubScan.MongoSubScanSpec> list2) {
            return list1.size() - list2.size();
        }
    };
    private static final Comparator<List<MongoSubScan.MongoSubScanSpec>> LIST_SIZE_COMPARATOR_REV = Collections.reverseOrder(LIST_SIZE_COMPARATOR);
    private MongoStoragePlugin storagePlugin;
    private MongoStoragePluginConfig storagePluginConfig;
    private MongoScanSpec scanSpec;
    private List<SchemaPath> columns;
    private Map<Integer, List<MongoSubScan.MongoSubScanSpec>> endpointFragmentMapping;
    private Map<String, Set<ServerAddress>> chunksMapping;
    private Map<String, List<ChunkInfo>> chunksInverseMapping;
    private Stopwatch watch = new Stopwatch();
    private boolean filterPushedDown = false;

    @JsonCreator
    public MongoGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="mongoScanSpec") MongoScanSpec scanSpec, @JsonProperty(value="storage") MongoStoragePluginConfig storagePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException, ExecutionSetupException {
        this(userName, (MongoStoragePlugin)pluginRegistry.getPlugin((StoragePluginConfig)storagePluginConfig), scanSpec, columns);
    }

    public MongoGroupScan(String userName, MongoStoragePlugin storagePlugin, MongoScanSpec scanSpec, List<SchemaPath> columns) throws IOException {
        super(userName);
        this.storagePlugin = storagePlugin;
        this.storagePluginConfig = storagePlugin.getConfig();
        this.scanSpec = scanSpec;
        this.columns = columns;
        this.storagePluginConfig.getConnection();
        this.init();
    }

    private MongoGroupScan(MongoGroupScan that) {
        super((AbstractGroupScan)that);
        this.scanSpec = that.scanSpec;
        this.columns = that.columns;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginConfig = that.storagePluginConfig;
        this.chunksMapping = that.chunksMapping;
        this.chunksInverseMapping = that.chunksInverseMapping;
        this.endpointFragmentMapping = that.endpointFragmentMapping;
        this.filterPushedDown = that.filterPushedDown;
    }

    @JsonIgnore
    public boolean isFilterPushedDown() {
        return this.filterPushedDown;
    }

    @JsonIgnore
    public void setFilterPushedDown(boolean filterPushedDown) {
        this.filterPushedDown = filterPushedDown;
    }

    private boolean isShardedCluster(MongoClient client) {
        MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
        String msg = db.runCommand((Bson)new Document("isMaster", (Object)1)).getString((Object)"msg");
        return msg == null ? false : msg.equals("isdbgrid");
    }

    private void init() throws IOException {
        List<String> h = this.storagePluginConfig.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : h) {
            addresses.add(new ServerAddress(host));
        }
        MongoClient client = this.storagePlugin.getClient();
        this.chunksMapping = Maps.newHashMap();
        this.chunksInverseMapping = Maps.newLinkedHashMap();
        if (this.isShardedCluster(client)) {
            MongoDatabase db = client.getDatabase("config");
            MongoCollection chunksCollection = db.getCollection("chunks");
            Document filter = new Document();
            filter.put("ns", (Object)(this.scanSpec.getDbName() + "." + this.scanSpec.getCollectionName()));
            Document projection = new Document();
            projection.put("shard", (Object)select);
            projection.put("min", (Object)select);
            projection.put("max", (Object)select);
            FindIterable chunkCursor = chunksCollection.find((Bson)filter).projection((Bson)projection);
            MongoCursor iterator = chunkCursor.iterator();
            MongoCollection shardsCollection = db.getCollection("shards");
            projection = new Document();
            projection.put("host", (Object)select);
            while (iterator.hasNext()) {
                Document chunkObj = (Document)iterator.next();
                String shardName = (String)chunkObj.get((Object)"shard");
                String chunkId = (String)chunkObj.get((Object)"_id");
                filter = new Document("_id", (Object)shardName);
                FindIterable hostCursor = shardsCollection.find((Bson)filter).projection((Bson)projection);
                for (Document hostObj : hostCursor) {
                    String hostEntry = (String)hostObj.get((Object)"host");
                    String[] tagAndHost = StringUtils.split((String)hostEntry, (char)'/');
                    String[] hosts = tagAndHost.length > 1 ? StringUtils.split((String)tagAndHost[1], (char)',') : StringUtils.split((String)tagAndHost[0], (char)',');
                    List<String> chunkHosts = Arrays.asList(hosts);
                    HashSet addressList = this.getPreferredHosts(this.storagePlugin.getClient(addresses), chunkHosts);
                    if (addressList == null) {
                        addressList = Sets.newHashSet();
                        for (String host : chunkHosts) {
                            addressList.add(new ServerAddress(host));
                        }
                    }
                    this.chunksMapping.put(chunkId, addressList);
                    ServerAddress address = (ServerAddress)addressList.iterator().next();
                    ArrayList chunkList = this.chunksInverseMapping.get(address.getHost());
                    if (chunkList == null) {
                        chunkList = Lists.newArrayList();
                        this.chunksInverseMapping.put(address.getHost(), chunkList);
                    }
                    ArrayList<String> chunkHostsList = new ArrayList<String>();
                    for (ServerAddress serverAddr : addressList) {
                        chunkHostsList.add(serverAddr.toString());
                    }
                    ChunkInfo chunkInfo = new ChunkInfo(chunkHostsList, chunkId);
                    Document minMap = (Document)chunkObj.get((Object)"min");
                    HashMap minFilters = Maps.newHashMap();
                    Set keySet = minMap.keySet();
                    for (Object keyObj : keySet) {
                        Object object = minMap.get(keyObj);
                        if (object instanceof MinKey) continue;
                        minFilters.put(keyObj.toString(), object);
                    }
                    chunkInfo.setMinFilters(minFilters);
                    HashMap maxFilters = Maps.newHashMap();
                    Document maxMap = (Document)chunkObj.get((Object)"max");
                    keySet = maxMap.keySet();
                    for (Object keyObj : keySet) {
                        Object object = maxMap.get(keyObj);
                        if (object instanceof MaxKey) continue;
                        maxFilters.put(keyObj.toString(), object);
                    }
                    chunkInfo.setMaxFilters(maxFilters);
                    chunkList.add(chunkInfo);
                }
            }
        } else {
            String chunkName = this.scanSpec.getDbName() + "." + this.scanSpec.getCollectionName();
            List<String> hosts = this.storagePluginConfig.getHosts();
            HashSet addressList = this.getPreferredHosts(client, hosts);
            if (addressList == null) {
                addressList = Sets.newHashSet();
                for (String host : hosts) {
                    addressList.add(new ServerAddress(host));
                }
            }
            this.chunksMapping.put(chunkName, addressList);
            String host = hosts.get(0);
            ServerAddress address = new ServerAddress(host);
            ChunkInfo chunkInfo = new ChunkInfo(hosts, chunkName);
            chunkInfo.setMinFilters(Collections.emptyMap());
            chunkInfo.setMaxFilters(Collections.emptyMap());
            ArrayList chunksList = Lists.newArrayList();
            chunksList.add(chunkInfo);
            this.chunksInverseMapping.put(address.getHost(), chunksList);
        }
    }

    private Set<ServerAddress> getPreferredHosts(MongoClient client, List<String> hosts) {
        HashSet addressList = Sets.newHashSet();
        MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
        ReadPreference readPreference = client.getReadPreference();
        Document command = db.runCommand((Bson)new Document("isMaster", (Object)1));
        String primaryHost = command.getString((Object)"primary");
        List hostsList = (List)command.get((Object)"hosts");
        switch (readPreference.getName().toUpperCase()) {
            case "PRIMARY": 
            case "PRIMARYPREFERRED": {
                if (primaryHost == null) {
                    return null;
                }
                addressList.add(new ServerAddress(primaryHost));
                return addressList;
            }
            case "SECONDARY": 
            case "SECONDARYPREFERRED": {
                if (primaryHost == null || hostsList == null) {
                    return null;
                }
                hostsList.remove(primaryHost);
                for (String host : hostsList) {
                    addressList.add(new ServerAddress(host));
                }
                return addressList;
            }
            case "NEAREST": {
                if (hostsList == null) {
                    return null;
                }
                for (String host : hostsList) {
                    addressList.add(new ServerAddress(host));
                }
                return addressList;
            }
        }
        return null;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        MongoGroupScan clone = new MongoGroupScan(this);
        clone.columns = columns;
        return clone;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
        logger.debug("Incoming endpoints :" + endpoints);
        this.watch.reset();
        this.watch.start();
        int numSlots = endpoints.size();
        int totalAssignmentsTobeDone = this.chunksMapping.size();
        Preconditions.checkArgument((numSlots <= totalAssignmentsTobeDone ? 1 : 0) != 0, (Object)String.format("Incoming endpoints %d is greater than number of chunks %d", numSlots, totalAssignmentsTobeDone));
        int minPerEndpointSlot = (int)Math.floor((double)totalAssignmentsTobeDone / (double)numSlots);
        int maxPerEndpointSlot = (int)Math.ceil((double)totalAssignmentsTobeDone / (double)numSlots);
        this.endpointFragmentMapping = Maps.newHashMapWithExpectedSize((int)numSlots);
        HashMap endpointHostIndexListMap = Maps.newHashMap();
        for (int i = 0; i < numSlots; ++i) {
            this.endpointFragmentMapping.put(i, new ArrayList(maxPerEndpointSlot));
            String hostname = endpoints.get(i).getAddress();
            Queue hostIndexQueue = (Queue)endpointHostIndexListMap.get(hostname);
            if (hostIndexQueue == null) {
                hostIndexQueue = Lists.newLinkedList();
                endpointHostIndexListMap.put(hostname, hostIndexQueue);
            }
            hostIndexQueue.add(i);
        }
        HashSet chunksToAssignSet = Sets.newHashSet(this.chunksInverseMapping.entrySet());
        Iterator chunksIterator = chunksToAssignSet.iterator();
        while (chunksIterator.hasNext()) {
            Map.Entry chunkEntry = (Map.Entry)chunksIterator.next();
            Queue slots = (Queue)endpointHostIndexListMap.get(chunkEntry.getKey());
            if (slots == null) continue;
            for (ChunkInfo chunkInfo : (List)chunkEntry.getValue()) {
                Integer slotIndex = (Integer)slots.poll();
                List<MongoSubScan.MongoSubScanSpec> subScanSpecList = this.endpointFragmentMapping.get(slotIndex);
                subScanSpecList.add(this.buildSubScanSpecAndGet(chunkInfo));
                slots.offer(slotIndex);
            }
            chunksIterator.remove();
        }
        PriorityQueue<List<MongoSubScan.MongoSubScanSpec>> minHeap = new PriorityQueue<List<MongoSubScan.MongoSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR);
        PriorityQueue<List<MongoSubScan.MongoSubScanSpec>> maxHeap = new PriorityQueue<List<MongoSubScan.MongoSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR_REV);
        for (List<MongoSubScan.MongoSubScanSpec> listOfScan : this.endpointFragmentMapping.values()) {
            if (listOfScan.size() < minPerEndpointSlot) {
                minHeap.offer(listOfScan);
                continue;
            }
            if (listOfScan.size() <= minPerEndpointSlot) continue;
            maxHeap.offer(listOfScan);
        }
        if (chunksToAssignSet.size() > 0) {
            for (Map.Entry chunkEntry : chunksToAssignSet) {
                for (ChunkInfo chunkInfo : (List)chunkEntry.getValue()) {
                    List<MongoSubScan.MongoSubScanSpec> smallestList = minHeap.poll();
                    smallestList.add(this.buildSubScanSpecAndGet(chunkInfo));
                    minHeap.offer(smallestList);
                }
            }
        }
        while (minHeap.peek() != null && minHeap.peek().size() < minPerEndpointSlot) {
            List<MongoSubScan.MongoSubScanSpec> smallestList = minHeap.poll();
            List<MongoSubScan.MongoSubScanSpec> largestList = maxHeap.poll();
            smallestList.add(largestList.remove(largestList.size() - 1));
            if (largestList.size() > minPerEndpointSlot) {
                maxHeap.offer(largestList);
            }
            if (smallestList.size() >= minPerEndpointSlot) continue;
            minHeap.offer(smallestList);
        }
        logger.debug("Built assignment map in {} \u00b5s.\nEndpoints: {}.\nAssignment Map: {}", new Object[]{this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L, endpoints, this.endpointFragmentMapping.toString()});
    }

    private MongoSubScan.MongoSubScanSpec buildSubScanSpecAndGet(ChunkInfo chunkInfo) {
        MongoSubScan.MongoSubScanSpec subScanSpec = new MongoSubScan.MongoSubScanSpec().setDbName(this.scanSpec.getDbName()).setCollectionName(this.scanSpec.getCollectionName()).setHosts(chunkInfo.getChunkLocList()).setMinFilters(chunkInfo.getMinFilters()).setMaxFilters(chunkInfo.getMaxFilters()).setFilter(this.scanSpec.getFilters());
        return subScanSpec;
    }

    public MongoSubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        return new MongoSubScan(this.getUserName(), this.storagePlugin, this.storagePluginConfig, this.endpointFragmentMapping.get(minorFragmentId), this.columns);
    }

    public int getMaxParallelizationWidth() {
        return this.chunksMapping.size();
    }

    public String getDigest() {
        return this.toString();
    }

    public ScanStats getScanStats() {
        try {
            MongoClient client = this.storagePlugin.getClient();
            MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
            MongoCollection collection = db.getCollection(this.scanSpec.getCollectionName());
            String json = ((Document)collection.find().first()).toJson();
            float approxDiskCost = (long)json.getBytes().length * collection.count();
            return new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, collection.count(), 1.0f, approxDiskCost);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new MongoGroupScan(this);
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        this.watch.reset();
        this.watch.start();
        HashMap endpointMap = Maps.newHashMap();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.storagePlugin.getContext().getBits()) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("Endpoint address: {}", (Object)endpoint.getAddress());
        }
        HashMap affinityMap = Maps.newHashMap();
        block1: for (Set<ServerAddress> addressList : this.chunksMapping.values()) {
            for (ServerAddress address : addressList) {
                CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(address.getHost());
                if (ep == null) continue;
                EndpointAffinity affinity = (EndpointAffinity)affinityMap.get(ep);
                if (affinity == null) {
                    affinityMap.put(ep, new EndpointAffinity(ep, 1.0));
                    continue block1;
                }
                affinity.addAffinity(1.0);
                continue block1;
            }
        }
        logger.debug("Took {} \u00b5s to get operator affinity", (Object)(this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L));
        logger.debug("Affined drillbits : " + affinityMap.values());
        return Lists.newArrayList(affinityMap.values());
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="mongoScanSpec")
    public MongoScanSpec getScanSpec() {
        return this.scanSpec;
    }

    @JsonProperty(value="storage")
    public MongoStoragePluginConfig getStorageConfig() {
        return this.storagePluginConfig;
    }

    @JsonIgnore
    public MongoStoragePlugin getStoragePlugin() {
        return this.storagePlugin;
    }

    public String toString() {
        return "MongoGroupScan [MongoScanSpec=" + this.scanSpec + ", columns=" + this.columns + "]";
    }

    @VisibleForTesting
    MongoGroupScan() {
        super((String)null);
    }

    @JsonIgnore
    @VisibleForTesting
    void setChunksMapping(Map<String, Set<ServerAddress>> chunksMapping) {
        this.chunksMapping = chunksMapping;
    }

    @JsonIgnore
    @VisibleForTesting
    void setScanSpec(MongoScanSpec scanSpec) {
        this.scanSpec = scanSpec;
    }

    @JsonIgnore
    @VisibleForTesting
    void setInverseChunsMapping(Map<String, List<ChunkInfo>> chunksInverseMapping) {
        this.chunksInverseMapping = chunksInverseMapping;
    }
}

