/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.SingleArgumentRunnable;

public class PluginDispatcher<T extends ServicePlugin> {
    public static final Log LOG = LogFactory.getLog((String)PluginDispatcher.class.getName());
    private final List<T> plugins;
    private Executor executor;

    public static <X extends ServicePlugin> PluginDispatcher<X> createFromConfiguration(Configuration conf, String key, Class<X> clazz) {
        ArrayList<X> plugins = new ArrayList<X>();
        try {
            plugins.addAll(conf.getInstances(key, clazz));
        }
        catch (Throwable t) {
            LOG.warn((Object)("Unable to load " + key + " plugins"));
        }
        return new PluginDispatcher(plugins);
    }

    PluginDispatcher(Collection<T> plugins) {
        this.plugins = Collections.synchronizedList(new ArrayList<T>(plugins));
        this.executor = Executors.newSingleThreadExecutor();
    }

    PluginDispatcher(Collection<T> plugins, Executor executor) {
        this.plugins = Collections.synchronizedList(new ArrayList<T>(plugins));
        this.executor = executor;
    }

    public void dispatchCall(final SingleArgumentRunnable<T> callback) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ServicePlugin plugin : PluginDispatcher.this.plugins) {
                    try {
                        callback.run(plugin);
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("Uncaught exception dispatching to plugin " + plugin), t);
                    }
                }
            }
        });
    }

    public void dispatchStart(final Object plugPoint) {
        this.dispatchCall(new SingleArgumentRunnable<T>(){

            @Override
            public void run(T p) {
                try {
                    p.start(plugPoint);
                }
                catch (Throwable t) {
                    LOG.error((Object)("ServicePlugin " + p + " could not be started. " + "Removing from future callbacks."), t);
                    PluginDispatcher.this.plugins.remove(p);
                }
            }
        });
    }

    public void dispatchStop() {
        this.dispatchCall(new SingleArgumentRunnable<T>(){

            @Override
            public void run(T p) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        });
    }
}

