/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CompositeService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    protected static final boolean STOP_ONLY_STARTED_SERVICES = false;
    private final List<Service> serviceList = new ArrayList<Service>();

    public CompositeService(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Service> getServices() {
        List<Service> list = this.serviceList;
        synchronized (list) {
            return new ArrayList<Service>(this.serviceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addService(Service service) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding service " + service.getName()));
        }
        List<Service> list = this.serviceList;
        synchronized (list) {
            this.serviceList.add(service);
        }
    }

    protected boolean addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean removeService(Service service) {
        List<Service> list = this.serviceList;
        synchronized (list) {
            return this.serviceList.remove(service);
        }
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        List<Service> services = this.getServices();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getName() + ": initing services, size=" + services.size()));
        }
        for (Service service : services) {
            service.init(conf);
        }
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        List<Service> services = this.getServices();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getName() + ": starting services, size=" + services.size()));
        }
        for (Service service : services) {
            service.start();
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        int numOfServicesToStop = this.serviceList.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getName() + ": stopping services, size=" + numOfServicesToStop));
        }
        this.stop(numOfServicesToStop, false);
        super.serviceStop();
    }

    private void stop(int numOfServicesStarted, boolean stopOnlyStartedServices) {
        Exception firstException = null;
        List<Service> services = this.getServices();
        for (int i = numOfServicesStarted - 1; i >= 0; --i) {
            Exception ex;
            Service.STATE state;
            Service service = services.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stopping service #" + i + ": " + service));
            }
            if ((state = service.getServiceState()) != Service.STATE.STARTED && (stopOnlyStartedServices || state != Service.STATE.INITED) || (ex = ServiceOperations.stopQuietly(LOG, service)) == null || firstException != null) continue;
            firstException = ex;
        }
        if (firstException != null) {
            throw ServiceStateException.convert(firstException);
        }
    }

    public static class CompositeServiceShutdownHook
    implements Runnable {
        private CompositeService compositeService;

        public CompositeServiceShutdownHook(CompositeService compositeService) {
            this.compositeService = compositeService;
        }

        @Override
        public void run() {
            ServiceOperations.stopQuietly(this.compositeService);
        }
    }
}

