/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import oadd.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyServers;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "HBase", "Hive"})
public class ProxyUsers {
    private static volatile ImpersonationProvider sip;

    private static ImpersonationProvider getInstance(Configuration conf) {
        Class<ImpersonationProvider> clazz = conf.getClass("hadoop.security.impersonation.provider.class", DefaultImpersonationProvider.class, ImpersonationProvider.class);
        return ReflectionUtils.newInstance(clazz, conf);
    }

    public static void refreshSuperUserGroupsConfiguration() {
        ProxyUsers.refreshSuperUserGroupsConfiguration(new Configuration());
    }

    public static void refreshSuperUserGroupsConfiguration(Configuration conf) {
        sip = ProxyUsers.getInstance(conf);
        ProxyServers.refresh(conf);
    }

    public static void authorize(UserGroupInformation user, String remoteAddress) throws AuthorizationException {
        if (sip == null) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        sip.authorize(user, remoteAddress);
    }

    @Deprecated
    public static void authorize(UserGroupInformation user, String remoteAddress, Configuration conf) throws AuthorizationException {
        ProxyUsers.authorize(user, remoteAddress);
    }

    @VisibleForTesting
    public static DefaultImpersonationProvider getDefaultImpersonationProvider() {
        return (DefaultImpersonationProvider)sip;
    }
}

