/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MetricsTimeVaryingInt
extends MetricsBase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.metrics.util");
    private int currentValue = 0;
    private int previousIntervalValue = 0;

    public MetricsTimeVaryingInt(String nam, MetricsRegistry registry, String description) {
        super(nam, description);
        registry.add(nam, this);
    }

    public MetricsTimeVaryingInt(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void inc(int incr) {
        this.currentValue += incr;
    }

    public synchronized void inc() {
        ++this.currentValue;
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalValue = this.currentValue;
        this.currentValue = 0;
    }

    @Override
    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.getName(), this.getPreviousIntervalValue());
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.getName() + "\n"), (Throwable)e);
        }
    }

    public synchronized int getPreviousIntervalValue() {
        return this.previousIntervalValue;
    }

    public synchronized int getCurrentIntervalValue() {
        return this.currentValue;
    }
}

