/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.StreamPumper;
import org.apache.hadoop.util.Shell;

public class ShellCommandFencer
extends Configured
implements FenceMethod {
    private static final int ABBREV_LENGTH = 20;
    private static final String TARGET_PREFIX = "target_";
    @VisibleForTesting
    static Log LOG = LogFactory.getLog(ShellCommandFencer.class);

    @Override
    public void checkArgs(String args) throws BadFencingConfigurationException {
        if (args == null || args.isEmpty()) {
            throw new BadFencingConfigurationException("No argument passed to 'shell' fencing method");
        }
    }

    @Override
    public boolean tryFence(HAServiceTarget target, String cmd) {
        int rc;
        Process p;
        ProcessBuilder builder = !Shell.WINDOWS ? new ProcessBuilder("bash", "-e", "-c", cmd) : new ProcessBuilder("cmd.exe", "/c", cmd);
        this.setConfAsEnvVars(builder.environment());
        this.addTargetInfoAsEnvVars(target, builder.environment());
        try {
            p = builder.start();
            p.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to execute " + cmd), (Throwable)e);
            return false;
        }
        String pid = ShellCommandFencer.tryGetPid(p);
        LOG.info((Object)("Launched fencing command '" + cmd + "' with " + (pid != null ? "pid " + pid : "unknown pid")));
        String logPrefix = ShellCommandFencer.abbreviate(cmd, 20);
        if (pid != null) {
            logPrefix = "[PID " + pid + "] " + logPrefix;
        }
        StreamPumper errPumper = new StreamPumper(LOG, logPrefix, p.getErrorStream(), StreamPumper.StreamType.STDERR);
        errPumper.start();
        StreamPumper outPumper = new StreamPumper(LOG, logPrefix, p.getInputStream(), StreamPumper.StreamType.STDOUT);
        outPumper.start();
        try {
            rc = p.waitFor();
            errPumper.join();
            outPumper.join();
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Interrupted while waiting for fencing command: " + cmd));
            return false;
        }
        return rc == 0;
    }

    static String abbreviate(String cmd, int len) {
        if (cmd.length() > len && len >= 5) {
            int firstHalf = (len - 3) / 2;
            int rem = len - firstHalf - 3;
            return cmd.substring(0, firstHalf) + "..." + cmd.substring(cmd.length() - rem);
        }
        return cmd;
    }

    private static String tryGetPid(Process p) {
        try {
            Class<?> clazz = p.getClass();
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field f = clazz.getDeclaredField("pid");
                f.setAccessible(true);
                return String.valueOf(f.getInt(p));
            }
            LOG.trace((Object)("Unable to determine pid for " + p + " since it is not a UNIXProcess"));
            return null;
        }
        catch (Throwable t) {
            LOG.trace((Object)("Unable to determine pid for " + p), t);
            return null;
        }
    }

    private void setConfAsEnvVars(Map<String, String> env) {
        for (Map.Entry<String, String> pair : this.getConf()) {
            env.put(pair.getKey().replace('.', '_'), pair.getValue());
        }
    }

    private void addTargetInfoAsEnvVars(HAServiceTarget target, Map<String, String> environment) {
        for (Map.Entry<String, String> e : target.getFencingParameters().entrySet()) {
            String key = TARGET_PREFIX + e.getKey();
            key = key.replace('.', '_');
            environment.put(key, e.getValue());
        }
    }
}

