/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.INode;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3.S3FileSystemException;
import org.apache.hadoop.fs.s3.VersionMismatchException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tFileSystemStore
implements FileSystemStore {
    private static final String FILE_SYSTEM_NAME = "fs";
    private static final String FILE_SYSTEM_VALUE = "Hadoop";
    private static final String FILE_SYSTEM_TYPE_NAME = "fs-type";
    private static final String FILE_SYSTEM_TYPE_VALUE = "block";
    private static final String FILE_SYSTEM_VERSION_NAME = "fs-version";
    private static final String FILE_SYSTEM_VERSION_VALUE = "1";
    private static final Map<String, Object> METADATA = new HashMap<String, Object>();
    private static final String PATH_DELIMITER = "/";
    private static final String BLOCK_PREFIX = "block_";
    private Configuration conf;
    private S3Service s3Service;
    private S3Bucket bucket;
    private int bufferSize;
    private static final Log LOG;

    Jets3tFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        this.conf = conf;
        S3Credentials s3Credentials = new S3Credentials();
        s3Credentials.initialize(uri, conf);
        try {
            AWSCredentials awsCredentials = new AWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
            this.s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        this.bucket = new S3Bucket(uri.getHost());
        this.bufferSize = conf.getInt("s3.stream-buffer-size", 4096);
    }

    @Override
    public String getVersion() throws IOException {
        return FILE_SYSTEM_VERSION_VALUE;
    }

    private void delete(String key) throws IOException {
        try {
            this.s3Service.deleteObject(this.bucket, key);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    @Override
    public void deleteINode(Path path) throws IOException {
        this.delete(this.pathToKey(path));
    }

    @Override
    public void deleteBlock(Block block) throws IOException {
        this.delete(this.blockToKey(block));
    }

    @Override
    public boolean inodeExists(Path path) throws IOException {
        InputStream in = this.get(this.pathToKey(path), true);
        if (in == null) {
            return false;
        }
        in.close();
        return true;
    }

    @Override
    public boolean blockExists(long blockId) throws IOException {
        InputStream in = this.get(this.blockToKey(blockId), false);
        if (in == null) {
            return false;
        }
        in.close();
        return true;
    }

    private InputStream get(String key, boolean checkMetadata) throws IOException {
        try {
            S3Object object = this.s3Service.getObject(this.bucket.getName(), key);
            if (checkMetadata) {
                this.checkMetadata(object);
            }
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            if ("NoSuchKey".equals(e.getS3ErrorCode())) {
                return null;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    private InputStream get(String key, long byteRangeStart) throws IOException {
        try {
            S3Object object = this.s3Service.getObject(this.bucket, key, null, null, null, null, Long.valueOf(byteRangeStart), null);
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            if ("NoSuchKey".equals(e.getS3ErrorCode())) {
                return null;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    private void checkMetadata(S3Object object) throws S3FileSystemException, S3ServiceException {
        String name = (String)object.getMetadata(FILE_SYSTEM_NAME);
        if (!FILE_SYSTEM_VALUE.equals(name)) {
            throw new S3FileSystemException("Not a Hadoop S3 file.");
        }
        String type = (String)object.getMetadata(FILE_SYSTEM_TYPE_NAME);
        if (!FILE_SYSTEM_TYPE_VALUE.equals(type)) {
            throw new S3FileSystemException("Not a block file.");
        }
        String dataVersion = (String)object.getMetadata(FILE_SYSTEM_VERSION_NAME);
        if (!FILE_SYSTEM_VERSION_VALUE.equals(dataVersion)) {
            throw new VersionMismatchException(FILE_SYSTEM_VERSION_VALUE, dataVersion);
        }
    }

    @Override
    public INode retrieveINode(Path path) throws IOException {
        return INode.deserialize(this.get(this.pathToKey(path), true));
    }

    @Override
    public File retrieveBlock(Block block, long byteRangeStart) throws IOException {
        File fileBlock = null;
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            int numRead;
            fileBlock = this.newBackupFile();
            in = this.get(this.blockToKey(block), byteRangeStart);
            out = new BufferedOutputStream(new FileOutputStream(fileBlock));
            byte[] buf = new byte[this.bufferSize];
            while ((numRead = in.read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, numRead);
            }
            File file = fileBlock;
            this.closeQuietly(out);
            this.closeQuietly(in);
            return file;
        }
        catch (IOException e) {
            try {
                boolean b;
                this.closeQuietly(out);
                out = null;
                if (fileBlock != null && !(b = fileBlock.delete())) {
                    LOG.warn((Object)"Ignoring failed delete");
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeQuietly(out);
                this.closeQuietly(in);
                throw throwable;
            }
        }
    }

    private File newBackupFile() throws IOException {
        File dir = new File(this.conf.get("fs.s3.buffer.dir"));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create S3 buffer directory: " + dir);
        }
        File result = File.createTempFile("input-", ".tmp", dir);
        result.deleteOnExit();
        return result;
    }

    @Override
    public Set<Path> listSubPaths(Path path) throws IOException {
        try {
            String prefix = this.pathToKey(path);
            if (!prefix.endsWith(PATH_DELIMITER)) {
                prefix = prefix + PATH_DELIMITER;
            }
            S3Object[] objects = this.s3Service.listObjects(this.bucket.getName(), prefix, PATH_DELIMITER);
            TreeSet<Path> prefixes = new TreeSet<Path>();
            for (int i = 0; i < objects.length; ++i) {
                prefixes.add(this.keyToPath(objects[i].getKey()));
            }
            prefixes.remove(path);
            return prefixes;
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    @Override
    public Set<Path> listDeepSubPaths(Path path) throws IOException {
        try {
            String prefix = this.pathToKey(path);
            if (!prefix.endsWith(PATH_DELIMITER)) {
                prefix = prefix + PATH_DELIMITER;
            }
            S3Object[] objects = this.s3Service.listObjects(this.bucket.getName(), prefix, null);
            TreeSet<Path> prefixes = new TreeSet<Path>();
            for (int i = 0; i < objects.length; ++i) {
                prefixes.add(this.keyToPath(objects[i].getKey()));
            }
            prefixes.remove(path);
            return prefixes;
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    private void put(String key, InputStream in, long length, boolean storeMetadata) throws IOException {
        try {
            S3Object object = new S3Object(key);
            object.setDataInputStream(in);
            object.setContentType("binary/octet-stream");
            object.setContentLength(length);
            if (storeMetadata) {
                object.addAllMetadata(METADATA);
            }
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    @Override
    public void storeINode(Path path, INode inode) throws IOException {
        this.put(this.pathToKey(path), inode.serialize(), inode.getSerializedLength(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBlock(Block block, File file) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.put(this.blockToKey(block), in, block.getLength(), false);
            this.closeQuietly(in);
        }
        catch (Throwable throwable) {
            this.closeQuietly(in);
            throw throwable;
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        return path.toUri().getPath();
    }

    private Path keyToPath(String key) {
        return new Path(key);
    }

    private String blockToKey(long blockId) {
        return BLOCK_PREFIX + blockId;
    }

    private String blockToKey(Block block) {
        return this.blockToKey(block.getId());
    }

    @Override
    public void purge() throws IOException {
        try {
            S3Object[] objects = this.s3Service.listObjects(this.bucket.getName());
            for (int i = 0; i < objects.length; ++i) {
                this.s3Service.deleteObject(this.bucket, objects[i].getKey());
            }
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Filesystem, ");
        sb.append(this.bucket.getName()).append("\n");
        try {
            S3Object[] objects = this.s3Service.listObjects(this.bucket.getName(), PATH_DELIMITER, null);
            for (int i = 0; i < objects.length; ++i) {
                Path path = this.keyToPath(objects[i].getKey());
                sb.append(path).append("\n");
                INode m = this.retrieveINode(path);
                sb.append("\t").append((Object)m.getFileType()).append("\n");
                if (m.getFileType() == INode.FileType.DIRECTORY) continue;
                for (int j = 0; j < m.getBlocks().length; ++j) {
                    sb.append("\t").append(m.getBlocks()[j]).append("\n");
                }
            }
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        System.out.println(sb);
    }

    private void handleServiceException(ServiceException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got ServiceException with Error code: " + e.getErrorCode() + ";and Error message: " + e.getErrorMessage()));
        }
    }

    static {
        METADATA.put(FILE_SYSTEM_NAME, FILE_SYSTEM_VALUE);
        METADATA.put(FILE_SYSTEM_TYPE_NAME, FILE_SYSTEM_TYPE_VALUE);
        METADATA.put(FILE_SYSTEM_VERSION_NAME, FILE_SYSTEM_VERSION_VALUE);
        LOG = LogFactory.getLog((String)Jets3tFileSystemStore.class.getName());
    }
}

