/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.JVMProperties;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.ShimLoader;
import com.mapr.security.JNISecurity;
import com.mapr.security.MapRPrincipal;
import com.mapr.security.maprauth.MaprSignatureSecretFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.MaprAuthMethod;

public class CoreDefaultProperties
extends Properties {
    private static final Log LOG;
    private static final boolean isSecurityEnabled;
    private static final Map<String, String> props;
    public static final String DEFAULT_MAPR_LOCAL_VOL_PATH = "/var/mapr/local";
    public static final String FS_AUTOMATIC_CLOSE = "true";
    public static final String FS_CHECKPOINT_DIR = "${hadoop.tmp.dir}/dfs/namesecondary";
    public static final String FS_CHECKPOINT_EDITS_DIR = "${fs.checkpoint.dir}";
    public static final String FS_CHECKPOINT_PERIOD = "3600";
    public static final String FS_CHECKPOINT_SIZE = "67108864";
    public static final String FS_DEFAULT_NAME = "maprfs:///";
    public static final String FS_FILE_IMPL = "org.apache.hadoop.fs.LocalFileSystem";
    public static final String FS_FTP_IMPL = "org.apache.hadoop.fs.ftp.FTPFileSystem";
    public static final String FS_HAR_IMPL_DISABLE_CACHE = "true";
    public static final String FS_HAR_IMPL = "org.apache.hadoop.fs.HarFileSystem";
    public static final String FS_HFTP_IMPL = "org.apache.hadoop.hdfs.HftpFileSystem";
    public static final String FS_HSFTP_IMPL = "org.apache.hadoop.hdfs.HsftpFileSystem";
    public static final String FS_KFS_IMPL = "org.apache.hadoop.fs.kfs.KosmosFileSystem";
    public static final String FS_MAPRFS_IMPL = "com.mapr.fs.MapRFileSystem";
    public static final String FS_MFS_IMPL = "com.mapr.fs.MFS";
    public static final String FS_HDFS_IMPL = "org.apache.hadoop.hdfs.DistributedFileSystem";
    public static final String FS_WEBHDFS_IMPL = "org.apache.hadoop.hdfs.web.WebHdfsFileSystem";
    public static final String FS_MAPR_WORKING_DIR = "/user/$USERNAME/";
    public static final String FS_RAMFS_IMPL = "org.apache.hadoop.fs.InMemoryFileSystem";
    public static final String FS_S3_BLOCK_SIZE = "33554432";
    public static final String FS_S3_BLOCKSIZE = "33554432";
    public static final String FS_S3_BUFFER_DIR = "${hadoop.tmp.dir}/s3";
    public static final String FS_S3N_IMPL = "org.apache.hadoop.fs.s3native.NativeS3FileSystem";
    public static final String FS_S3_IMPL = "org.apache.hadoop.fs.s3.S3FileSystem";
    public static final String FS_S3_MAXRETRIES = "4";
    public static final String FS_S3N_BLOCK_SIZE = "33554432";
    public static final String FS_S3N_BLOCKSIZE = "33554432";
    public static final String FS_S3_SLEEPTIMESECONDS = "10";
    public static final String FS_TRASH_INTERVAL = "0";
    public static final String HADOOP_LOGFILE_COUNT = "10";
    public static final String HADOOP_LOGFILE_SIZE = "10000000";
    public static final String HADOOP_NATIVE_LIB = "true";
    public static final String HADOOP_RPC_SOCKET_FACTORY_CLASS_DEFAULT = "org.apache.hadoop.net.StandardSocketFactory";
    public static final String HADOOP_SECURITY_AUTHORIZATION = "false";
    public static final String HADOOP_SECURITY_PROTECTION = "privacy";
    public static final String HADOOP_SECURITY_GROUP_MAPPING = "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback";
    public static final String MAPR_SECURITY_JAVA_SECURITY_JAR_PATH = "/mapr.login.conf";
    public static final String HADOOP_SECURITY_UID_CACHE_SECS = "14400";
    public static final String HADOOP_SSL_KEYSTORE_FACTORY_CLASS = "org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory";
    public static final String HADOOP_INSTRUMENTATION_REQUIRES_ADMIN = "false";
    public static final String HADOOP_SSL_REQUIRE_CLIENT_CERT = "false";
    public static final String SSL_EXCLUDE_CIPHER_SUITES = "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256,TLS_DHE_DSS_WITH_AES_256_CBC_SHA256,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_DSS_WITH_AES_128_CBC_SHA256,TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    public static final String HADOOP_SSL_HOSTNAME_VERIFIER = "DEFAULT";
    public static final String HADOOP_SSL_SERVER_CONF = "ssl-server.xml";
    public static final String HADOOP_SSL_CLIENT_CONF = "ssl-client.xml";
    public static final String IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED = "false";
    public static final String HADOOP_TMP_DIR = "/tmp/hadoop-${user.name}";
    public static final String HADOOP_UTIL_HASH_TYPE = "murmur";
    public static final String HADOOP_WORKAROUND_NON_THREADSAFE_GETPWUID = "false";
    public static final String IO_BYTES_PER_CHECKSUM = "512";
    public static final String IO_COMPRESSION_CODECS = "org.apache.hadoop.io.compress.DefaultCodec,org.apache.hadoop.io.compress.GzipCodec,org.apache.hadoop.io.compress.BZip2Codec,org.apache.hadoop.io.compress.DeflateCodec,org.apache.hadoop.io.compress.SnappyCodec";
    public static final String IO_FILE_BUFFER_SIZE = "8192";
    public static final String IO_MAPFILE_BLOOM_ERROR_RATE = "0.005";
    public static final String IO_MAPFILE_BLOOM_SIZE = "1048576";
    public static final String IO_SEQFILE_COMPRESS_BLOCKSIZE = "1000000";
    public static final String IO_SEQFILE_LAZYDECOMPRESS = "true";
    public static final String IO_SEQFILE_SORTER_RECORDLIMIT = "1000000";
    public static final String IO_SERIALIZATIONS = "org.apache.hadoop.io.serializer.WritableSerialization";
    public static final String IO_SKIP_CHECKSUM_ERRORS = "false";
    public static final String IPC_CLIENT_CONNECTION_MAXIDLETIME = "10000";
    public static final String IPC_CLIENT_CONNECT_MAX_RETRIES = "10";
    public static final String IPC_CLIENT_IDLETHRESHOLD = "4000";
    public static final String IPC_CLIENT_KILL_MAX = "10";
    public static final String IPC_CLIENT_MAX_CONNECTION_SETUP_TIMEOUT = "20";
    public static final String IPC_CLIENT_TCPNODELAY = "true";
    public static final String IPC_SERVER_LISTEN_QUEUE_SIZE = "128";
    public static final String IPC_SERVER_TCPNODELAY = "true";
    public static final String TOPOLOGY_NODE_SWITCH_MAPPING_IMPL = "org.apache.hadoop.net.ScriptBasedMapping";
    public static final String HTTP_STATICUSER_USER = "unknown";

    public CoreDefaultProperties() {
        this.putAll(props);
    }

    static {
        ShimLoader.load();
        LOG = LogFactory.getLog(CoreDefaultProperties.class);
        isSecurityEnabled = JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName());
        JVMProperties.init();
        props = new HashMap<String, String>();
        props.put("mapr.home", BaseUtilsHelper.getPathToMaprHome());
        props.put("mapr.host", BaseUtilsHelper.getMapRHostName());
        props.put("mapr.localvolumes.path", DEFAULT_MAPR_LOCAL_VOL_PATH);
        props.put("mapr.mapred.localvolume.mount.path", "${mapr.localvolumes.path}/${mapr.host}/mapred");
        props.put("mapr.mapred.localvolume.root.dir.path", "${mapr.mapred.localvolume.mount.path}/${mapr.mapred.localvolume.root.dir.name}");
        props.put("fs.automatic.close", "true");
        props.put("dfs.namenode.checkpoint.dir", FS_CHECKPOINT_DIR);
        props.put("dfs.namenode.checkpoint.edits.dir", FS_CHECKPOINT_EDITS_DIR);
        props.put("dfs.namenode.checkpoint.period", FS_CHECKPOINT_PERIOD);
        props.put("fs.checkpoint.size", FS_CHECKPOINT_SIZE);
        props.put("fs.defaultFS", FS_DEFAULT_NAME);
        props.put("fs.file.impl", FS_FILE_IMPL);
        props.put("fs.ftp.impl", FS_FTP_IMPL);
        props.put("fs.har.impl.disable.cache", "true");
        props.put("fs.har.impl", FS_HAR_IMPL);
        props.put("fs.hftp.impl", FS_HFTP_IMPL);
        props.put("fs.hsftp.impl", FS_HSFTP_IMPL);
        props.put("fs.kfs.impl", FS_KFS_IMPL);
        props.put("fs.maprfs.impl", FS_MAPRFS_IMPL);
        props.put("fs.AbstractFileSystem.maprfs.impl", FS_MFS_IMPL);
        props.put("fs.hdfs.impl", FS_MAPRFS_IMPL);
        props.put("fs.AbstractFileSystem.hdfs.impl", FS_MFS_IMPL);
        props.put("fs.webhdfs.impl", FS_WEBHDFS_IMPL);
        props.put("fs.mapr.working.dir", FS_MAPR_WORKING_DIR);
        props.put("fs.ramfs.impl", FS_RAMFS_IMPL);
        props.put("fs.s3.block.size", "33554432");
        props.put("fs.s3.blockSize", "33554432");
        props.put("fs.s3.buffer.dir", FS_S3_BUFFER_DIR);
        props.put("fs.s3n.impl", FS_S3N_IMPL);
        props.put("fs.s3.impl", FS_S3N_IMPL);
        props.put("fs.s3.maxRetries", FS_S3_MAXRETRIES);
        props.put("fs.s3n.block.size", "33554432");
        props.put("fs.s3n.blockSize", "33554432");
        props.put("fs.s3.sleepTimeSeconds", "10");
        props.put("fs.trash.interval", FS_TRASH_INTERVAL);
        props.put("hadoop.logfile.count", "10");
        props.put("hadoop.logfile.size", HADOOP_LOGFILE_SIZE);
        props.put("oadd.io.native.lib.available", "true");
        props.put("hadoop.rpc.socket.factory.class.default", HADOOP_RPC_SOCKET_FACTORY_CLASS_DEFAULT);
        if (isSecurityEnabled) {
            props.put("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.CUSTOM.name());
            props.put("hadoop.security.custom.rpc.auth.method.class", MaprAuthMethod.class.getName());
            props.put("hadoop.security.custom.auth.principal.class", MapRPrincipal.class.getName());
            props.put("hadoop.http.authentication.type", "org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler");
            props.put("hadoop.ssl.enabled", "true");
            props.put("hadoop.log.level.authenticator.class", "com.mapr.security.maprauth.MaprAuthenticator");
        } else {
            props.put("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.SIMPLE.name());
        }
        props.put("hadoop.http.authentication.signature.secret", MaprSignatureSecretFactory.class.getName());
        if (isSecurityEnabled) {
            props.put("hadoop.security.authorization", "true");
        } else {
            props.put("hadoop.security.authorization", "false");
        }
        if (isSecurityEnabled) {
            props.put("hadoop.rpc.protection", HADOOP_SECURITY_PROTECTION);
        }
        props.put("hadoop.security.group.mapping", HADOOP_SECURITY_GROUP_MAPPING);
        props.put("hadoop.security.java.security.login.config.jar.path", MAPR_SECURITY_JAVA_SECURITY_JAR_PATH);
        props.put("hadoop.security.uid.cache.secs", HADOOP_SECURITY_UID_CACHE_SECS);
        props.put("hadoop.ssl.keystores.factory.class", HADOOP_SSL_KEYSTORE_FACTORY_CLASS);
        props.put("hadoop.security.instrumentation.requires.admin", "false");
        props.put("hadoop.ssl.require.client.cert", "false");
        props.put("hadoop.ssl.exclude.cipher.suites", SSL_EXCLUDE_CIPHER_SUITES);
        props.put("hadoop.ssl.hostname.verifier", HADOOP_SSL_HOSTNAME_VERIFIER);
        props.put("hadoop.ssl.server.conf", HADOOP_SSL_SERVER_CONF);
        props.put("hadoop.ssl.client.conf", HADOOP_SSL_CLIENT_CONF);
        props.put("ipc.client.fallback-to-simple-auth-allowed", "false");
        props.put("hadoop.tmp.dir", HADOOP_TMP_DIR);
        props.put("hadoop.util.hash.type", HADOOP_UTIL_HASH_TYPE);
        props.put("hadoop.workaround.non.threadsafe.getpwuid", "false");
        props.put("dfs.bytes-per-checksum", IO_BYTES_PER_CHECKSUM);
        props.put("oadd.io.compression.codecs", IO_COMPRESSION_CODECS);
        props.put("oadd.io.file.buffer.size", IO_FILE_BUFFER_SIZE);
        props.put("oadd.io.mapfile.bloom.error.rate", IO_MAPFILE_BLOOM_ERROR_RATE);
        props.put("oadd.io.mapfile.bloom.size", IO_MAPFILE_BLOOM_SIZE);
        props.put("oadd.io.seqfile.compress.blocksize", "1000000");
        props.put("oadd.io.seqfile.lazydecompress", "true");
        props.put("oadd.io.seqfile.sorter.recordlimit", "1000000");
        props.put("oadd.io.serializations", IO_SERIALIZATIONS);
        props.put("oadd.io.skip.checksum.errors", "false");
        props.put("ipc.client.connection.maxidletime", IPC_CLIENT_CONNECTION_MAXIDLETIME);
        props.put("ipc.client.connect.max.retries", "10");
        props.put("ipc.client.idlethreshold", IPC_CLIENT_IDLETHRESHOLD);
        props.put("ipc.client.kill.max", "10");
        props.put("ipc.client.max.connection.setup.timeout", IPC_CLIENT_MAX_CONNECTION_SETUP_TIMEOUT);
        props.put("ipc.client.tcpnodelay", "true");
        props.put("ipc.server.listen.queue.size", IPC_SERVER_LISTEN_QUEUE_SIZE);
        props.put("ipc.server.tcpnodelay", "true");
        props.put("oadd.net.topology.node.switch.mapping.impl", TOPOLOGY_NODE_SWITCH_MAPPING_IMPL);
        props.put("hadoop.http.staticuser.user", HTTP_STATICUSER_USER);
    }
}

