/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import oadd.net.hydromatic.avatica.DriverVersion;
import oadd.net.hydromatic.avatica.Handler;
import oadd.net.hydromatic.avatica.UnregisteredDriver;
import org.apache.drill.jdbc.impl.DrillHandler;

public class DriverImpl
extends UnregisteredDriver {
    private static final String CONNECTION_STRING_PREFIX = "jdbc:drill:";
    private static final String METADATA_PROPERTIES_RESOURCE_PATH = "apache-drill-jdbc.properties";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECTION_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "org.apache.drill.jdbc.impl.DrillJdbc3Factory";
            }
            case JDBC_40: {
                return "org.apache.drill.jdbc.impl.DrillJdbc40Factory";
            }
        }
        return "org.apache.drill.jdbc.impl.DrillJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(this.getClass(), METADATA_PROPERTIES_RESOURCE_PATH, "Apache Drill JDBC Driver", "<Properties resource apache-drill-jdbc.properties not loaded>", "Apache Drill", "<Properties resource apache-drill-jdbc.properties not loaded>");
    }

    @Override
    protected Handler createHandler() {
        return new DrillHandler();
    }
}

