/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import oadd.net.hydromatic.avatica.AvaticaStatement;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillStatement;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillRemoteStatement;

class DrillStatementImpl
extends AvaticaStatement
implements DrillStatement,
DrillRemoteStatement {
    private final DrillConnectionImpl connection;

    DrillStatementImpl(DrillConnectionImpl connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.connection = connection;
        connection.openStatementsRegistry.addStatement(this);
    }

    private void checkNotClosed() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Statement is already closed.");
        }
    }

    @Override
    public DrillConnectionImpl getConnection() {
        return this.connection;
    }

    private SQLException unwrapIfExtra(SQLException superMethodException) {
        Throwable cause = superMethodException.getCause();
        SQLException result = null != cause && cause instanceof SQLException ? (SQLException)cause : superMethodException;
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkNotClosed();
        try {
            return super.execute(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.checkNotClosed();
            return super.executeQuery(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkNotClosed();
        try {
            return super.executeUpdate(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkNotClosed();
        return super.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkNotClosed();
        return super.executeUpdate(sql, columnNames);
    }

    @Override
    public void cleanUp() {
        DrillConnectionImpl connection1 = this.connection;
        connection1.openStatementsRegistry.removeStatement(this);
    }

    @Override
    public int getQueryTimeout() throws AlreadyClosedSqlException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int milliseconds) throws AlreadyClosedSqlException, InvalidParameterSqlException, SQLFeatureNotSupportedException {
        this.checkNotClosed();
        if (milliseconds < 0) {
            throw new InvalidParameterSqlException("Invalid (negative) \"milliseconds\" parameter to setQueryTimeout(...) (" + milliseconds + ")");
        }
        if (0 != milliseconds) {
            throw new SQLFeatureNotSupportedException("Setting network timeout is not supported.");
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new DrillRuntimeException("Unexpected exception from " + this.getClass().getSuperclass() + ".isClosed(): " + e, e);
        }
    }
}

