/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import oadd.com.google.common.collect.Queues;
import oadd.net.hydromatic.avatica.AvaticaPrepareResult;
import oadd.net.hydromatic.avatica.AvaticaResultSet;
import oadd.net.hydromatic.avatica.AvaticaStatement;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.record.RecordBatchLoader;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.ExecutionCanceledSqlException;
import org.apache.drill.jdbc.SchemaChangeListener;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillResultSetImpl
extends AvaticaResultSet
implements DrillResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DrillResultSetImpl.class);
    private final DrillConnectionImpl connection;
    SchemaChangeListener changeListener;
    final ResultsListener resultsListener;
    private final DrillClient client;
    final RecordBatchLoader batchLoader;
    final DrillCursor cursor;
    boolean hasPendingCancelationNotification;

    DrillResultSetImpl(AvaticaStatement statement, AvaticaPrepareResult prepareResult, ResultSetMetaData resultSetMetaData, TimeZone timeZone) {
        super(statement, prepareResult, resultSetMetaData, timeZone);
        this.connection = (DrillConnectionImpl)statement.getConnection();
        this.client = this.connection.getClient();
        int batchQueueThrottlingThreshold = this.client.getConfig().getInt("drill.jdbc.batch_queue_throttling_threshold");
        this.resultsListener = new ResultsListener(batchQueueThrottlingThreshold);
        this.batchLoader = new RecordBatchLoader(this.client.getAllocator());
        this.cursor = new DrillCursor(this);
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            if (this.hasPendingCancelationNotification) {
                this.hasPendingCancelationNotification = false;
                throw new ExecutionCanceledSqlException("SQL statement execution canceled; ResultSet now closed.");
            }
            throw new AlreadyClosedSqlException("ResultSet is already closed.");
        }
    }

    @Override
    protected void cancel() {
        this.hasPendingCancelationNotification = true;
        this.cleanup();
        this.close();
    }

    synchronized void cleanup() {
        if (this.resultsListener.getQueryId() != null && !this.resultsListener.completed) {
            this.client.cancelQuery(this.resultsListener.getQueryId());
        }
        this.resultsListener.close();
        this.batchLoader.clear();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkNotClosed();
        if (((AvaticaResultSet)this).cursor != null) {
            return super.next();
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkNotClosed();
        return super.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkNotClosed();
        return super.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getByte(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getShort(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getInt(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getLong(columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getFloat(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getDouble(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkNotClosed();
        return super.getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getBytes(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getDate(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getTimestamp(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getAsciiStream(columnLabel);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getBinaryStream(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        super.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkNotClosed();
        return super.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return super.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getBigDecimal(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return super.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return super.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return super.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return super.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkNotClosed();
        super.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkNotClosed();
        super.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkNotClosed();
        return super.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkNotClosed();
        return super.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return super.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkNotClosed();
        return super.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkNotClosed();
        return super.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkNotClosed();
        return super.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        super.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return super.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
        super.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return super.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return super.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return super.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkNotClosed();
        return super.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkNotClosed();
        return super.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkNotClosed();
        return super.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkNotClosed();
        super.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkNotClosed();
        super.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkNotClosed();
        super.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkNotClosed();
        super.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkNotClosed();
        super.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkNotClosed();
        super.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkNotClosed();
        super.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkNotClosed();
        super.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkNotClosed();
        super.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkNotClosed();
        super.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkNotClosed();
        super.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkNotClosed();
        super.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkNotClosed();
        super.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkNotClosed();
        super.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        super.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkNotClosed();
        super.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.checkNotClosed();
        super.updateNull(columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.checkNotClosed();
        super.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.checkNotClosed();
        super.updateByte(columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.checkNotClosed();
        super.updateShort(columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.checkNotClosed();
        super.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.checkNotClosed();
        super.updateLong(columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.checkNotClosed();
        super.updateFloat(columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.checkNotClosed();
        super.updateDouble(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.checkNotClosed();
        super.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.checkNotClosed();
        super.updateString(columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.checkNotClosed();
        super.updateBytes(columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.checkNotClosed();
        super.updateDate(columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.checkNotClosed();
        super.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.checkNotClosed();
        super.updateTimestamp(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        super.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.checkNotClosed();
        super.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkNotClosed();
        super.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkNotClosed();
        super.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkNotClosed();
        super.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkNotClosed();
        super.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkNotClosed();
        super.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkNotClosed();
        super.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkNotClosed();
        super.moveToCurrentRow();
    }

    @Override
    public AvaticaStatement getStatement() {
        return super.getStatement();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getArray(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getRef(columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getBlob(columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getArray(columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getDate(columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkNotClosed();
        return super.getTimestamp(columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getURL(columnLabel);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkNotClosed();
        super.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.checkNotClosed();
        super.updateRef(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkNotClosed();
        super.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.checkNotClosed();
        super.updateArray(columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkNotClosed();
        super.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkNotClosed();
        super.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return super.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkNotClosed();
        super.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkNotClosed();
        super.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkNotClosed();
        super.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkNotClosed();
        super.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkNotClosed();
        return super.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkNotClosed();
        return super.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkNotClosed();
        super.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.checkNotClosed();
        super.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkNotClosed();
        super.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkNotClosed();
        super.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkNotClosed();
        super.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkNotClosed();
        return super.getObject(columnLabel, type);
    }

    @Override
    public String getQueryId() throws SQLException {
        this.checkNotClosed();
        if (this.resultsListener.getQueryId() != null) {
            return QueryIdHelper.getQueryId(this.resultsListener.getQueryId());
        }
        return null;
    }

    @Override
    protected DrillResultSetImpl execute() throws SQLException {
        this.client.runQuery(UserBitShared.QueryType.SQL, this.prepareResult.getSql(), this.resultsListener);
        this.connection.getDriver().handler.onStatementExecute(this.statement, null);
        super.execute();
        try {
            this.resultsListener.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted", e);
        }
        this.cursor.loadInitialSchema();
        return this;
    }

    static class ResultsListener
    implements UserResultsListener {
        private static final Logger logger = LoggerFactory.getLogger(ResultsListener.class);
        private static volatile int nextInstanceId = 1;
        private final int instanceId;
        private final int batchQueueThrottlingThreshold;
        private volatile UserBitShared.QueryId queryId;
        private int lastReceivedBatchNumber;
        private int lastDequeuedBatchNumber;
        private volatile UserException executionFailureException;
        volatile boolean completed = false;
        private final AtomicBoolean throttled = new AtomicBoolean(false);
        private volatile ConnectionThrottle throttle;
        private volatile boolean closed = false;
        private CountDownLatch latch = new CountDownLatch(1);
        private AtomicBoolean receivedMessage = new AtomicBoolean(false);
        final LinkedBlockingDeque<QueryDataBatch> batchQueue = Queues.newLinkedBlockingDeque();

        ResultsListener(int batchQueueThrottlingThreshold) {
            this.instanceId = nextInstanceId++;
            this.batchQueueThrottlingThreshold = batchQueueThrottlingThreshold;
            logger.debug("[#{}] Query listener created.", (Object)this.instanceId);
        }

        private boolean startThrottlingIfNot(ConnectionThrottle throttle) {
            boolean started = this.throttled.compareAndSet(false, true);
            if (started) {
                this.throttle = throttle;
                throttle.setAutoRead(false);
            }
            return started;
        }

        private boolean stopThrottlingIfSo() {
            boolean stopped = this.throttled.compareAndSet(true, false);
            if (stopped) {
                this.throttle.setAutoRead(true);
                this.throttle = null;
            }
            return stopped;
        }

        private boolean releaseIfFirst() {
            if (this.receivedMessage.compareAndSet(false, true)) {
                this.latch.countDown();
                return true;
            }
            return false;
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
            logger.debug("[#{}] Received query ID: {}.", (Object)this.instanceId, (Object)QueryIdHelper.getQueryId(queryId));
            this.queryId = queryId;
        }

        @Override
        public void submissionFailed(UserException ex) {
            logger.debug("Received query failure:", (Object)this.instanceId, (Object)ex);
            this.executionFailureException = ex;
            this.completed = true;
            this.close();
            logger.info("[#{}] Query failed: ", (Object)this.instanceId, (Object)ex);
        }

        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            ++this.lastReceivedBatchNumber;
            logger.debug("[#{}] Received query data batch #{}: {}.", this.instanceId, this.lastReceivedBatchNumber, result);
            if (this.closed) {
                result.release();
                this.completed = true;
                return;
            }
            this.batchQueue.add(result);
            if (this.batchQueue.size() > this.batchQueueThrottlingThreshold && this.startThrottlingIfNot(throttle)) {
                logger.debug("[#{}] Throttling started at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            this.releaseIfFirst();
        }

        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            logger.debug("[#{}] Received query completion: {}.", (Object)this.instanceId, (Object)state);
            this.releaseIfFirst();
            this.completed = true;
        }

        UserBitShared.QueryId getQueryId() {
            return this.queryId;
        }

        QueryDataBatch getNext() throws UserException, InterruptedException {
            QueryDataBatch qdb;
            do {
                if (this.executionFailureException != null) {
                    logger.debug("[#{}] Dequeued query failure exception: {}.", (Object)this.instanceId, (Object)this.executionFailureException);
                    throw this.executionFailureException;
                }
                if (!this.completed || !this.batchQueue.isEmpty()) continue;
                return null;
            } while ((qdb = this.batchQueue.poll(50L, TimeUnit.MILLISECONDS)) == null);
            ++this.lastDequeuedBatchNumber;
            logger.debug("[#{}] Dequeued query data batch #{}: {}.", this.instanceId, this.lastDequeuedBatchNumber, qdb);
            if ((this.batchQueue.size() < this.batchQueueThrottlingThreshold / 2 || this.batchQueue.size() == 0) && this.stopThrottlingIfSo()) {
                logger.debug("[#{}] Throttling stopped at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            return qdb;
        }

        void close() {
            logger.debug("[#{}] Query listener closing.", (Object)this.instanceId);
            this.closed = true;
            if (this.stopThrottlingIfSo()) {
                logger.debug("[#{}] Throttling stopped at close() (at queue size {}).", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            while (!this.batchQueue.isEmpty()) {
                QueryDataBatch qdb = this.batchQueue.poll();
                if (qdb == null || qdb.getData() == null) continue;
                qdb.getData().release();
            }
            this.latch.countDown();
            this.completed = true;
        }
    }
}

