/*
 * Decompiled with CFR 0.152.
 */
package oadd.parquet.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.store.parquet.DirectCodecFactory;
import oadd.parquet.bytes.BytesInput;
import oadd.parquet.column.ColumnDescriptor;
import oadd.parquet.column.page.DataPage;
import oadd.parquet.column.page.DataPageV1;
import oadd.parquet.column.page.DataPageV2;
import oadd.parquet.column.page.DictionaryPage;
import oadd.parquet.column.page.PageReadStore;
import oadd.parquet.column.page.PageReader;
import oadd.parquet.format.DataPageHeaderV2;
import oadd.parquet.format.PageHeader;
import oadd.parquet.format.Statistics;
import oadd.parquet.format.Util;
import oadd.parquet.format.converter.ParquetMetadataConverter;
import oadd.parquet.hadoop.CodecFactory;
import oadd.parquet.hadoop.metadata.ColumnChunkMetaData;
import oadd.parquet.hadoop.util.CompatibilityUtil;
import oadd.parquet.schema.PrimitiveType;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ColumnChunkIncReadStore
implements PageReadStore {
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private DirectCodecFactory codecFactory;
    private BufferAllocator allocator;
    private FileSystem fs;
    private Path path;
    private long rowCount;
    private List<FSDataInputStream> streams = new ArrayList<FSDataInputStream>();
    private Map<ColumnDescriptor, ColumnChunkIncPageReader> columns = new HashMap<ColumnDescriptor, ColumnChunkIncPageReader>();

    public ColumnChunkIncReadStore(long rowCount, DirectCodecFactory codecFactory, BufferAllocator allocator, FileSystem fs, Path path) {
        this.codecFactory = codecFactory;
        this.allocator = allocator;
        this.fs = fs;
        this.path = path;
        this.rowCount = rowCount;
    }

    public void addColumn(ColumnDescriptor descriptor, ColumnChunkMetaData metaData) throws IOException {
        FSDataInputStream in = this.fs.open(this.path);
        this.streams.add(in);
        in.seek(metaData.getStartingPos());
        ColumnChunkIncPageReader reader = new ColumnChunkIncPageReader(metaData, descriptor, in);
        this.columns.put(descriptor, reader);
    }

    public void close() throws IOException {
        for (FSDataInputStream stream : this.streams) {
            stream.close();
        }
        for (ColumnChunkIncPageReader reader : this.columns.values()) {
            reader.close();
        }
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        return this.columns.get(descriptor);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public class ColumnChunkIncPageReader
    implements PageReader {
        ColumnChunkMetaData metaData;
        ColumnDescriptor columnDescriptor;
        long fileOffset;
        long size;
        private long valueReadSoFar = 0L;
        private DictionaryPage dictionaryPage;
        private FSDataInputStream in;
        private CodecFactory.BytesDecompressor decompressor;
        private ByteBuf lastPage;

        public ColumnChunkIncPageReader(ColumnChunkMetaData metaData, ColumnDescriptor columnDescriptor, FSDataInputStream in) {
            this.metaData = metaData;
            this.columnDescriptor = columnDescriptor;
            this.size = metaData.getTotalSize();
            this.fileOffset = metaData.getStartingPos();
            this.in = in;
            this.decompressor = ColumnChunkIncReadStore.this.codecFactory.getDecompressor(metaData.getCodec());
        }

        public DictionaryPage readDictionaryPage() {
            if (this.dictionaryPage == null) {
                PageHeader pageHeader = new PageHeader();
                long pos = 0L;
                try {
                    pos = this.in.getPos();
                    pageHeader = Util.readPageHeader((InputStream)this.in);
                    if (pageHeader.getDictionary_page_header() == null) {
                        this.in.seek(pos);
                        return null;
                    }
                    this.dictionaryPage = new DictionaryPage(this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.getDictionary_page_header().getNum_values(), parquetMetadataConverter.getEncoding(pageHeader.dictionary_page_header.encoding));
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Error reading dictionary page.\nFile path: " + ColumnChunkIncReadStore.this.path.toUri().getPath() + "\nRow count: " + ColumnChunkIncReadStore.this.rowCount + "\nColumn Chunk Metadata: " + this.metaData + "\nPage Header: " + pageHeader + "\nFile offset: " + this.fileOffset + "\nSize: " + this.size + "\nValue read so far: " + this.valueReadSoFar + "\nPosition: " + pos, e);
                }
            }
            return this.dictionaryPage;
        }

        public long getTotalValueCount() {
            return this.metaData.getValueCount();
        }

        public DataPage readPage() {
            PageHeader pageHeader = new PageHeader();
            try {
                if (this.lastPage != null) {
                    this.lastPage.release();
                    this.lastPage = null;
                }
                block8: while (this.valueReadSoFar < this.metaData.getValueCount()) {
                    pageHeader = Util.readPageHeader((InputStream)this.in);
                    int uncompressedPageSize = pageHeader.getUncompressed_page_size();
                    int compressedPageSize = pageHeader.getCompressed_page_size();
                    switch (pageHeader.type) {
                        case DICTIONARY_PAGE: {
                            if (this.dictionaryPage == null) {
                                this.dictionaryPage = new DictionaryPage(this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.uncompressed_page_size, parquetMetadataConverter.getEncoding(pageHeader.dictionary_page_header.encoding));
                                continue block8;
                            }
                            this.in.skip(pageHeader.compressed_page_size);
                            continue block8;
                        }
                        case DATA_PAGE: {
                            this.valueReadSoFar += (long)pageHeader.data_page_header.getNum_values();
                            DrillBuf buf = ColumnChunkIncReadStore.this.allocator.buffer(pageHeader.compressed_page_size);
                            this.lastPage = buf;
                            ByteBuffer buffer = ((ByteBuf)buf).nioBuffer(0, pageHeader.compressed_page_size);
                            while (buffer.remaining() > 0) {
                                CompatibilityUtil.getBuf((FSDataInputStream)this.in, (ByteBuffer)buffer, (int)pageHeader.compressed_page_size);
                            }
                            return new DataPageV1(this.decompressor.decompress(BytesInput.from((ByteBuffer)buffer, (int)0, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size()), pageHeader.data_page_header.num_values, pageHeader.uncompressed_page_size, ParquetMetadataConverter.fromParquetStatistics((Statistics)pageHeader.data_page_header.statistics, (PrimitiveType.PrimitiveTypeName)this.columnDescriptor.getType()), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.repetition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.definition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.encoding));
                        }
                        case DATA_PAGE_V2: {
                            this.valueReadSoFar += (long)pageHeader.data_page_header_v2.getNum_values();
                            DrillBuf buf = ColumnChunkIncReadStore.this.allocator.buffer(pageHeader.compressed_page_size);
                            this.lastPage = buf;
                            ByteBuffer buffer = ((ByteBuf)buf).nioBuffer(0, pageHeader.compressed_page_size);
                            while (buffer.remaining() > 0) {
                                CompatibilityUtil.getBuf((FSDataInputStream)this.in, (ByteBuffer)buffer, (int)pageHeader.compressed_page_size);
                            }
                            DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
                            int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
                            BytesInput decompressedPageData = this.decompressor.decompress(BytesInput.from((ByteBuffer)buffer, (int)0, (int)pageHeader.compressed_page_size), pageHeader.uncompressed_page_size);
                            return new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), BytesInput.from((ByteBuffer)decompressedPageData.toByteBuffer(), (int)0, (int)dataHeaderV2.getRepetition_levels_byte_length()), BytesInput.from((ByteBuffer)decompressedPageData.toByteBuffer(), (int)dataHeaderV2.getRepetition_levels_byte_length(), (int)dataHeaderV2.getDefinition_levels_byte_length()), parquetMetadataConverter.getEncoding(dataHeaderV2.getEncoding()), BytesInput.from((ByteBuffer)decompressedPageData.toByteBuffer(), (int)(dataHeaderV2.getRepetition_levels_byte_length() + dataHeaderV2.getDefinition_levels_byte_length()), (int)dataSize), uncompressedPageSize, ParquetMetadataConverter.fromParquetStatistics((Statistics)dataHeaderV2.getStatistics(), (PrimitiveType.PrimitiveTypeName)this.columnDescriptor.getType()), dataHeaderV2.isIs_compressed());
                        }
                    }
                    this.in.skip(pageHeader.compressed_page_size);
                }
                this.in.close();
                return null;
            }
            catch (OutOfMemoryRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error reading page.\nFile path: " + ColumnChunkIncReadStore.this.path.toUri().getPath() + "\nRow count: " + ColumnChunkIncReadStore.this.rowCount + "\nColumn Chunk Metadata: " + this.metaData + "\nPage Header: " + pageHeader + "\nFile offset: " + this.fileOffset + "\nSize: " + this.size + "\nValue read so far: " + this.valueReadSoFar, e);
            }
        }

        void close() {
            if (this.lastPage != null) {
                this.lastPage.release();
                this.lastPage = null;
            }
        }
    }
}

