/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.TinyIntVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.TinyIntWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TinyIntWriter;

public class TinyIntReaderImpl
extends AbstractFieldReader {
    private final TinyIntVector vector;

    public TinyIntReaderImpl(TinyIntVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(TinyIntWriter writer) {
        TinyIntWriterImpl impl = (TinyIntWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TinyIntWriterImpl impl = (TinyIntWriterImpl)writer.tinyInt(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableTinyIntHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Byte readByte() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

