/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.commons.lang3.ArrayUtils;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.expr.holders.ComplexHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedMapReaderImpl;

public class RepeatedMapVector
extends AbstractMapVector
implements RepeatedValueVector,
RepeatedFixedWidthVectorLike {
    public static final TypeProtos.MajorType TYPE = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.MAP).setMode(TypeProtos.DataMode.REPEATED).build();
    private final UInt4Vector offsets;
    private final RepeatedMapReaderImpl reader = new RepeatedMapReaderImpl(this);
    private final RepeatedMapAccessor accessor = new RepeatedMapAccessor();
    private final Mutator mutator = new Mutator();
    private final EmptyValuePopulator emptyPopulator;
    private transient RepeatedMapTransferPair ephPair;

    public RepeatedMapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field, allocator, callBack);
        this.offsets = new UInt4Vector(BaseRepeatedValueVector.OFFSETS_FIELD, allocator);
        this.emptyPopulator = new EmptyValuePopulator(this.offsets);
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.offsets;
    }

    @Override
    public ValueVector getDataVector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(VectorDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsets.setInitialCapacity(numRecords + 1);
        for (ValueVector v : this) {
            v.setInitialCapacity(numRecords * 5);
        }
    }

    @Override
    public RepeatedMapReaderImpl getReader() {
        return this.reader;
    }

    @Override
    public void allocateNew(int groupCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(groupCount + 1);
            for (ValueVector v : this.getChildren()) {
                AllocationHelper.allocatePrecomputedChildCount(v, groupCount, 50, innerValueCount);
            }
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public Iterator<String> fieldNameIterator() {
        return this.getChildFieldNames().iterator();
    }

    @Override
    public List<ValueVector> getPrimitiveVectors() {
        List<ValueVector> primitiveVectors = super.getPrimitiveVectors();
        primitiveVectors.add(this.offsets);
        return primitiveVectors;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        long bufferSize = this.offsets.getBufferSize();
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSize();
        }
        return (int)bufferSize;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long buffer = 0L;
        for (ValueVector v : this) {
            buffer += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)buffer;
    }

    @Override
    public void close() {
        this.offsets.close();
        super.close();
    }

    @Override
    public TransferPair getTransferPair() {
        return new RepeatedMapTransferPair(this, this.getField().getPath());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new RepeatedMapTransferPair(this, (RepeatedMapVector)to);
    }

    MapSingleCopier makeSingularCopier(MapVector to) {
        return new MapSingleCopier(this, to);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        if (seg != null && seg.isArray() && !seg.isLastPath()) {
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
            if ((seg = seg.getChild()).isArray()) {
                return null;
            }
        }
        return super.getFieldIdIfMatches(builder, addToBreadCrumb, seg);
    }

    public TransferPair getTransferPairToSingleMap(FieldReference reference) {
        return new SingleMapTransferPair(this, reference);
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new RepeatedMapTransferPair(this, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = super.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        return success;
    }

    public void copyFromSafe(int fromIndex, int thisIndex, RepeatedMapVector from) {
        if (this.ephPair == null || this.ephPair.from != from) {
            this.ephPair = (RepeatedMapTransferPair)from.makeTransferPair(this);
        }
        this.ephPair.copyValueSafe(fromIndex, thisIndex);
    }

    @Override
    public int getValueCapacity() {
        return Math.max(this.offsets.getValueCapacity() - 1, 0);
    }

    @Override
    public RepeatedMapAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        int actualBufferSize;
        int expectedBufferSize = this.getBufferSize();
        Preconditions.checkArgument(expectedBufferSize == (actualBufferSize = super.getBufferSize()) + this.offsets.getBufferSize());
        return ArrayUtils.addAll(this.offsets.getBuffers(clear), super.getBuffers(clear));
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        List<UserBitShared.SerializedField> children = metadata.getChildList();
        UserBitShared.SerializedField offsetField = children.get(0);
        this.offsets.load(offsetField, buffer);
        int bufOffset = offsetField.getBufferLength();
        for (int i = 1; i < children.size(); ++i) {
            UserBitShared.SerializedField child = children.get(i);
            MaterializedField fieldDef = MaterializedField.create(child);
            ValueVector vector = this.getChild(fieldDef.getLastName());
            if (vector == null) {
                vector = TypeHelper.getNewVector(fieldDef, this.allocator);
                this.putChild(fieldDef.getLastName(), vector);
            }
            int vectorLength = child.getBufferLength();
            vector.load(child, buffer.slice(bufOffset, vectorLength));
            bufOffset += vectorLength;
        }
        assert (bufOffset == buffer.capacity());
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder builder = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.accessor.getValueCount());
        builder.addChild(this.offsets.getMetadata());
        for (ValueVector child : this.getChildren()) {
            builder.addChild(child.getMetadata());
        }
        return builder.build();
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void clear() {
        this.getMutator().reset();
        this.offsets.clear();
        for (ValueVector vector : this.getChildren()) {
            vector.clear();
        }
    }

    public class Mutator
    implements RepeatedValueVector.RepeatedMutator {
        @Override
        public void startNewValue(int index) {
            RepeatedMapVector.this.emptyPopulator.populate(index + 1);
            RepeatedMapVector.this.offsets.getMutator().setSafe(index + 1, RepeatedMapVector.this.offsets.getAccessor().get(index));
        }

        @Override
        public void setValueCount(int topLevelValueCount) {
            RepeatedMapVector.this.emptyPopulator.populate(topLevelValueCount);
            RepeatedMapVector.this.offsets.getMutator().setValueCount(topLevelValueCount == 0 ? 0 : topLevelValueCount + 1);
            int childValueCount = RepeatedMapVector.this.offsets.getAccessor().get(topLevelValueCount);
            for (ValueVector v : RepeatedMapVector.this.getChildren()) {
                v.getMutator().setValueCount(childValueCount);
            }
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }

        public int add(int index) {
            int prevEnd = RepeatedMapVector.this.offsets.getAccessor().get(index + 1);
            RepeatedMapVector.this.offsets.getMutator().setSafe(index + 1, prevEnd + 1);
            return prevEnd;
        }
    }

    public class RepeatedMapAccessor
    implements RepeatedValueVector.RepeatedAccessor {
        @Override
        public Object getObject(int index) {
            JsonStringArrayList<LinkedHashMap<String, Object>> list = new JsonStringArrayList<LinkedHashMap<String, Object>>();
            int end = RepeatedMapVector.this.offsets.getAccessor().get(index + 1);
            for (int i = RepeatedMapVector.this.offsets.getAccessor().get(index); i < end; ++i) {
                LinkedHashMap<String, Object> vv = Maps.newLinkedHashMap();
                for (MaterializedField field : RepeatedMapVector.this.getField().getChildren()) {
                    String fieldName;
                    Object value;
                    if (field.equals(BaseRepeatedValueVector.OFFSETS_FIELD) || (value = RepeatedMapVector.this.getChild(fieldName = field.getLastName()).getAccessor().getObject(i)) == null) continue;
                    vv.put(fieldName, value);
                }
                list.add(vv);
            }
            return list;
        }

        @Override
        public int getValueCount() {
            return Math.max(RepeatedMapVector.this.offsets.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public int getInnerValueCount() {
            int valueCount = this.getValueCount();
            if (valueCount == 0) {
                return 0;
            }
            return RepeatedMapVector.this.offsets.getAccessor().get(valueCount);
        }

        @Override
        public int getInnerValueCountAt(int index) {
            return RepeatedMapVector.this.offsets.getAccessor().get(index + 1) - RepeatedMapVector.this.offsets.getAccessor().get(index);
        }

        @Override
        public boolean isEmpty(int index) {
            return false;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, RepeatedMapHolder holder) {
            assert (index < RepeatedMapVector.this.getValueCapacity()) : String.format("Attempted to access index %d when value capacity is %d", index, RepeatedMapVector.this.getValueCapacity());
            UInt4Vector.Accessor offsetsAccessor = RepeatedMapVector.this.offsets.getAccessor();
            holder.start = offsetsAccessor.get(index);
            holder.end = offsetsAccessor.get(index + 1);
        }

        public void get(int index, ComplexHolder holder) {
            RepeatedMapReaderImpl reader = RepeatedMapVector.this.getReader();
            reader.setPosition(index);
            holder.reader = reader;
        }

        public void get(int index, int arrayIndex, ComplexHolder holder) {
            RepeatedMapHolder h = new RepeatedMapHolder();
            this.get(index, h);
            int offset = h.start + arrayIndex;
            if (offset >= h.end) {
                holder.reader = NullReader.INSTANCE;
            } else {
                RepeatedMapVector.this.reader.setSinglePosition(index, arrayIndex);
                holder.reader = RepeatedMapVector.this.reader;
            }
        }
    }

    private static class RepeatedMapTransferPair
    implements TransferPair {
        private final TransferPair[] pairs;
        private final RepeatedMapVector to;
        private final RepeatedMapVector from;

        public RepeatedMapTransferPair(RepeatedMapVector from, SchemaPath path) {
            this(from, new RepeatedMapVector(MaterializedField.create(path, TYPE), from.allocator, from.callBack), false);
        }

        public RepeatedMapTransferPair(RepeatedMapVector from, RepeatedMapVector to) {
            this(from, to, true);
        }

        public RepeatedMapTransferPair(RepeatedMapVector from, RepeatedMapVector to, boolean allocate) {
            this.from = from;
            this.to = to;
            this.pairs = new TransferPair[from.size()];
            this.to.ephPair = null;
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            this.from.offsets.transferTo(this.to.offsets);
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.from.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int srcIndex, int destIndex) {
            RepeatedMapHolder holder = new RepeatedMapHolder();
            this.from.getAccessor().get(srcIndex, holder);
            this.to.emptyPopulator.populate(destIndex + 1);
            int newIndex = this.to.offsets.getAccessor().get(destIndex);
            int i = holder.start;
            while (i < holder.end) {
                for (TransferPair p : this.pairs) {
                    p.copyValueSafe(i, newIndex);
                }
                ++i;
                ++newIndex;
            }
            this.to.offsets.getMutator().setSafe(destIndex + 1, newIndex);
        }

        @Override
        public void splitAndTransfer(int groupStart, int groups) {
            UInt4Vector.Accessor a = this.from.offsets.getAccessor();
            UInt4Vector.Mutator m = this.to.offsets.getMutator();
            int startPos = a.get(groupStart);
            int endPos = a.get(groupStart + groups);
            int valuesToCopy = endPos - startPos;
            this.to.offsets.clear();
            this.to.offsets.allocateNew(groups + 1);
            for (int i = 0; i < groups + 1; ++i) {
                int normalizedPos = a.get(groupStart + i) - startPos;
                m.set(i, normalizedPos);
            }
            m.setValueCount(groups + 1);
            this.to.emptyPopulator.populate(groups);
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startPos, valuesToCopy);
            }
        }
    }

    protected static class SingleMapTransferPair
    implements TransferPair {
        private final TransferPair[] pairs;
        private final RepeatedMapVector from;
        private final MapVector to;
        private static final TypeProtos.MajorType MAP_TYPE = Types.required(TypeProtos.MinorType.MAP);

        public SingleMapTransferPair(RepeatedMapVector from, SchemaPath path) {
            this(from, new MapVector(MaterializedField.create(path, MAP_TYPE), from.allocator, from.callBack), false);
        }

        public SingleMapTransferPair(RepeatedMapVector from, MapVector to) {
            this(from, to, true);
        }

        public SingleMapTransferPair(RepeatedMapVector from, MapVector to, boolean allocate) {
            this.from = from;
            this.to = to;
            this.pairs = new TransferPair[from.size()];
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (allocate && to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.to.getMutator().setValueCount(this.from.getAccessor().getValueCount());
            this.from.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(from, to);
            }
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startIndex, length);
            }
            this.to.getMutator().setValueCount(length);
        }
    }

    protected static class MapSingleCopier {
        private final TransferPair[] pairs;
        public final RepeatedMapVector from;

        public MapSingleCopier(RepeatedMapVector from, MapVector to) {
            this.from = from;
            this.pairs = new TransferPair[from.size()];
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        public void copySafe(int fromSubIndex, int toIndex) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(fromSubIndex, toIndex);
            }
        }
    }
}

