/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.Decimal28DenseReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Decimal28DenseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(Decimal28DenseVector.class);
    private final FieldReader reader = new Decimal28DenseReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 49152;
    private int allocationMonitor = 0;

    public Decimal28DenseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 12;
    }

    @Override
    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 12.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 12L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 12);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.matches(metadata), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 12;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath(ref));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal28DenseVector)to);
    }

    public void transferTo(Decimal28DenseVector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, Decimal28DenseVector target) {
        int startPoint = startIndex * 12;
        int sliceLength = length * 12;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, Decimal28DenseVector from) {
        from.data.getBytes(fromIndex * 12, this.data, thisIndex * 12, 12);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Decimal28DenseVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            Decimal28DenseVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= Decimal28DenseVector.this.getValueCapacity()) {
                Decimal28DenseVector.this.reAlloc();
            }
            Decimal28DenseVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void set(int index, Decimal28DenseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        void set(int index, NullableDecimal28DenseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, NullableDecimal28DenseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, Decimal28DenseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, int start, DrillBuf buffer) {
            while (index >= Decimal28DenseVector.this.getValueCapacity()) {
                Decimal28DenseVector.this.reAlloc();
            }
            this.set(index, start, buffer);
        }

        public void set(int index, int start, DrillBuf buffer) {
            Decimal28DenseVector.this.data.setBytes(index * 12, buffer, start, 12);
        }

        @Override
        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = Decimal28DenseVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 12; ++w) {
                    Decimal28DenseVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal28DenseVector.this.getValueCapacity();
            int idx = 12 * valueCount;
            while (valueCount > Decimal28DenseVector.this.getValueCapacity()) {
                Decimal28DenseVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal28DenseVector.this.incrementAllocationMonitor();
            } else if (Decimal28DenseVector.this.allocationMonitor > 0) {
                Decimal28DenseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal28DenseVector.this.data, idx);
            Decimal28DenseVector.this.data.writerIndex(valueCount * 12);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return Decimal28DenseVector.this.data.writerIndex() / 12;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return Decimal28DenseVector.this.data.slice(index * 12, 12);
        }

        public void get(int index, Decimal28DenseHolder holder) {
            holder.start = index * 12;
            holder.buffer = Decimal28DenseVector.this.data;
            holder.scale = Decimal28DenseVector.this.getField().getScale();
            holder.precision = Decimal28DenseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal28DenseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 12;
            holder.buffer = Decimal28DenseVector.this.data;
            holder.scale = Decimal28DenseVector.this.getField().getScale();
            holder.precision = Decimal28DenseVector.this.getField().getPrecision();
        }

        @Override
        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromDense(Decimal28DenseVector.this.data, index * 12, 3, Decimal28DenseVector.this.getField().getScale(), 28, 12);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private Decimal28DenseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal28DenseVector(field, Decimal28DenseVector.this.allocator);
        }

        public TransferImpl(Decimal28DenseVector to) {
            this.to = to;
        }

        @Override
        public Decimal28DenseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal28DenseVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Decimal28DenseVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Decimal28DenseVector.this);
        }
    }
}

