/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.expression.FieldReference;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.BitHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.BitReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitVector
extends BaseDataValueVector
implements FixedWidthVector {
    static final Logger logger = LoggerFactory.getLogger(BitVector.class);
    private final FieldReader reader = new BitReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int valueCount;
    private int allocationSizeInBytes = 4096;
    private int allocationMonitor = 0;

    public BitVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSize() {
        return this.getSizeFromCount(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return this.getSizeFromCount(valueCount);
    }

    private int getSizeFromCount(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    @Override
    public int getValueCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, (long)this.data.capacity() * 8L);
    }

    private int getByteIndex(int index) {
        return (int)Math.floor((double)index / 8.0);
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        this.allocationSizeInBytes = this.getSizeFromCount(valueCount);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8, this.allocationSizeInBytes / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (OutOfMemoryRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    @Override
    public void allocateNew(int valueCount) {
        int size = this.getSizeFromCount(valueCount);
        this.allocateBytes(size);
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.zeroVector();
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)newAllocationSize;
        DrillBuf newBuf = this.allocator.buffer(curSize);
        newBuf.setZero(0, newBuf.capacity());
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        this.data.release();
        this.data = newBuf;
        this.allocationSizeInBytes = curSize;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public void copyFrom(int inIndex, int outIndex, BitVector from) {
        this.mutator.set(outIndex, from.accessor.get(inIndex));
    }

    public boolean copyFromSafe(int inIndex, int outIndex, BitVector from) {
        if (outIndex >= this.getValueCapacity()) {
            this.decrementAllocationMonitor();
            return false;
        }
        this.copyFrom(inIndex, outIndex, from);
        return true;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.matches(metadata), "The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int valueCount = metadata.getValueCount();
        int expectedLength = this.getSizeFromCount(valueCount);
        int actualLength = metadata.getBufferLength();
        assert (expectedLength == actualLength) : "expected and actual buffer sizes do not match";
        this.clear();
        this.data = buffer.slice(0, actualLength);
        this.data.retain();
        this.valueCount = valueCount;
    }

    @Override
    public Mutator getMutator() {
        return new Mutator();
    }

    @Override
    public Accessor getAccessor() {
        return new Accessor();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath(ref));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BitVector)to);
    }

    public void transferTo(BitVector target) {
        target.clear();
        if (target.data != null) {
            target.data.release();
        }
        target.data = this.data;
        target.data.retain(1);
        target.valueCount = this.valueCount;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BitVector target) {
        assert (startIndex + length <= this.valueCount);
        int firstByte = this.getByteIndex(startIndex);
        int byteSize = this.getSizeFromCount(length);
        int offset = startIndex % 8;
        if (offset == 0) {
            target.clear();
            if (target.data != null) {
                target.data.release();
            }
            target.data = this.data.slice(firstByte, byteSize);
            target.data.retain(1);
        } else {
            target.clear();
            target.allocateNew(length);
            for (int i = 0; i < byteSize - 1; ++i) {
                target.data.setByte(i, ((this.data.getByte(firstByte + i) & 0xFF) >>> offset) + (this.data.getByte(firstByte + i + 1) << 8 - offset));
            }
            if (length % 8 != 0) {
                target.data.setByte(byteSize - 1, (this.data.getByte(firstByte + byteSize - 1) & 0xFF) >>> offset);
            } else {
                target.data.setByte(byteSize - 1, ((this.data.getByte(firstByte + byteSize - 1) & 0xFF) >>> offset) + (this.data.getByte(firstByte + byteSize) << 8 - offset));
            }
        }
        target.getMutator().setValueCount(length);
    }

    private void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public final void set(int index, int value) {
            int byteIndex = index >> 3;
            int bitIndex = index & 7;
            byte currentByte = BitVector.this.data.getByte(byteIndex);
            byte bitMask = (byte)(1L << bitIndex);
            currentByte = value != 0 ? (byte)(currentByte | bitMask) : (byte)(currentByte - (bitMask & currentByte));
            BitVector.this.data.setByte(byteIndex, currentByte);
        }

        public final void set(int index, BitHolder holder) {
            this.set(index, holder.value);
        }

        final void set(int index, NullableBitHolder holder) {
            this.set(index, holder.value);
        }

        public void setSafe(int index, int value) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, value);
        }

        public void setSafe(int index, BitHolder holder) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, holder.value);
        }

        public void setSafe(int index, NullableBitHolder holder) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, holder.value);
        }

        @Override
        public final void setValueCount(int valueCount) {
            int currentValueCapacity = BitVector.this.getValueCapacity();
            BitVector.this.valueCount = valueCount;
            int idx = BitVector.this.getSizeFromCount(valueCount);
            while (valueCount > BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                BitVector.this.incrementAllocationMonitor();
            } else if (BitVector.this.allocationMonitor > 0) {
                BitVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(BitVector.this.data, idx);
        }

        @Override
        public final void generateTestData(int values) {
            boolean even = true;
            for (int i = 0; i < values; ++i) {
                if (even) {
                    this.set(i, 1);
                }
                even = !even;
            }
            this.setValueCount(values);
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        public final int get(int index) {
            int byteIndex = index >> 3;
            byte b = BitVector.this.data.getByte(byteIndex);
            int bitIndex = index & 7;
            return Long.bitCount((long)b & 1L << bitIndex);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        @Override
        public final Boolean getObject(int index) {
            return new Boolean(this.get(index) != 0);
        }

        @Override
        public final int getValueCount() {
            return BitVector.this.valueCount;
        }

        public final void get(int index, BitHolder holder) {
            holder.value = this.get(index);
        }

        public final void get(int index, NullableBitHolder holder) {
            holder.isSet = 1;
            holder.value = this.get(index);
        }
    }

    private class TransferImpl
    implements TransferPair {
        BitVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new BitVector(field, BitVector.this.allocator);
        }

        public TransferImpl(BitVector to) {
            this.to = to;
        }

        @Override
        public BitVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BitVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            BitVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, BitVector.this);
        }
    }
}

