/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.ArrayList;
import java.util.List;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.module.SimpleModule;
import oadd.org.apache.drill.exec.util.TextSerializer;
import org.apache.hadoop.io.Text;

public class JsonStringArrayList<E>
extends ArrayList<E> {
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public final String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize array list to JSON string", e);
        }
    }

    static {
        SimpleModule serializer = new SimpleModule("TextSerializer").addSerializer(Text.class, new TextSerializer());
        mapper.registerModule(serializer);
    }
}

