/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import oadd.com.google.common.base.Splitter;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpersonationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImpersonationUtil.class);
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();

    public static UserGroupInformation createProxyUgi(String opUserName, String queryUserName) {
        if (!Strings.isNullOrEmpty(opUserName)) {
            return ImpersonationUtil.createProxyUgi(opUserName);
        }
        if (Strings.isNullOrEmpty(queryUserName)) {
            return ImpersonationUtil.getProcessUserUGI();
        }
        return ImpersonationUtil.createProxyUgi(queryUserName);
    }

    public static UserGroupInformation createProxyUgi(String proxyUserName) {
        try {
            if (Strings.isNullOrEmpty(proxyUserName)) {
                throw new DrillRuntimeException("Invalid value for proxy user name");
            }
            if (proxyUserName.equals(ImpersonationUtil.getProcessUserName())) {
                return ImpersonationUtil.getProcessUserUGI();
            }
            return UserGroupInformation.createProxyUser(proxyUserName, UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            String errMsg = "Failed to create proxy user UserGroupInformation object: " + e.getMessage();
            logger.error(errMsg, e);
            throw new DrillRuntimeException(errMsg, e);
        }
    }

    public static String resolveUserName(String userName) {
        if (!Strings.isNullOrEmpty(userName)) {
            return userName;
        }
        return ImpersonationUtil.getProcessUserName();
    }

    public static String getProcessUserName() {
        return ImpersonationUtil.getProcessUserUGI().getUserName();
    }

    public static UserGroupInformation getProcessUserUGI() {
        try {
            return UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            String errMsg = "Failed to get process user UserGroupInformation object.";
            logger.error("Failed to get process user UserGroupInformation object.", e);
            throw new DrillRuntimeException("Failed to get process user UserGroupInformation object.", e);
        }
    }

    public static DrillFileSystem createFileSystem(String proxyUserName, Configuration fsConf) {
        return ImpersonationUtil.createFileSystem(ImpersonationUtil.createProxyUgi(proxyUserName), fsConf, null);
    }

    private static DrillFileSystem createFileSystem(UserGroupInformation proxyUserUgi, final Configuration fsConf, final OperatorStats stats) {
        DrillFileSystem fs;
        try {
            fs = proxyUserUgi.doAs(new PrivilegedExceptionAction<DrillFileSystem>(){

                @Override
                public DrillFileSystem run() throws Exception {
                    logger.trace("Creating DrillFileSystem for proxy user: " + UserGroupInformation.getCurrentUser());
                    return new DrillFileSystem(fsConf, stats);
                }
            });
        }
        catch (IOException | InterruptedException e) {
            String errMsg = "Failed to create DrillFileSystem for proxy user: " + e.getMessage();
            logger.error(errMsg, e);
            throw new DrillRuntimeException(errMsg, e);
        }
        return fs;
    }

    public static boolean hasAdminPrivileges(String userName, String adminUsers, String adminGroups) {
        if (ImpersonationUtil.getProcessUserName().equals(userName)) {
            return true;
        }
        HashSet<String> adminUsersSet = Sets.newHashSet(SPLITTER.split(adminUsers));
        if (adminUsersSet.contains(userName)) {
            return true;
        }
        UserGroupInformation ugi = ImpersonationUtil.createProxyUgi(userName);
        String[] userGroups = ugi.getGroupNames();
        if (userGroups == null || userGroups.length == 0) {
            return false;
        }
        HashSet<String> adminUserGroupsSet = Sets.newHashSet(SPLITTER.split(adminGroups));
        for (String userGroup : userGroups) {
            if (!adminUserGroupsSet.contains(userGroup)) continue;
            return true;
        }
        return false;
    }
}

