/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Collection;
import java.util.Map;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.collect.Collections2;
import oadd.org.apache.commons.lang3.tuple.ImmutablePair;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.server.options.InMemoryOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;

public class SessionOptionManager
extends InMemoryOptionManager {
    private final UserSession session;
    private final Map<String, ImmutablePair<Integer, Integer>> shortLivedOptions = CaseInsensitiveMap.newConcurrentMap();
    private final Predicate<OptionValue> isLive = new Predicate<OptionValue>(){

        @Override
        public boolean apply(OptionValue value) {
            String name = value.name;
            return !SessionOptionManager.this.shortLivedOptions.containsKey(name) || SessionOptionManager.this.withinRange(name);
        }
    };

    public SessionOptionManager(OptionManager systemOptions, UserSession session) {
        super(systemOptions, CaseInsensitiveMap.newConcurrentMap());
        this.session = session;
    }

    @Override
    boolean setLocalOption(OptionValue value) {
        boolean set = super.setLocalOption(value);
        if (!set) {
            return false;
        }
        String name = value.name;
        OptionValidator validator = SystemOptionManager.getValidator(name);
        boolean shortLived = validator.isShortLived();
        if (shortLived) {
            int start = this.session.getQueryCount() + 1;
            int ttl = validator.getTtl();
            int end = start + ttl;
            this.shortLivedOptions.put(name, new ImmutablePair<Integer, Integer>(start, end));
        }
        return true;
    }

    @Override
    OptionValue getLocalOption(String name) {
        OptionValue value = super.getLocalOption(name);
        if (this.shortLivedOptions.containsKey(name)) {
            int start;
            if (this.withinRange(name)) {
                return value;
            }
            int queryNumber = this.session.getQueryCount();
            if (queryNumber < (start = this.shortLivedOptions.get(name).getLeft().intValue())) {
                return SystemOptionManager.getValidator(name).getDefault();
            }
            this.options.remove(name);
            this.shortLivedOptions.remove(name);
            return null;
        }
        return value;
    }

    private boolean withinRange(String name) {
        int queryNumber = this.session.getQueryCount();
        ImmutablePair<Integer, Integer> pair = this.shortLivedOptions.get(name);
        int start = pair.getLeft();
        int end = pair.getRight();
        return start <= queryNumber && queryNumber < end;
    }

    @Override
    Iterable<OptionValue> getLocalOptions() {
        Collection<OptionValue> liveOptions = Collections2.filter(this.options.values(), this.isLive);
        return liveOptions;
    }

    @Override
    boolean supportsOption(OptionValue value) {
        return value.type == OptionValue.OptionType.SESSION;
    }
}

