/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Iterator;
import oadd.com.google.common.collect.Iterables;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.server.options.BaseOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FallbackOptionManager
extends BaseOptionManager {
    private static final Logger logger = LoggerFactory.getLogger(FallbackOptionManager.class);
    protected final OptionManager fallback;

    public FallbackOptionManager(OptionManager fallback) {
        this.fallback = fallback;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.fallback, this.getLocalOptions()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue value = this.getLocalOption(name);
        if (value == null && this.fallback != null) {
            return this.fallback.getOption(name);
        }
        return value;
    }

    abstract Iterable<OptionValue> getLocalOptions();

    abstract OptionValue getLocalOption(String var1);

    abstract boolean setLocalOption(OptionValue var1);

    @Override
    public void setOption(OptionValue value) {
        OptionValidator validator;
        try {
            validator = SystemOptionManager.getValidator(value.name);
        }
        catch (IllegalArgumentException e) {
            throw UserException.validationError().message(e.getMessage(), new Object[0]).build(logger);
        }
        validator.validate(value);
        if (!this.setLocalOption(value)) {
            this.fallback.setOption(value);
        }
    }

    @Override
    public OptionList getOptionList() {
        OptionList list = new OptionList();
        for (OptionValue value : this.getLocalOptions()) {
            list.add(value);
        }
        return list;
    }
}

