/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.compile.CodeCompiler;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import oadd.org.apache.drill.exec.planner.PhysicalPlanReader;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.control.Controller;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.rpc.data.DataConnectionCreator;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.SystemOptionManager;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.sys.PStoreProvider;

public class DrillbitContext {
    private final BootStrapContext context;
    private final PhysicalPlanReader reader;
    private final ClusterCoordinator coord;
    private final DataConnectionCreator connectionsPool;
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final StoragePluginRegistry storagePlugins;
    private final OperatorCreatorRegistry operatorCreatorRegistry;
    private final Controller controller;
    private final WorkEventBus workBus;
    private final FunctionImplementationRegistry functionRegistry;
    private final SystemOptionManager systemOptions;
    private final PStoreProvider provider;
    private final CodeCompiler compiler;
    private final ExecutorService executor;

    public DrillbitContext(CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context, ClusterCoordinator coord, Controller controller, DataConnectionCreator connectionsPool, WorkEventBus workBus, PStoreProvider provider, ExecutorService executor) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(controller);
        Preconditions.checkNotNull(connectionsPool);
        this.workBus = workBus;
        this.controller = controller;
        this.context = context;
        this.coord = coord;
        this.connectionsPool = connectionsPool;
        this.endpoint = endpoint;
        this.provider = provider;
        this.executor = executor;
        this.storagePlugins = new StoragePluginRegistry(this);
        this.reader = new PhysicalPlanReader(context.getConfig(), context.getConfig().getMapper(), endpoint, this.storagePlugins);
        this.operatorCreatorRegistry = new OperatorCreatorRegistry(context.getConfig());
        this.systemOptions = new SystemOptionManager(context.getConfig(), provider);
        this.functionRegistry = new FunctionImplementationRegistry(context.getConfig(), (OptionManager)this.systemOptions);
        this.compiler = new CodeCompiler(context.getConfig(), (OptionManager)this.systemOptions);
    }

    public FunctionImplementationRegistry getFunctionImplementationRegistry() {
        return this.functionRegistry;
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public SystemOptionManager getOptionManager() {
        return this.systemOptions;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getBits() {
        return this.coord.getAvailableEndpoints();
    }

    public BufferAllocator getAllocator() {
        return this.context.getAllocator();
    }

    public OperatorCreatorRegistry getOperatorCreatorRegistry() {
        return this.operatorCreatorRegistry;
    }

    public StoragePluginRegistry getStorage() {
        return this.storagePlugins;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.context.getBitLoopGroup();
    }

    public DataConnectionCreator getDataConnectionsPool() {
        return this.connectionsPool;
    }

    public Controller getController() {
        return this.controller;
    }

    public MetricRegistry getMetrics() {
        return this.context.getMetrics();
    }

    public PhysicalPlanReader getPlanReader() {
        return this.reader;
    }

    public PStoreProvider getPersistentStoreProvider() {
        return this.provider;
    }

    public StoragePluginRegistry.DrillSchemaFactory getSchemaFactory() {
        return this.storagePlugins.getSchemaFactory();
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.coord;
    }

    public CodeCompiler getCompiler() {
        return this.compiler;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

