/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.io.Closeable;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapContext
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapContext.class);
    private final DrillConfig config;
    private final EventLoopGroup loop;
    private final EventLoopGroup loop2;
    private final MetricRegistry metrics;
    private final BufferAllocator allocator;

    public BootStrapContext(DrillConfig config) {
        this.config = config;
        this.loop = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitServer-");
        this.loop2 = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitClient-");
        this.metrics = DrillMetrics.getInstance();
        this.allocator = RootAllocatorFactory.newRoot(config);
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.loop;
    }

    public EventLoopGroup getBitClientLoopGroup() {
        return this.loop2;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        try {
            DrillMetrics.resetMetrics();
        }
        catch (Error | Exception e) {
            logger.warn("failure resetting metrics.", e);
        }
        this.loop.shutdownGracefully();
        this.allocator.close();
    }
}

