/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.io.IOException;
import java.util.UUID;
import oadd.com.google.common.io.Closeables;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.BasicServer;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.user.UserRpcConfig;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticatorFactory;
import oadd.org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServer
extends BasicServer<UserProtos.RpcType, UserClientConnection> {
    private static final Logger logger = LoggerFactory.getLogger(UserServer.class);
    final UserWorker worker;
    final BufferAllocator alloc;
    final UserAuthenticator authenticator;

    public UserServer(DrillConfig config, BufferAllocator alloc, EventLoopGroup eventLoopGroup, UserWorker worker) throws DrillbitStartupException {
        super(UserRpcConfig.getMapping(config), alloc.getUnderlyingAllocator(), eventLoopGroup);
        this.worker = worker;
        this.alloc = alloc;
        this.authenticator = config.getBoolean("drill.exec.security.user.auth.enabled") ? UserAuthenticatorFactory.createAuthenticator(config) : null;
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Response handle(UserClientConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 3: {
                logger.debug("Received query to run.  Returning query handle.");
                try {
                    UserProtos.RunQuery query = UserProtos.RunQuery.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    UserBitShared.QueryId queryId = this.worker.submitWork(connection, query);
                    return new Response(UserProtos.RpcType.QUERY_HANDLE, queryId, new ByteBuf[0]);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding RunQuery body.", e);
                }
            }
            case 4: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.cancelQuery(queryId);
                    return new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
            case 11: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.resumeQuery(queryId);
                    return new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
        }
        throw new UnsupportedOperationException(String.format("UserServer received rpc of unknown type.  Type was %d.", rpcType));
    }

    @Override
    public UserClientConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        return new UserClientConnection(channel);
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake> getHandshakeHandler(final UserClientConnection connection) {
        return new BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake>((Internal.EnumLite)UserProtos.RpcType.HANDSHAKE, UserProtos.UserToBitHandshake.PARSER){

            @Override
            protected void consumeHandshake(ChannelHandlerContext ctx, UserProtos.UserToBitHandshake inbound) throws Exception {
                UserProtos.BitToUserHandshake handshakeResp = this.getHandshakeResponse(inbound);
                OutboundRpcMessage msg = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, this.handshakeType, this.coordinationId, (MessageLite)handshakeResp, new ByteBuf[0]);
                ctx.writeAndFlush(msg);
                if (handshakeResp.getStatus() != UserProtos.HandshakeStatus.SUCCESS) {
                    throw new RpcException("Handshake request failed: " + handshakeResp.getErrorMessage());
                }
            }

            public UserProtos.BitToUserHandshake getHandshakeResponse(UserProtos.UserToBitHandshake inbound) throws Exception {
                logger.trace("Handling handshake from user to bit. {}", (Object)inbound);
                if (!inbound.hasSupportTimeout() || !inbound.getSupportTimeout()) {
                    connection.disableReadTimeout();
                    logger.warn("Timeout Disabled as client doesn't support it.", (Object)connection.getName());
                }
                UserProtos.BitToUserHandshake.Builder respBuilder = UserProtos.BitToUserHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION);
                try {
                    if (inbound.getRpcVersion() != UserRpcConfig.RPC_VERSION) {
                        String errMsg = String.format("Invalid rpc version. Expected %d, actual %d.", UserRpcConfig.RPC_VERSION, inbound.getRpcVersion());
                        return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.RPC_VERSION_MISMATCH, errMsg, null);
                    }
                    if (UserServer.this.authenticator != null) {
                        try {
                            String password = "";
                            UserProtos.UserProperties props = inbound.getProperties();
                            for (int i = 0; i < props.getPropertiesCount(); ++i) {
                                UserProtos.Property prop = props.getProperties(i);
                                if (!"password".equalsIgnoreCase(prop.getKey())) continue;
                                password = prop.getValue();
                                break;
                            }
                            UserServer.this.authenticator.authenticate(inbound.getCredentials().getUserName(), password);
                        }
                        catch (UserAuthenticationException ex) {
                            return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.AUTH_FAILED, ex.getMessage(), ex);
                        }
                    }
                    connection.setUser(inbound);
                    return respBuilder.setStatus(UserProtos.HandshakeStatus.SUCCESS).build();
                }
                catch (Exception e) {
                    return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.UNKNOWN_FAILURE, e.getMessage(), e);
                }
            }
        };
    }

    private static UserProtos.BitToUserHandshake handleFailure(UserProtos.BitToUserHandshake.Builder respBuilder, UserProtos.HandshakeStatus status, String errMsg, Exception exception) {
        String errorId = UUID.randomUUID().toString();
        if (exception != null) {
            logger.error("Error {} in Handling handshake request: {}, {}", errorId, status, errMsg, exception);
        } else {
            logger.error("Error {} in Handling handshake request: {}, {}", errorId, status, errMsg);
        }
        return respBuilder.setStatus(status).setErrorId(errorId).setErrorMessage(errMsg).build();
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new UserProtobufLengthDecoder(allocator, outOfMemoryHandler);
    }

    @Override
    public void close() throws IOException {
        Closeables.closeQuietly(this.authenticator);
        super.close();
    }

    public class UserClientConnection
    extends RemoteConnection {
        private UserSession session;

        public UserClientConnection(SocketChannel channel) {
            super(channel, "user client");
        }

        void disableReadTimeout() {
            this.getChannel().pipeline().remove("timeout-handler");
        }

        void setUser(UserProtos.UserToBitHandshake inbound) throws IOException {
            this.session = UserSession.Builder.newBuilder().withCredentials(inbound.getCredentials()).withOptionManager(UserServer.this.worker.getSystemOptions()).withUserProperties(inbound.getProperties()).setSupportComplexTypes(inbound.getSupportComplexTypes()).build();
        }

        public UserSession getSession() {
            return this.session;
        }

        public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, UserBitShared.QueryResult result, boolean allowInEventThread) {
            logger.trace("Sending result to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_RESULT, result, GeneralRPCProtos.Ack.class, allowInEventThread, new ByteBuf[0]);
        }

        public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryWritableBatch result) {
            this.sendData(listener, result, false);
        }

        public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryWritableBatch result, boolean allowInEventThread) {
            logger.trace("Sending data to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_DATA, result.getHeader(), GeneralRPCProtos.Ack.class, allowInEventThread, result.getBuffers());
        }

        @Override
        public BufferAllocator getAllocator() {
            return UserServer.this.alloc;
        }
    }
}

