/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.BasicClientWithConnection;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryResultHandler;
import oadd.org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import oadd.org.apache.drill.exec.rpc.user.UserRpcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BasicClientWithConnection<UserProtos.RpcType, UserProtos.UserToBitHandshake, UserProtos.BitToUserHandshake> {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private final QueryResultHandler queryResultHandler = new QueryResultHandler();
    private boolean supportComplexTypes = true;

    public UserClient(DrillConfig config, boolean supportComplexTypes, BufferAllocator alloc, EventLoopGroup eventLoopGroup) {
        super(UserRpcConfig.getMapping(config), alloc, eventLoopGroup, UserProtos.RpcType.HANDSHAKE, UserProtos.BitToUserHandshake.class, UserProtos.BitToUserHandshake.PARSER, "user client");
        this.supportComplexTypes = supportComplexTypes;
    }

    public void submitQuery(UserResultsListener resultsListener, UserProtos.RunQuery query) {
        this.send(this.queryResultHandler.getWrappedListener(this.connection, resultsListener), UserProtos.RpcType.RUN_QUERY, query, UserBitShared.QueryId.class, new ByteBuf[0]);
    }

    public void connect(RpcConnectionHandler<BasicClientWithConnection.ServerConnection> handler, CoordinationProtos.DrillbitEndpoint endpoint, UserProtos.UserProperties props, UserBitShared.UserCredentials credentials) {
        UserProtos.UserToBitHandshake.Builder hsBuilder = UserProtos.UserToBitHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION).setSupportListening(true).setSupportComplexTypes(this.supportComplexTypes).setSupportTimeout(true).setCredentials(credentials);
        if (props != null) {
            hsBuilder.setProperties(props);
        }
        this.connectAsClient(handler, hsBuilder.build(), endpoint.getAddress(), endpoint.getUserPort());
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
            case 0: {
                return UserProtos.BitToUserHandshake.getDefaultInstance();
            }
            case 7: {
                return UserBitShared.QueryId.getDefaultInstance();
            }
            case 10: {
                return UserBitShared.QueryResult.getDefaultInstance();
            }
            case 6: {
                return UserBitShared.QueryData.getDefaultInstance();
            }
        }
        throw new RpcException(String.format("Unable to deal with RpcType of %d", rpcType));
    }

    @Override
    protected Response handleReponse(ConnectionThrottle throttle, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 6: {
                this.queryResultHandler.batchArrived(throttle, pBody, dBody);
                return new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]);
            }
            case 10: {
                this.queryResultHandler.resultArrived(pBody);
                return new Response(UserProtos.RpcType.ACK, Acks.OK, new ByteBuf[0]);
            }
        }
        throw new RpcException(String.format("Unknown Rpc Type %d. ", rpcType));
    }

    @Override
    protected void validateHandshake(UserProtos.BitToUserHandshake inbound) throws RpcException {
        if (inbound.getStatus() != UserProtos.HandshakeStatus.SUCCESS) {
            String errMsg = String.format("Status: %s, Error Id: %s, Error message: %s", inbound.getStatus(), inbound.getErrorId(), inbound.getErrorMessage());
            logger.error(errMsg);
            throw new RpcException(errMsg);
        }
    }

    @Override
    protected void finalizeConnection(UserProtos.BitToUserHandshake handshake, BasicClientWithConnection.ServerConnection connection) {
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new UserProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

