/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import oadd.com.google.common.collect.Maps;
import oadd.com.google.common.collect.Queues;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.util.concurrent.Future;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.exceptions.UserRemoteException;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.RpcBus;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryResultHandler.class);
    private final ConcurrentMap<UserBitShared.QueryId, UserResultsListener> queryIdToResultsListenersMap = Maps.newConcurrentMap();

    public RpcOutcomeListener<UserBitShared.QueryId> getWrappedListener(RemoteConnection connection, UserResultsListener resultsListener) {
        return new SubmissionListener(connection, resultsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultArrived(ByteBuf pBody) throws RpcException {
        boolean isTerminalResult;
        UserBitShared.QueryResult queryResult = RpcBus.get(pBody, UserBitShared.QueryResult.PARSER);
        UserBitShared.QueryId queryId = queryResult.getQueryId();
        UserBitShared.QueryResult.QueryState queryState = queryResult.getQueryState();
        logger.debug("resultArrived: queryState: {}, queryId = {}", (Object)queryState, (Object)queryId);
        assert (queryResult.hasQueryState()) : "received query result without QueryState";
        boolean isFailureResult = UserBitShared.QueryResult.QueryState.FAILED == queryState;
        switch (queryState) {
            case PENDING: {
                isTerminalResult = false;
                break;
            }
            case FAILED: 
            case CANCELED: 
            case COMPLETED: {
                isTerminalResult = true;
                break;
            }
            default: {
                logger.error("Unexpected/unhandled QueryState " + queryState + " (for query " + queryId + ")");
                isTerminalResult = false;
            }
        }
        assert (isFailureResult || queryResult.getErrorCount() == 0) : "Error count for the query batch is non-zero but QueryState != FAILED";
        UserResultsListener resultsListener = this.newUserResultsListener(queryId);
        try {
            if (isFailureResult) {
                resultsListener.submissionFailed(new UserRemoteException(queryResult.getError(0)));
            } else if (isTerminalResult) {
                try {
                    resultsListener.queryCompleted(queryState);
                }
                catch (Exception e) {
                    resultsListener.submissionFailed(UserException.systemError(e).build(logger));
                }
            } else {
                logger.warn("queryState {} was ignored", (Object)queryState);
            }
        }
        finally {
            if (isTerminalResult && (!(resultsListener instanceof BufferingResultsListener) || ((BufferingResultsListener)resultsListener).output != null)) {
                this.queryIdToResultsListenersMap.remove(queryId, resultsListener);
            }
        }
    }

    public void batchArrived(ConnectionThrottle throttle, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        UserBitShared.QueryData queryData = RpcBus.get(pBody, UserBitShared.QueryData.PARSER);
        DrillBuf drillBuf = (DrillBuf)dBody;
        QueryDataBatch batch = new QueryDataBatch(queryData, drillBuf);
        UserBitShared.QueryId queryId = queryData.getQueryId();
        logger.debug("batchArrived: queryId = {}", (Object)queryId);
        logger.trace("batchArrived: batch = {}", (Object)batch);
        UserResultsListener resultsListener = this.newUserResultsListener(queryId);
        try {
            resultsListener.dataArrived(batch, throttle);
        }
        catch (Exception e) {
            batch.release();
            resultsListener.submissionFailed(UserException.systemError(e).build(logger));
        }
    }

    private UserResultsListener newUserResultsListener(UserBitShared.QueryId queryId) {
        UserResultsListener resultsListener = (UserResultsListener)this.queryIdToResultsListenersMap.get(queryId);
        logger.trace("For QueryId [{}], retrieved results listener {}", (Object)queryId, (Object)resultsListener);
        if (null == resultsListener) {
            BufferingResultsListener bl = new BufferingResultsListener();
            resultsListener = this.queryIdToResultsListenersMap.putIfAbsent(queryId, bl);
            if (null == resultsListener) {
                resultsListener = bl;
            }
            if (queryId.toString().isEmpty()) {
                this.failAll();
            }
        }
        return resultsListener;
    }

    private void failAll() {
        for (UserResultsListener l : this.queryIdToResultsListenersMap.values()) {
            l.submissionFailed(UserException.systemError(new RpcException("Received result without QueryId")).build(logger));
        }
    }

    private class SubmissionListener
    extends BaseRpcOutcomeListener<UserBitShared.QueryId> {
        private final UserResultsListener resultsListener;
        private final RemoteConnection connection;
        private final ChannelFuture closeFuture;
        private final ChannelClosedListener closeListener;
        private final AtomicBoolean isTerminal = new AtomicBoolean(false);

        public SubmissionListener(RemoteConnection connection, UserResultsListener resultsListener) {
            this.resultsListener = resultsListener;
            this.connection = connection;
            this.closeFuture = connection.getChannel().closeFuture();
            this.closeListener = new ChannelClosedListener();
            this.closeFuture.addListener(this.closeListener);
        }

        @Override
        public void failed(RpcException ex) {
            if (!this.isTerminal.compareAndSet(false, true)) {
                return;
            }
            this.closeFuture.removeListener(this.closeListener);
            this.resultsListener.submissionFailed(UserException.systemError(ex).build(logger));
        }

        @Override
        public void success(UserBitShared.QueryId queryId, ByteBuf buf) {
            UserResultsListener oldListener;
            if (!this.isTerminal.compareAndSet(false, true)) {
                return;
            }
            this.closeFuture.removeListener(this.closeListener);
            this.resultsListener.queryIdArrived(queryId);
            if (logger.isDebugEnabled()) {
                logger.debug("Received QueryId {} successfully. Adding results listener {}.", (Object)QueryIdHelper.getQueryId(queryId), (Object)this.resultsListener);
            }
            if ((oldListener = QueryResultHandler.this.queryIdToResultsListenersMap.putIfAbsent(queryId, this.resultsListener)) != null) {
                logger.debug("Unable to place user results listener, buffering listener was already in place.");
                if (oldListener instanceof BufferingResultsListener) {
                    boolean all = ((BufferingResultsListener)oldListener).transferTo(this.resultsListener);
                    if (all) {
                        QueryResultHandler.this.queryIdToResultsListenersMap.remove(queryId);
                    } else {
                        boolean replaced = QueryResultHandler.this.queryIdToResultsListenersMap.replace(queryId, oldListener, this.resultsListener);
                        if (!replaced) {
                            throw new IllegalStateException();
                        }
                    }
                } else {
                    throw new IllegalStateException("Trying to replace a non-buffering User Results listener.");
                }
            }
        }

        @Override
        public void interrupted(InterruptedException ex) {
            logger.warn("Interrupted while waiting for query results from Drillbit", ex);
            if (!this.isTerminal.compareAndSet(false, true)) {
                return;
            }
            this.closeFuture.removeListener(this.closeListener);
            this.resultsListener.submissionFailed(UserException.systemError(ex).build(logger));
        }

        private class ChannelClosedListener
        implements GenericFutureListener<Future<Void>> {
            private ChannelClosedListener() {
            }

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                SubmissionListener.this.resultsListener.submissionFailed(UserException.connectionError().message("Connection %s closed unexpectedly.", SubmissionListener.this.connection.getName()).build(logger));
            }
        }
    }

    private static class BufferingResultsListener
    implements UserResultsListener {
        private ConcurrentLinkedQueue<QueryDataBatch> results = Queues.newConcurrentLinkedQueue();
        private volatile UserException ex;
        private volatile UserBitShared.QueryResult.QueryState queryState;
        private volatile UserResultsListener output;
        private volatile ConnectionThrottle throttle;

        private BufferingResultsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean transferTo(UserResultsListener l) {
            BufferingResultsListener bufferingResultsListener = this;
            synchronized (bufferingResultsListener) {
                this.output = l;
                for (QueryDataBatch r : this.results) {
                    l.dataArrived(r, this.throttle);
                }
                if (this.ex != null) {
                    l.submissionFailed(this.ex);
                    return true;
                }
                if (this.queryState != null) {
                    l.queryCompleted(this.queryState);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            assert (this.queryState == null);
            this.queryState = state;
            BufferingResultsListener bufferingResultsListener = this;
            synchronized (bufferingResultsListener) {
                if (this.output != null) {
                    this.output.queryCompleted(state);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            this.throttle = throttle;
            BufferingResultsListener bufferingResultsListener = this;
            synchronized (bufferingResultsListener) {
                if (this.output == null) {
                    this.results.add(result);
                } else {
                    this.output.dataArrived(result, throttle);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submissionFailed(UserException ex) {
            assert (this.queryState == null);
            this.queryState = UserBitShared.QueryResult.QueryState.FAILED;
            BufferingResultsListener bufferingResultsListener = this;
            synchronized (bufferingResultsListener) {
                if (this.output == null) {
                    this.ex = ex;
                } else {
                    this.output.submissionFailed(ex);
                }
            }
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
        }
    }
}

