/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.util.concurrent.AbstractFuture;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.util.concurrent.GenericFutureListener;
import oadd.org.apache.drill.exec.rpc.BasicClient;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.RpcCommand;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconnectingConnection<CONNECTION_TYPE extends RemoteConnection, OUTBOUND_HANDSHAKE extends MessageLite>
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(ReconnectingConnection.class);
    private final AtomicReference<CONNECTION_TYPE> connectionHolder = new AtomicReference();
    private final String host;
    private final int port;
    private final OUTBOUND_HANDSHAKE handshake;

    public ReconnectingConnection(OUTBOUND_HANDSHAKE handshake, String host, int port) {
        Preconditions.checkNotNull(host);
        Preconditions.checkArgument(port > 0);
        this.host = host;
        this.port = port;
        this.handshake = handshake;
    }

    protected abstract BasicClient<?, CONNECTION_TYPE, OUTBOUND_HANDSHAKE, ?> getNewClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MessageLite, C extends RpcCommand<R, CONNECTION_TYPE>> void runCommand(C cmd) {
        RemoteConnection connection = (RemoteConnection)this.connectionHolder.get();
        if (connection != null) {
            if (connection.isActive()) {
                cmd.connectionAvailable((RemoteConnection)connection);
                return;
            }
            this.connectionHolder.compareAndSet(connection, null);
        }
        ReconnectingConnection reconnectingConnection = this;
        synchronized (reconnectingConnection) {
            connection = (RemoteConnection)this.connectionHolder.get();
            if (connection != null) {
                cmd.connectionAvailable((RemoteConnection)connection);
            } else {
                BasicClient<?, CONNECTION_TYPE, OUTBOUND_HANDSHAKE, ?> client = this.getNewClient();
                ConnectionListeningFuture future = new ConnectionListeningFuture(this, cmd);
                client.connectAsClient(future, this.handshake, this.host, this.port);
                future.waitAndRun();
            }
            return;
        }
    }

    public CloseHandlerCreator getCloseHandlerCreator() {
        return new CloseHandlerCreator();
    }

    public void addExternalConnection(CONNECTION_TYPE connection) {
        this.connectionHolder.compareAndSet(null, connection);
    }

    @Override
    public void close() {
        RemoteConnection c = this.connectionHolder.getAndSet(null);
        if (c != null) {
            c.getChannel().close();
        }
    }

    private class ConnectionListeningDecorator
    implements RpcConnectionHandler<CONNECTION_TYPE> {
        private final RpcConnectionHandler<CONNECTION_TYPE> delegate;

        public ConnectionListeningDecorator(RpcConnectionHandler<CONNECTION_TYPE> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void connectionSucceeded(CONNECTION_TYPE incoming) {
            RemoteConnection connection = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get();
            do {
                boolean setted;
                if (!(setted = ReconnectingConnection.this.connectionHolder.compareAndSet(null, incoming))) continue;
                connection = incoming;
                break;
            } while ((connection = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get()) == null);
            if (connection == incoming) {
                this.delegate.connectionSucceeded(connection);
            } else {
                logger.debug("Closing incoming connection because a connection was already set.");
                ((RemoteConnection)incoming).getChannel().close();
                this.delegate.connectionSucceeded(connection);
            }
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            this.delegate.connectionFailed(type, t);
        }
    }

    protected static class CloseHandler
    implements GenericFutureListener<ChannelFuture> {
        private CONNECTION_TYPE connection;
        private GenericFutureListener<ChannelFuture> parent;
        final /* synthetic */ ReconnectingConnection this$0;

        public CloseHandler(CONNECTION_TYPE connection, GenericFutureListener<ChannelFuture> parent) {
            this.this$0 = var1_1;
            this.connection = connection;
            this.parent = parent;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            this.this$0.connectionHolder.compareAndSet(this.connection, null);
            this.parent.operationComplete(future);
        }
    }

    public class CloseHandlerCreator {
        public GenericFutureListener<ChannelFuture> getHandler(CONNECTION_TYPE connection, GenericFutureListener<ChannelFuture> parent) {
            return new CloseHandler(ReconnectingConnection.this, connection, parent);
        }
    }

    public static class ConnectionListeningFuture<R extends MessageLite, C extends RpcCommand<R, CONNECTION_TYPE>>
    extends AbstractFuture<CONNECTION_TYPE>
    implements RpcConnectionHandler<CONNECTION_TYPE> {
        private C cmd;
        final /* synthetic */ ReconnectingConnection this$0;

        public ConnectionListeningFuture(C cmd) {
            this.this$0 = var1_1;
            this.cmd = cmd;
        }

        public void waitAndRun() {
            boolean isInterrupted = false;
            long remainingWaitTimeMills = 120000L;
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    RemoteConnection connection = (RemoteConnection)this.get(remainingWaitTimeMills, TimeUnit.MILLISECONDS);
                    if (connection == null) break;
                    this.cmd.connectionSucceeded((RemoteConnection)connection);
                }
                catch (InterruptedException interruptEx) {
                    startTime = System.currentTimeMillis();
                    isInterrupted = true;
                    if ((remainingWaitTimeMills -= System.currentTimeMillis() - startTime) >= 1L) continue;
                    this.cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, interruptEx);
                }
                catch (ExecutionException | TimeoutException ex) {
                    logger.error("Failed to establish connection", ex);
                    this.cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                }
                break;
            }
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            this.set(null);
            this.cmd.connectionFailed(type, t);
        }

        @Override
        public void connectionSucceeded(CONNECTION_TYPE incoming) {
            RemoteConnection connection = (RemoteConnection)this.this$0.connectionHolder.get();
            do {
                boolean setted;
                if (!(setted = this.this$0.connectionHolder.compareAndSet(null, incoming))) continue;
                connection = incoming;
                break;
            } while ((connection = (RemoteConnection)this.this$0.connectionHolder.get()) == null);
            if (connection != incoming) {
                logger.debug("Closing incoming connection because a connection was already set.");
                ((RemoteConnection)incoming).getChannel().close();
            }
            this.set(connection);
        }
    }
}

