/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.HyperVectorWrapper;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.SchemaBuilder;
import oadd.org.apache.drill.exec.record.SimpleVectorWrapper;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.SchemaChangeCallBack;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class VectorContainer
implements Iterable<VectorWrapper<?>>,
VectorAccessible {
    protected final List<VectorWrapper<?>> wrappers = Lists.newArrayList();
    private BatchSchema schema;
    private int recordCount = -1;
    private OperatorContext oContext;
    private boolean schemaChanged = true;

    public VectorContainer() {
        this.oContext = null;
    }

    public VectorContainer(OperatorContext oContext) {
        this.oContext = oContext;
    }

    public OperatorContext getOperatorContext() {
        return this.oContext;
    }

    public boolean isSchemaChanged() {
        return this.schemaChanged;
    }

    public void addHyperList(List<ValueVector> vectors) {
        this.addHyperList(vectors, true);
    }

    public void addHyperList(List<ValueVector> vectors, boolean releasable) {
        this.schema = null;
        ValueVector[] vv = new ValueVector[vectors.size()];
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = vectors.get(i);
        }
        this.add(vv, releasable);
    }

    public <T extends ValueVector> T addOrGet(MaterializedField field) {
        return this.addOrGet(field, null);
    }

    public <T extends ValueVector> T addOrGet(MaterializedField field, SchemaChangeCallBack callBack) {
        Object vector;
        TypedFieldId id = this.getValueVectorId(field.getPath());
        Class<?> clazz = TypeHelper.getValueVectorClass(field.getType().getMinorType(), field.getType().getMode());
        if (id != null) {
            vector = this.getValueAccessorById(id.getFieldIds()).getValueVector();
            if (id.getFieldIds().length == 1 && clazz != null && !clazz.isAssignableFrom(vector.getClass())) {
                ValueVector newVector = TypeHelper.getNewVector(field, this.oContext.getAllocator(), callBack);
                this.replace((ValueVector)vector, newVector);
                return (T)newVector;
            }
        } else {
            vector = TypeHelper.getNewVector(field, this.oContext.getAllocator(), callBack);
            this.add((ValueVector)vector);
        }
        return (T)vector;
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        MaterializedField field = MaterializedField.create(name, type);
        return this.addOrGet(field);
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming) {
        VectorContainer vc = new VectorContainer();
        for (VectorWrapper w : incoming) {
            vc.cloneAndTransfer(w);
        }
        return vc;
    }

    public static VectorContainer getTransferClone(VectorAccessible incoming, VectorWrapper[] ignoreWrappers) {
        Iterable<VectorWrapper<Object>> wrappers = incoming;
        if (ignoreWrappers != null) {
            ArrayList<VectorWrapper> ignored = Lists.newArrayList(ignoreWrappers);
            LinkedHashSet resultant = Sets.newLinkedHashSet(incoming);
            resultant.removeAll(ignored);
            wrappers = resultant;
        }
        VectorContainer vc = new VectorContainer();
        for (VectorWrapper w : wrappers) {
            vc.cloneAndTransfer(w);
        }
        return vc;
    }

    public static VectorContainer canonicalize(VectorContainer original) {
        VectorContainer vc = new VectorContainer();
        ArrayList canonicalWrappers = new ArrayList(original.wrappers);
        Collections.sort(canonicalWrappers, new Comparator<VectorWrapper<?>>(){

            @Override
            public int compare(VectorWrapper<?> v1, VectorWrapper<?> v2) {
                return v1.getField().getPath().toExpr().compareTo(v2.getField().getPath().toExpr());
            }
        });
        for (VectorWrapper vectorWrapper : canonicalWrappers) {
            vc.add((ValueVector)vectorWrapper.getValueVector());
        }
        vc.oContext = original.oContext;
        return vc;
    }

    private void cloneAndTransfer(VectorWrapper<?> wrapper) {
        this.wrappers.add(wrapper.cloneAndTransfer());
    }

    public void addCollection(Iterable<ValueVector> vectors) {
        this.schema = null;
        for (ValueVector vv : vectors) {
            this.wrappers.add(SimpleVectorWrapper.create(vv));
        }
    }

    public TypedFieldId add(ValueVector vv) {
        this.schemaChanged = true;
        this.schema = null;
        int i = this.wrappers.size();
        this.wrappers.add(SimpleVectorWrapper.create(vv));
        return new TypedFieldId(vv.getField().getType(), i);
    }

    public void add(ValueVector[] hyperVector) {
        this.add(hyperVector, true);
    }

    public void add(ValueVector[] hyperVector, boolean releasable) {
        assert (hyperVector.length != 0);
        this.schemaChanged = true;
        this.schema = null;
        Class<?> clazz = hyperVector[0].getClass();
        ValueVector[] c = (ValueVector[])Array.newInstance(clazz, hyperVector.length);
        for (int i = 0; i < hyperVector.length; ++i) {
            c[i] = hyperVector[i];
        }
        this.wrappers.add(HyperVectorWrapper.create((MaterializedField)hyperVector[0].getField(), (ValueVector[])c, (boolean)releasable));
    }

    public void remove(ValueVector v) {
        this.schema = null;
        this.schemaChanged = true;
        Iterator<VectorWrapper<?>> iter = this.wrappers.iterator();
        while (iter.hasNext()) {
            VectorWrapper<?> w = iter.next();
            if (w.isHyper() || v != w.getValueVector()) continue;
            w.clear();
            iter.remove();
            return;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    private void replace(ValueVector old, ValueVector newVector) {
        this.schema = null;
        this.schemaChanged = true;
        int i = 0;
        for (VectorWrapper<?> w : this.wrappers) {
            if (!w.isHyper() && old == w.getValueVector()) {
                w.clear();
                this.wrappers.set(i, new SimpleVectorWrapper<ValueVector>(newVector));
                return;
            }
            ++i;
        }
        throw new IllegalStateException("You attempted to remove a vector that didn't exist.");
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        for (int i = 0; i < this.wrappers.size(); ++i) {
            VectorWrapper<?> va = this.wrappers.get(i);
            TypedFieldId id = va.getFieldIdIfMatches(i, path);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        if (fieldIds.length == 1 && clazz != null && !clazz.isAssignableFrom(va.getVectorClass())) {
            throw new IllegalStateException(String.format("Failure while reading vector.  Expected vector class of %s but was holding vector class %s.", clazz.getCanonicalName(), va.getVectorClass().getCanonicalName()));
        }
        return va.getChildWrapper(fieldIds);
    }

    private VectorWrapper<?> getValueAccessorById(int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        return va.getChildWrapper(fieldIds);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    @Override
    public BatchSchema getSchema() {
        Preconditions.checkNotNull(this.schema, "Schema is currently null.  You must call buildSchema(SelectionVectorMode) before this container can return a schema.");
        return this.schema;
    }

    public void buildSchema(BatchSchema.SelectionVectorMode mode) {
        SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(mode);
        for (VectorWrapper<?> v : this.wrappers) {
            bldr.addField(v.getField());
        }
        this.schema = bldr.build();
        this.schemaChanged = false;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.wrappers.iterator();
    }

    public void clear() {
        this.schema = null;
        this.zeroVectors();
        this.wrappers.clear();
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    @Override
    public int getRecordCount() {
        Preconditions.checkState(this.recordCount != -1, "Record count not set for this vector container");
        return this.recordCount;
    }

    public void zeroVectors() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.clear();
        }
    }

    public int getNumberOfColumns() {
        return this.wrappers.size();
    }

    public void allocateNew() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.getValueVector().allocateNew();
        }
    }

    public boolean allocateNewSafe() {
        for (VectorWrapper<?> w : this.wrappers) {
            if (w.getValueVector().allocateNewSafe()) continue;
            return false;
        }
        return true;
    }
}

