/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Arrays;
import oadd.com.carrotsearch.hppc.IntArrayList;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.commons.lang3.ArrayUtils;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class TypedFieldId {
    final TypeProtos.MajorType finalType;
    final TypeProtos.MajorType secondaryFinal;
    final TypeProtos.MajorType intermediateType;
    final int[] fieldIds;
    final boolean isHyperReader;
    final PathSegment remainder;

    public TypedFieldId(TypeProtos.MajorType type, int ... fieldIds) {
        this(type, type, type, false, null, fieldIds);
    }

    public TypedFieldId(TypeProtos.MajorType type, IntArrayList breadCrumb, PathSegment remainder) {
        this(type, type, type, false, remainder, breadCrumb.toArray());
    }

    public TypedFieldId(TypeProtos.MajorType type, boolean isHyper, int ... fieldIds) {
        this(type, type, type, isHyper, null, fieldIds);
    }

    public TypedFieldId(TypeProtos.MajorType intermediateType, TypeProtos.MajorType secondaryFinal, TypeProtos.MajorType finalType, boolean isHyper, PathSegment remainder, int ... fieldIds) {
        this.intermediateType = intermediateType;
        this.finalType = finalType;
        this.secondaryFinal = secondaryFinal;
        this.fieldIds = fieldIds;
        this.isHyperReader = isHyper;
        this.remainder = remainder;
    }

    public TypedFieldId cloneWithChild(int id) {
        int[] fieldIds = ArrayUtils.add(this.fieldIds, id);
        return new TypedFieldId(this.intermediateType, this.secondaryFinal, this.finalType, this.isHyperReader, this.remainder, fieldIds);
    }

    public PathSegment getLastSegment() {
        if (this.remainder == null) {
            return null;
        }
        PathSegment seg = this.remainder;
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return seg;
    }

    public TypedFieldId cloneWithRemainder(PathSegment remainder) {
        return new TypedFieldId(this.intermediateType, this.secondaryFinal, this.finalType, this.isHyperReader, remainder, this.fieldIds);
    }

    public boolean hasRemainder() {
        return this.remainder != null;
    }

    public PathSegment getRemainder() {
        return this.remainder;
    }

    public boolean isHyperReader() {
        return this.isHyperReader;
    }

    public TypeProtos.MajorType getIntermediateType() {
        return this.intermediateType;
    }

    public Class<? extends ValueVector> getIntermediateClass() {
        return TypeHelper.getValueVectorClass(this.intermediateType.getMinorType(), this.intermediateType.getMode());
    }

    public TypeProtos.MajorType getFinalType() {
        return this.finalType;
    }

    public int[] getFieldIds() {
        return this.fieldIds;
    }

    public TypeProtos.MajorType getSecondaryFinal() {
        return this.secondaryFinal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldIds);
        result = 31 * result + (this.finalType == null ? 0 : this.finalType.hashCode());
        result = 31 * result + (this.intermediateType == null ? 0 : this.intermediateType.hashCode());
        result = 31 * result + (this.isHyperReader ? 1231 : 1237);
        result = 31 * result + (this.remainder == null ? 0 : this.remainder.hashCode());
        result = 31 * result + (this.secondaryFinal == null ? 0 : this.secondaryFinal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedFieldId other = (TypedFieldId)obj;
        if (!Arrays.equals(this.fieldIds, other.fieldIds)) {
            return false;
        }
        if (this.finalType == null ? other.finalType != null : !this.finalType.equals(other.finalType)) {
            return false;
        }
        if (this.intermediateType == null ? other.intermediateType != null : !this.intermediateType.equals(other.intermediateType)) {
            return false;
        }
        if (this.isHyperReader != other.isHyperReader) {
            return false;
        }
        if (this.remainder == null ? other.remainder != null : !this.remainder.equals(other.remainder)) {
            return false;
        }
        return !(this.secondaryFinal == null ? other.secondaryFinal != null : !this.secondaryFinal.equals(other.secondaryFinal));
    }

    public String toString() {
        int maxLen = 10;
        return "TypedFieldId [fieldIds=" + (this.fieldIds != null ? Arrays.toString(Arrays.copyOf(this.fieldIds, Math.min(this.fieldIds.length, 10))) : null) + ", remainder=" + this.remainder + "]";
    }

    public static class Builder {
        final IntArrayList ids = new IntArrayList();
        TypeProtos.MajorType finalType;
        TypeProtos.MajorType intermediateType;
        TypeProtos.MajorType secondaryFinal;
        PathSegment remainder;
        boolean hyperReader = false;
        boolean withIndex = false;

        public Builder addId(int id) {
            this.ids.add(id);
            return this;
        }

        public Builder withIndex() {
            this.withIndex = true;
            return this;
        }

        public Builder remainder(PathSegment remainder) {
            this.remainder = remainder;
            return this;
        }

        public Builder hyper() {
            this.hyperReader = true;
            return this;
        }

        public Builder finalType(TypeProtos.MajorType finalType) {
            this.finalType = finalType;
            return this;
        }

        public Builder secondaryFinal(TypeProtos.MajorType secondaryFinal) {
            this.secondaryFinal = secondaryFinal;
            return this;
        }

        public Builder intermediateType(TypeProtos.MajorType intermediateType) {
            this.intermediateType = intermediateType;
            return this;
        }

        public TypedFieldId build() {
            Preconditions.checkNotNull(this.intermediateType);
            Preconditions.checkNotNull(this.finalType);
            if (this.intermediateType == null) {
                this.intermediateType = this.finalType;
            }
            if (this.secondaryFinal == null) {
                this.secondaryFinal = this.finalType;
            }
            TypeProtos.MajorType actualFinalType = this.finalType;
            return new TypedFieldId(this.intermediateType, this.secondaryFinal, actualFinalType, this.hyperReader, this.remainder, this.ids.toArray());
        }
    }
}

