/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.memory;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.buffer.PooledByteBufAllocatorL;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.memory.Accountor;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.ControlsInjectorFactory;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import oadd.org.apache.drill.exec.util.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelAllocator
implements BufferAllocator {
    private static final Logger logger = LoggerFactory.getLogger(TopLevelAllocator.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(TopLevelAllocator.class);
    public static final String CHILD_BUFFER_INJECTION_SITE = "child.buffer";
    public static long MAXIMUM_DIRECT_MEMORY;
    private static final boolean ENABLE_ACCOUNTING;
    private final Map<ChildAllocator, StackTraceElement[]> childrenMap;
    private final PooledByteBufAllocatorL innerAllocator = PooledByteBufAllocatorL.DEFAULT;
    private final Accountor acct;
    private final boolean errorOnLeak;
    private final DrillBuf empty;
    private final DrillConfig config;

    private TopLevelAllocator(DrillConfig config, long maximumAllocation, boolean errorOnLeak) {
        MAXIMUM_DIRECT_MEMORY = maximumAllocation;
        this.config = config != null ? config : DrillConfig.create();
        this.errorOnLeak = errorOnLeak;
        this.acct = new Accountor(config, errorOnLeak, null, null, maximumAllocation, 0L, true);
        this.empty = DrillBuf.getEmpty(this, this.acct);
        this.childrenMap = ENABLE_ACCOUNTING ? new IdentityHashMap() : null;
    }

    TopLevelAllocator(DrillConfig config) {
        this(config, Math.min(DrillConfig.getMaxDirectMemory(), config.getLong("drill.exec.memory.top.max")), config.getBoolean("drill.exec.debug.error_on_leak"));
    }

    @Override
    public boolean takeOwnership(DrillBuf buf) {
        return buf.transferAccounting(this.acct);
    }

    @Override
    public boolean takeOwnership(DrillBuf buf, Pointer<DrillBuf> out) {
        DrillBuf b = new DrillBuf((BufferAllocator)this, this.acct, buf);
        out.value = b;
        return this.acct.transferIn(b, b.capacity());
    }

    @Override
    public DrillBuf buffer(int min, int max) {
        if (min == 0) {
            return this.empty;
        }
        if (!this.acct.reserve(min)) {
            throw new OutOfMemoryRuntimeException(TopLevelAllocator.createErrorMsg(this, min));
        }
        try {
            UnsafeDirectLittleEndian buffer = this.innerAllocator.directBuffer(min, max);
            DrillBuf wrapped = new DrillBuf((BufferAllocator)this, this.acct, buffer);
            this.acct.reserved(min, wrapped);
            return wrapped;
        }
        catch (OutOfMemoryError e) {
            if ("Direct buffer memory".equals(e.getMessage())) {
                this.acct.release(min);
                throw new OutOfMemoryRuntimeException(TopLevelAllocator.createErrorMsg(this, min), e);
            }
            throw e;
        }
    }

    @Override
    public DrillBuf buffer(int size) {
        return this.buffer(size, size);
    }

    @Override
    public long getAllocatedMemory() {
        return this.acct.getAllocation();
    }

    @Override
    public long getPeakMemoryAllocation() {
        return this.acct.getPeakMemoryAllocation();
    }

    @Override
    public ByteBufAllocator getUnderlyingAllocator() {
        return this.innerAllocator;
    }

    @Override
    public BufferAllocator getChildAllocator(FragmentContext context, long initialReservation, long maximumReservation, boolean applyFragmentLimit) {
        if (!this.acct.reserve(initialReservation)) {
            logger.debug(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.acct.getCapacity() - this.acct.getAllocation()));
            throw new OutOfMemoryRuntimeException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.acct.getCapacity() - this.acct.getAllocation()));
        }
        logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
        ChildAllocator allocator = new ChildAllocator(context, this.acct, maximumReservation, initialReservation, this.childrenMap, applyFragmentLimit);
        if (ENABLE_ACCOUNTING) {
            this.childrenMap.put(allocator, Thread.currentThread().getStackTrace());
        }
        return allocator;
    }

    @Override
    public void resetFragmentLimits() {
        this.acct.resetFragmentLimits();
    }

    @Override
    public void setFragmentLimit(long limit) {
        this.acct.setFragmentLimit(limit);
    }

    @Override
    public long getFragmentLimit() {
        return this.acct.getFragmentLimit();
    }

    @Override
    public void close() {
        if (ENABLE_ACCOUNTING) {
            for (Map.Entry<ChildAllocator, StackTraceElement[]> child : this.childrenMap.entrySet()) {
                if (child.getKey().isClosed()) continue;
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] elements = child.getValue();
                for (int i = 0; i < elements.length; ++i) {
                    sb.append("\t\t");
                    sb.append(elements[i]);
                    sb.append("\n");
                }
                throw new IllegalStateException("Failure while trying to close allocator: Child level allocators not closed. Stack trace: \n" + sb);
            }
        }
        this.acct.close();
    }

    @Override
    public DrillBuf getEmpty() {
        return this.empty;
    }

    @Override
    public BufferAllocator.PreAllocator getNewPreAllocator() {
        return new PreAlloc(this, this.acct);
    }

    private static String createErrorMsg(BufferAllocator allocator, int size) {
        return String.format("Unable to allocate buffer of size %d due to memory limit. Current allocation: %d", size, allocator.getAllocatedMemory());
    }

    static {
        ENABLE_ACCOUNTING = AssertionUtil.isAssertionsEnabled();
    }

    public class PreAlloc
    implements BufferAllocator.PreAllocator {
        int bytes = 0;
        final Accountor acct;
        final BufferAllocator allocator;

        private PreAlloc(BufferAllocator allocator, Accountor acct) {
            this.acct = acct;
            this.allocator = allocator;
        }

        @Override
        public boolean preAllocate(int bytes) {
            if (!this.acct.reserve(bytes)) {
                return false;
            }
            this.bytes += bytes;
            return true;
        }

        @Override
        public DrillBuf getAllocation() {
            DrillBuf b = new DrillBuf(this.allocator, this.acct, TopLevelAllocator.this.innerAllocator.directBuffer(this.bytes, this.bytes));
            this.acct.reserved(this.bytes, b);
            return b;
        }
    }

    private class ChildAllocator
    implements BufferAllocator {
        private final DrillBuf empty;
        private Accountor childAcct;
        private Map<ChildAllocator, StackTraceElement[]> children = new HashMap<ChildAllocator, StackTraceElement[]>();
        private boolean closed = false;
        private ExecProtos.FragmentHandle handle;
        private FragmentContext fragmentContext;
        private Map<ChildAllocator, StackTraceElement[]> thisMap;
        private boolean applyFragmentLimit;

        public ChildAllocator(FragmentContext context, Accountor parentAccountor, long max, long pre, Map<ChildAllocator, StackTraceElement[]> map, boolean applyFragmentLimit) {
            assert (max >= pre);
            this.applyFragmentLimit = applyFragmentLimit;
            DrillConfig drillConf = context != null ? context.getConfig() : null;
            this.childAcct = new Accountor(drillConf, TopLevelAllocator.this.errorOnLeak, context, parentAccountor, max, pre, applyFragmentLimit);
            this.fragmentContext = context;
            this.handle = context != null ? context.getHandle() : null;
            this.thisMap = map;
            this.empty = DrillBuf.getEmpty(this, this.childAcct);
        }

        @Override
        public boolean takeOwnership(DrillBuf buf) {
            return buf.transferAccounting(this.childAcct);
        }

        @Override
        public boolean takeOwnership(DrillBuf buf, Pointer<DrillBuf> out) {
            DrillBuf b = new DrillBuf((BufferAllocator)this, TopLevelAllocator.this.acct, buf);
            out.value = b;
            return TopLevelAllocator.this.acct.transferIn(b, b.capacity());
        }

        @Override
        public DrillBuf buffer(int size, int max) {
            if (ENABLE_ACCOUNTING) {
                injector.injectUnchecked(this.fragmentContext, TopLevelAllocator.CHILD_BUFFER_INJECTION_SITE);
            }
            if (size == 0) {
                return this.empty;
            }
            if (!this.childAcct.reserve(size)) {
                throw new OutOfMemoryRuntimeException(TopLevelAllocator.createErrorMsg(this, size));
            }
            try {
                UnsafeDirectLittleEndian buffer = TopLevelAllocator.this.innerAllocator.directBuffer(size, max);
                DrillBuf wrapped = new DrillBuf((BufferAllocator)this, this.childAcct, buffer);
                this.childAcct.reserved(buffer.capacity(), wrapped);
                return wrapped;
            }
            catch (OutOfMemoryError e) {
                if ("Direct buffer memory".equals(e.getMessage())) {
                    this.childAcct.release(size);
                    throw new OutOfMemoryRuntimeException(TopLevelAllocator.createErrorMsg(this, size), e);
                }
                throw e;
            }
        }

        @Override
        public DrillBuf buffer(int size) {
            return this.buffer(size, size);
        }

        @Override
        public ByteBufAllocator getUnderlyingAllocator() {
            return TopLevelAllocator.this.innerAllocator;
        }

        @Override
        public BufferAllocator getChildAllocator(FragmentContext context, long initialReservation, long maximumReservation, boolean applyFragmentLimit) {
            if (!this.childAcct.reserve(initialReservation)) {
                throw new OutOfMemoryRuntimeException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.childAcct.getAvailable()));
            }
            logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
            ChildAllocator newChildAllocator = new ChildAllocator(context, this.childAcct, maximumReservation, initialReservation, null, applyFragmentLimit);
            this.children.put(newChildAllocator, Thread.currentThread().getStackTrace());
            return newChildAllocator;
        }

        @Override
        public BufferAllocator.PreAllocator getNewPreAllocator() {
            return new PreAlloc(this, this.childAcct);
        }

        @Override
        public void resetFragmentLimits() {
            this.childAcct.resetFragmentLimits();
        }

        @Override
        public void setFragmentLimit(long limit) {
            this.childAcct.setFragmentLimit(limit);
        }

        @Override
        public long getFragmentLimit() {
            return this.childAcct.getFragmentLimit();
        }

        @Override
        public void close() {
            if (ENABLE_ACCOUNTING) {
                if (this.thisMap != null) {
                    this.thisMap.remove(this);
                }
                for (ChildAllocator child : this.children.keySet()) {
                    if (child.isClosed()) continue;
                    StringBuilder sb = new StringBuilder();
                    StackTraceElement[] elements = this.children.get(child);
                    for (int i = 1; i < elements.length; ++i) {
                        sb.append("\t\t");
                        sb.append(elements[i]);
                        sb.append("\n");
                    }
                    IllegalStateException e = new IllegalStateException(String.format("Failure while trying to close child allocator: Child level allocators not closed. Fragment %d:%d. Stack trace: \n %s", this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), sb.toString()));
                    if (TopLevelAllocator.this.errorOnLeak) {
                        throw e;
                    }
                    logger.warn("Memory leak.", e);
                }
            }
            this.childAcct.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getAllocatedMemory() {
            return this.childAcct.getAllocation();
        }

        @Override
        public long getPeakMemoryAllocation() {
            return this.childAcct.getPeakMemoryAllocation();
        }

        @Override
        public DrillBuf getEmpty() {
            return this.empty;
        }
    }
}

