/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.Iterator;
import oadd.com.google.common.collect.Iterators;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueVectorReadExpression
implements LogicalExpression {
    static final Logger logger = LoggerFactory.getLogger(ValueVectorReadExpression.class);
    private final TypedFieldId fieldId;

    public ValueVectorReadExpression(TypedFieldId tfId) {
        this.fieldId = tfId;
    }

    public boolean hasReadPath() {
        return this.fieldId.hasRemainder();
    }

    public PathSegment getReadPath() {
        return this.fieldId.getRemainder();
    }

    public TypedFieldId getTypedFieldId() {
        return this.fieldId;
    }

    public boolean isSuperReader() {
        return this.fieldId.isHyperReader();
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.fieldId.getFinalType();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitUnknown(this, value);
    }

    public TypedFieldId getFieldId() {
        return this.fieldId;
    }

    @Override
    public ExpressionPosition getPosition() {
        return ExpressionPosition.UNKNOWN;
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public int getSelfCost() {
        return 0;
    }

    @Override
    public int getCumulativeCost() {
        return 0;
    }
}

