/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oadd.com.google.common.base.Optional;
import oadd.com.google.common.base.Predicate;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Iterables;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ErrorCollector;
import oadd.org.apache.drill.common.expression.ErrorCollectorImpl;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.CastFunctions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.expression.visitors.ConditionalExprOptimizer;
import oadd.org.apache.drill.common.expression.visitors.ExpressionValidator;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.common.util.CoreDecimalUtility;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.expr.ValueVectorReadExpression;
import oadd.org.apache.drill.exec.expr.annotations.FunctionTemplate;
import oadd.org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.DrillComplexWriterFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.FunctionLookupContext;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.resolver.FunctionResolver;
import oadd.org.apache.drill.exec.resolver.FunctionResolverFactory;
import oadd.org.apache.drill.exec.resolver.TypeCastRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTreeMaterializer {
    static final Logger logger = LoggerFactory.getLogger(ExpressionTreeMaterializer.class);

    private ExpressionTreeMaterializer() {
    }

    public static LogicalExpression materialize(LogicalExpression expr, VectorAccessible batch, ErrorCollector errorCollector, FunctionLookupContext functionLookupContext) {
        return ExpressionTreeMaterializer.materialize(expr, batch, errorCollector, functionLookupContext, false);
    }

    public static LogicalExpression materializeAndCheckErrors(LogicalExpression expr, VectorAccessible batch, FunctionLookupContext functionLookupContext) throws SchemaChangeException {
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        LogicalExpression e = ExpressionTreeMaterializer.materialize(expr, batch, collector, functionLookupContext, false);
        if (collector.hasErrors()) {
            throw new SchemaChangeException(String.format("Failure while trying to materialize incoming schema.  Errors:\n %s.", collector.toErrorString()));
        }
        return e;
    }

    public static LogicalExpression materialize(LogicalExpression expr, VectorAccessible batch, ErrorCollector errorCollector, FunctionLookupContext functionLookupContext, boolean allowComplexWriterExpr) {
        LogicalExpression out = expr.accept(new MaterializeVisitor(batch, errorCollector, allowComplexWriterExpr), functionLookupContext);
        if (!errorCollector.hasErrors()) {
            out = out.accept(ConditionalExprOptimizer.INSTANCE, null);
        }
        if (out instanceof NullExpression) {
            return new TypedNullConstant(Types.optional(TypeProtos.MinorType.INT));
        }
        return out;
    }

    public static LogicalExpression convertToNullableType(LogicalExpression fromExpr, TypeProtos.MinorType toType, FunctionLookupContext functionLookupContext, ErrorCollector errorCollector) {
        String funcName = "convertToNullable" + toType.toString();
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        args.add(fromExpr);
        FunctionCall funcCall = new FunctionCall(funcName, args, ExpressionPosition.UNKNOWN);
        FunctionResolver resolver = FunctionResolverFactory.getResolver(funcCall);
        DrillFuncHolder matchedConvertToNullableFuncHolder = functionLookupContext.findDrillFunction(resolver, funcCall);
        if (matchedConvertToNullableFuncHolder == null) {
            ExpressionTreeMaterializer.logFunctionResolutionError(errorCollector, funcCall);
            return NullExpression.INSTANCE;
        }
        return matchedConvertToNullableFuncHolder.getExpr(funcName, args, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression addCastExpression(LogicalExpression fromExpr, TypeProtos.MajorType toType, FunctionLookupContext functionLookupContext, ErrorCollector errorCollector) {
        String castFuncName = CastFunctions.getCastFunc(toType.getMinorType());
        ArrayList<LogicalExpression> castArgs = Lists.newArrayList();
        castArgs.add(fromExpr);
        if (!Types.isFixedWidthType(toType)) {
            castArgs.add(new ValueExpressions.LongExpression(65536L, null));
        } else if (CoreDecimalUtility.isDecimalType(toType)) {
            castArgs.add(new ValueExpressions.LongExpression(toType.getPrecision(), null));
            castArgs.add(new ValueExpressions.LongExpression(toType.getScale(), null));
        }
        FunctionCall castCall = new FunctionCall(castFuncName, castArgs, ExpressionPosition.UNKNOWN);
        FunctionResolver resolver = FunctionResolverFactory.getExactResolver(castCall);
        DrillFuncHolder matchedCastFuncHolder = functionLookupContext.findDrillFunction(resolver, castCall);
        if (matchedCastFuncHolder == null) {
            ExpressionTreeMaterializer.logFunctionResolutionError(errorCollector, castCall);
            return NullExpression.INSTANCE;
        }
        return matchedCastFuncHolder.getExpr(castFuncName, castArgs, ExpressionPosition.UNKNOWN);
    }

    private static void logFunctionResolutionError(ErrorCollector errorCollector, FunctionCall call) {
        StringBuilder sb = new StringBuilder();
        sb.append("Missing function implementation: ");
        sb.append("[");
        sb.append(call.getName());
        sb.append("(");
        boolean first = true;
        for (LogicalExpression e : call.args) {
            TypeProtos.MajorType mt = e.getMajorType();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mt.getMinorType().name());
            sb.append("-");
            sb.append(mt.getMode().name());
        }
        sb.append(")");
        sb.append("]");
        errorCollector.addGeneralError(call.getPosition(), sb.toString());
    }

    private static class MaterializeVisitor
    extends AbstractExprVisitor<LogicalExpression, FunctionLookupContext, RuntimeException> {
        private ExpressionValidator validator = new ExpressionValidator();
        private final ErrorCollector errorCollector;
        private final VectorAccessible batch;
        private final boolean allowComplexWriter;

        public MaterializeVisitor(VectorAccessible batch, ErrorCollector errorCollector, boolean allowComplexWriter) {
            this.batch = batch;
            this.errorCollector = errorCollector;
            this.allowComplexWriter = allowComplexWriter;
        }

        private LogicalExpression validateNewExpr(LogicalExpression newExpr) {
            newExpr.accept(this.validator, this.errorCollector);
            return newExpr;
        }

        @Override
        public LogicalExpression visitUnknown(LogicalExpression e, FunctionLookupContext functionLookupContext) throws RuntimeException {
            return e;
        }

        @Override
        public LogicalExpression visitFunctionHolderExpression(FunctionHolderExpression holder, FunctionLookupContext functionLookupContext) throws RuntimeException {
            return holder;
        }

        @Override
        public LogicalExpression visitBooleanOperator(BooleanOperator op, FunctionLookupContext functionLookupContext) {
            ArrayList<LogicalExpression> args = Lists.newArrayList();
            for (int i = 0; i < op.args.size(); ++i) {
                LogicalExpression newExpr = ((LogicalExpression)op.args.get(i)).accept(this, functionLookupContext);
                assert (newExpr != null) : String.format("Materialization of %s return a null expression.", op.args.get(i));
                args.add(newExpr);
            }
            return new BooleanOperator(op.getName(), args, op.getPosition());
        }

        @Override
        public LogicalExpression visitFunctionCall(FunctionCall call, FunctionLookupContext functionLookupContext) {
            ArrayList<LogicalExpression> args = Lists.newArrayList();
            for (int i = 0; i < call.args.size(); ++i) {
                LogicalExpression newExpr = ((LogicalExpression)call.args.get(i)).accept(this, functionLookupContext);
                assert (newExpr != null) : String.format("Materialization of %s returned a null expression.", call.args.get(i));
                args.add(newExpr);
            }
            FunctionResolver resolver = FunctionResolverFactory.getResolver(call = new FunctionCall(call.getName(), args, call.getPosition()));
            DrillFuncHolder matchedFuncHolder = functionLookupContext.findDrillFunction(resolver, call);
            if (matchedFuncHolder instanceof DrillComplexWriterFuncHolder && !this.allowComplexWriter) {
                this.errorCollector.addGeneralError(call.getPosition(), "Only ProjectRecordBatch could have complex writer function. You are using complex writer function " + call.getName() + " in a non-project operation!");
            }
            ArrayList<LogicalExpression> argsWithCast = Lists.newArrayList();
            if (matchedFuncHolder != null) {
                for (int i = 0; i < call.args.size(); ++i) {
                    LogicalExpression currentArg = (LogicalExpression)call.args.get(i);
                    TypeProtos.MajorType parmType = matchedFuncHolder.getParmMajorType(i);
                    if (currentArg.equals(NullExpression.INSTANCE) && (parmType.getMode().equals(TypeProtos.DataMode.OPTIONAL) || matchedFuncHolder.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL)) {
                        argsWithCast.add(new TypedNullConstant(parmType));
                        continue;
                    }
                    if (Types.softEquals(parmType, currentArg.getMajorType(), matchedFuncHolder.getNullHandling() == FunctionTemplate.NullHandling.NULL_IF_NULL) || matchedFuncHolder.isFieldReader(i)) {
                        argsWithCast.add(currentArg);
                        continue;
                    }
                    if (CoreDecimalUtility.isDecimalType(parmType)) {
                        parmType = TypeProtos.MajorType.newBuilder().setMinorType(parmType.getMinorType()).setMode(parmType.getMode()).setScale(currentArg.getMajorType().getScale()).setPrecision(currentArg.getMajorType().getPrecision()).build();
                    }
                    argsWithCast.add(ExpressionTreeMaterializer.addCastExpression(currentArg, parmType, functionLookupContext, this.errorCollector));
                }
                return matchedFuncHolder.getExpr(call.getName(), argsWithCast, call.getPosition());
            }
            AbstractFuncHolder matchedNonDrillFuncHolder = functionLookupContext.findNonDrillFunction(call);
            if (matchedNonDrillFuncHolder != null) {
                ArrayList<LogicalExpression> extArgsWithCast = Lists.newArrayList();
                for (int i = 0; i < call.args.size(); ++i) {
                    LogicalExpression currentArg = (LogicalExpression)call.args.get(i);
                    TypeProtos.MajorType parmType = matchedNonDrillFuncHolder.getParmMajorType(i);
                    if (Types.softEquals(parmType, currentArg.getMajorType(), true)) {
                        extArgsWithCast.add(currentArg);
                        continue;
                    }
                    if (CoreDecimalUtility.isDecimalType(parmType)) {
                        parmType = TypeProtos.MajorType.newBuilder().setMinorType(parmType.getMinorType()).setMode(parmType.getMode()).setScale(currentArg.getMajorType().getScale()).setPrecision(currentArg.getMajorType().getPrecision()).build();
                    }
                    extArgsWithCast.add(ExpressionTreeMaterializer.addCastExpression((LogicalExpression)call.args.get(i), parmType, functionLookupContext, this.errorCollector));
                }
                return matchedNonDrillFuncHolder.getExpr(call.getName(), extArgsWithCast, call.getPosition());
            }
            ExpressionTreeMaterializer.logFunctionResolutionError(this.errorCollector, call);
            return NullExpression.INSTANCE;
        }

        @Override
        public LogicalExpression visitIfExpression(IfExpression ifExpr, FunctionLookupContext functionLookupContext) {
            Optional<LogicalExpression> nonNullExpr;
            TypeProtos.MinorType elseType;
            IfExpression.IfCondition conditions = ifExpr.ifCondition;
            LogicalExpression newElseExpr = ifExpr.elseExpression.accept(this, functionLookupContext);
            LogicalExpression newCondition = conditions.condition.accept(this, functionLookupContext);
            LogicalExpression newExpr = conditions.expression.accept(this, functionLookupContext);
            conditions = new IfExpression.IfCondition(newCondition, newExpr);
            TypeProtos.MinorType thenType = conditions.expression.getMajorType().getMinorType();
            if (thenType != (elseType = newElseExpr.getMajorType().getMinorType()) && thenType != TypeProtos.MinorType.NULL && elseType != TypeProtos.MinorType.NULL) {
                TypeProtos.MinorType leastRestrictive = TypeCastRules.getLeastRestrictiveType(Arrays.asList(thenType, elseType));
                if (leastRestrictive != thenType) {
                    conditions = new IfExpression.IfCondition(newCondition, ExpressionTreeMaterializer.addCastExpression(conditions.expression, newElseExpr.getMajorType(), functionLookupContext, this.errorCollector));
                } else if (leastRestrictive != elseType) {
                    newElseExpr = ExpressionTreeMaterializer.addCastExpression(newElseExpr, conditions.expression.getMajorType(), functionLookupContext, this.errorCollector);
                } else {
                    throw new DrillRuntimeException("Case expression should have similar output type on all its branches");
                }
            }
            ArrayList<LogicalExpression> allExpressions = Lists.newArrayList();
            allExpressions.add(conditions.expression);
            allExpressions.add(newElseExpr);
            boolean containsNullExpr = Iterables.any(allExpressions, new Predicate<LogicalExpression>(){

                @Override
                public boolean apply(LogicalExpression input) {
                    return input instanceof NullExpression;
                }
            });
            if (containsNullExpr && (nonNullExpr = Iterables.tryFind(allExpressions, new Predicate<LogicalExpression>(){

                @Override
                public boolean apply(LogicalExpression input) {
                    return !input.getMajorType().getMinorType().equals(TypeProtos.MinorType.NULL);
                }
            })).isPresent()) {
                TypeProtos.MajorType type = nonNullExpr.get().getMajorType();
                conditions = new IfExpression.IfCondition(conditions.condition, this.rewriteNullExpression(conditions.expression, type));
                newElseExpr = this.rewriteNullExpression(newElseExpr, type);
            }
            if (IfExpression.newBuilder().setElse(newElseExpr).setIfCondition(conditions).build().getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL) {
                IfExpression.IfCondition condition = conditions;
                if (condition.expression.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) {
                    conditions = new IfExpression.IfCondition(condition.condition, this.getConvertToNullableExpr(ImmutableList.of(condition.expression), condition.expression.getMajorType().getMinorType(), functionLookupContext));
                }
                if (newElseExpr.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) {
                    newElseExpr = this.getConvertToNullableExpr(ImmutableList.of(newElseExpr), newElseExpr.getMajorType().getMinorType(), functionLookupContext);
                }
            }
            return this.validateNewExpr(IfExpression.newBuilder().setElse(newElseExpr).setIfCondition(conditions).build());
        }

        private LogicalExpression getConvertToNullableExpr(List<LogicalExpression> args, TypeProtos.MinorType minorType, FunctionLookupContext functionLookupContext) {
            String funcName = "convertToNullable" + minorType.toString();
            FunctionCall funcCall = new FunctionCall(funcName, args, ExpressionPosition.UNKNOWN);
            FunctionResolver resolver = FunctionResolverFactory.getResolver(funcCall);
            DrillFuncHolder matchedConvertToNullableFuncHolder = functionLookupContext.findDrillFunction(resolver, funcCall);
            if (matchedConvertToNullableFuncHolder == null) {
                ExpressionTreeMaterializer.logFunctionResolutionError(this.errorCollector, funcCall);
                return NullExpression.INSTANCE;
            }
            return matchedConvertToNullableFuncHolder.getExpr(funcName, args, ExpressionPosition.UNKNOWN);
        }

        private LogicalExpression rewriteNullExpression(LogicalExpression expr, TypeProtos.MajorType type) {
            if (expr instanceof NullExpression) {
                return new TypedNullConstant(type);
            }
            return expr;
        }

        @Override
        public LogicalExpression visitSchemaPath(SchemaPath path, FunctionLookupContext functionLookupContext) {
            TypedFieldId tfId = this.batch.getValueVectorId(path);
            if (tfId == null) {
                logger.warn("Unable to find value vector of path {}, returning null instance.", (Object)path);
                return NullExpression.INSTANCE;
            }
            ValueVectorReadExpression e = new ValueVectorReadExpression(tfId);
            return e;
        }

        @Override
        public LogicalExpression visitIntConstant(ValueExpressions.IntExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitFloatConstant(ValueExpressions.FloatExpression fExpr, FunctionLookupContext functionLookupContext) {
            return fExpr;
        }

        @Override
        public LogicalExpression visitLongConstant(ValueExpressions.LongExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitDateConstant(ValueExpressions.DateExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitTimeConstant(ValueExpressions.TimeExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitNullConstant(TypedNullConstant nullConstant, FunctionLookupContext functionLookupContext) throws RuntimeException {
            return nullConstant;
        }

        @Override
        public LogicalExpression visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, FunctionLookupContext functionLookupContext) {
            return intExpr;
        }

        @Override
        public LogicalExpression visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, FunctionLookupContext functionLookupContext) {
            return decExpr;
        }

        @Override
        public LogicalExpression visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, FunctionLookupContext functionLookupContext) {
            return decExpr;
        }

        @Override
        public LogicalExpression visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, FunctionLookupContext functionLookupContext) {
            return decExpr;
        }

        @Override
        public LogicalExpression visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, FunctionLookupContext functionLookupContext) {
            return decExpr;
        }

        @Override
        public LogicalExpression visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, FunctionLookupContext functionLookupContext) {
            return dExpr;
        }

        @Override
        public LogicalExpression visitBooleanConstant(ValueExpressions.BooleanExpression e, FunctionLookupContext functionLookupContext) {
            return e;
        }

        @Override
        public LogicalExpression visitQuotedStringConstant(ValueExpressions.QuotedString e, FunctionLookupContext functionLookupContext) {
            return e;
        }

        @Override
        public LogicalExpression visitConvertExpression(ConvertExpression e, FunctionLookupContext functionLookupContext) {
            String convertFunctionName = e.getConvertFunction() + e.getEncodingType();
            ArrayList<LogicalExpression> newArgs = Lists.newArrayList();
            newArgs.add(e.getInput());
            FunctionCall fc = new FunctionCall(convertFunctionName, newArgs, e.getPosition());
            return fc.accept(this, functionLookupContext);
        }

        @Override
        public LogicalExpression visitCastExpression(CastExpression e, FunctionLookupContext functionLookupContext) {
            LogicalExpression input = e.getInput().accept(this, functionLookupContext);
            TypeProtos.MajorType newMajor = e.getMajorType();
            TypeProtos.MinorType newMinor = input.getMajorType().getMinorType();
            if (this.castEqual(e.getPosition(), input.getMajorType(), newMajor)) {
                return input;
            }
            if (newMinor == TypeProtos.MinorType.LATE) {
                return new CastExpression(input, e.getMajorType(), e.getPosition());
            }
            if (newMinor == TypeProtos.MinorType.NULL) {
                return new TypedNullConstant(Types.optional(e.getMajorType().getMinorType()));
            }
            TypeProtos.MajorType type = e.getMajorType();
            String castFuncWithType = CastFunctions.getCastFunc(type.getMinorType());
            ArrayList<LogicalExpression> newArgs = Lists.newArrayList();
            newArgs.add(e.getInput());
            if (!Types.isFixedWidthType(type)) {
                newArgs.add(new ValueExpressions.LongExpression(type.getWidth(), null));
            }
            if (CoreDecimalUtility.isDecimalType(type)) {
                newArgs.add(new ValueExpressions.LongExpression(type.getPrecision(), null));
                newArgs.add(new ValueExpressions.LongExpression(type.getScale(), null));
            }
            FunctionCall fc = new FunctionCall(castFuncWithType, newArgs, e.getPosition());
            return fc.accept(this, functionLookupContext);
        }

        private boolean castEqual(ExpressionPosition pos, TypeProtos.MajorType from, TypeProtos.MajorType to) {
            if (!from.getMinorType().equals(to.getMinorType())) {
                return false;
            }
            switch (from.getMinorType()) {
                case FLOAT4: 
                case FLOAT8: 
                case INT: 
                case BIGINT: 
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case UINT1: 
                case UINT2: 
                case UINT4: 
                case UINT8: 
                case TIME: 
                case TIMESTAMP: 
                case TIMESTAMPTZ: 
                case DATE: 
                case INTERVAL: 
                case INTERVALDAY: 
                case INTERVALYEAR: {
                    return true;
                }
                case DECIMAL9: 
                case DECIMAL18: 
                case DECIMAL28DENSE: 
                case DECIMAL28SPARSE: 
                case DECIMAL38DENSE: 
                case DECIMAL38SPARSE: {
                    return to.getScale() == from.getScale() && to.getPrecision() == from.getPrecision();
                }
                case FIXED16CHAR: 
                case FIXEDBINARY: 
                case FIXEDCHAR: {
                    this.errorCollector.addGeneralError(pos, "Casting fixed width types are not yet supported..");
                    return false;
                }
                case VAR16CHAR: 
                case VARBINARY: 
                case VARCHAR: {
                    return to.getWidth() >= from.getWidth() && from.getWidth() > 0 || to.getWidth() == 0;
                }
            }
            this.errorCollector.addGeneralError(pos, String.format("Casting rules are unknown for type %s.", from));
            return false;
        }
    }
}

