/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.util.concurrent.AbstractCheckedFuture;
import oadd.com.google.common.util.concurrent.SettableFuture;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.BasicClientWithConnection;
import oadd.org.apache.drill.exec.rpc.ChannelClosedException;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.user.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserClient;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillClient
implements Closeable,
ConnectionThrottle {
    private static final Logger logger = LoggerFactory.getLogger(DrillClient.class);
    DrillConfig config;
    private UserClient client;
    private UserProtos.UserProperties props = null;
    private volatile ClusterCoordinator clusterCoordinator;
    private volatile boolean connected = false;
    private final BufferAllocator allocator;
    private int reconnectTimes;
    private int reconnectDelay;
    private boolean supportComplexTypes;
    private final boolean ownsZkConnection;
    private final boolean ownsAllocator;
    private final boolean isDirectConnection;
    private EventLoopGroup eventLoopGroup;

    public DrillClient() {
        this(DrillConfig.create(), false);
    }

    public DrillClient(boolean isDirect) {
        this(DrillConfig.create(), isDirect);
    }

    public DrillClient(String fileName) {
        this(DrillConfig.create(fileName), false);
    }

    public DrillClient(DrillConfig config) {
        this(config, null, false);
    }

    public DrillClient(DrillConfig config, boolean isDirect) {
        this(config, null, isDirect);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator) {
        this(config, coordinator, null, false);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, boolean isDirect) {
        this(config, coordinator, null, isDirect);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, BufferAllocator allocator) {
        this(config, coordinator, allocator, false);
    }

    public DrillClient(DrillConfig config, ClusterCoordinator coordinator, BufferAllocator allocator, boolean isDirect) {
        this.isDirectConnection = isDirect;
        this.ownsZkConnection = coordinator == null && !isDirect;
        this.ownsAllocator = allocator == null;
        this.allocator = this.ownsAllocator ? RootAllocatorFactory.newRoot(config) : allocator;
        this.config = config;
        this.clusterCoordinator = coordinator;
        this.reconnectTimes = config.getInt("drill.exec.rpc.bit.server.retry.count");
        this.reconnectDelay = config.getInt("drill.exec.rpc.bit.server.retry.delay");
        this.supportComplexTypes = config.getBoolean("drill.client.supports-complex-types");
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.client.setAutoRead(enableAutoRead);
    }

    public void setSupportComplexTypes(boolean supportComplexTypes) {
        if (this.connected) {
            throw new IllegalStateException("Attempted to modify client connection property after connection has been established.");
        }
        this.supportComplexTypes = supportComplexTypes;
    }

    public void connect() throws RpcException {
        this.connect(null, null);
    }

    public void connect(Properties props) throws RpcException {
        this.connect(null, props);
    }

    public synchronized void connect(String connect, Properties props) throws RpcException {
        CoordinationProtos.DrillbitEndpoint endpoint;
        if (this.connected) {
            return;
        }
        if (this.isDirectConnection) {
            String[] connectInfo = props.getProperty("drillbit").split(":");
            String port = connectInfo.length == 2 ? connectInfo[1] : this.config.getString("drill.exec.rpc.user.server.port");
            endpoint = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(connectInfo[0]).setUserPort(Integer.parseInt(port)).build();
        } else {
            ArrayList<CoordinationProtos.DrillbitEndpoint> endpoints;
            if (this.ownsZkConnection) {
                try {
                    this.clusterCoordinator = new ZKClusterCoordinator(this.config, connect);
                    this.clusterCoordinator.start(10000L);
                }
                catch (Exception e) {
                    throw new RpcException("Failure setting up ZK for client.", e);
                }
            }
            Preconditions.checkState(!(endpoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>(this.clusterCoordinator.getAvailableEndpoints())).isEmpty(), "No DrillbitEndpoint can be found");
            Collections.shuffle(endpoints);
            endpoint = endpoints.iterator().next();
        }
        if (props != null) {
            UserProtos.UserProperties.Builder upBuilder = UserProtos.UserProperties.newBuilder();
            for (String key : props.stringPropertyNames()) {
                upBuilder.addProperties(UserProtos.Property.newBuilder().setKey(key).setValue(props.getProperty(key)));
            }
            this.props = upBuilder.build();
        }
        this.eventLoopGroup = DrillClient.createEventLoop(this.config.getInt("drill.exec.rpc.user.client.threads"), "Client-");
        this.client = new UserClient(this.config, this.supportComplexTypes, this.allocator, this.eventLoopGroup);
        logger.debug("Connecting to server {}:{}", (Object)endpoint.getAddress(), (Object)endpoint.getUserPort());
        this.connect(endpoint);
        this.connected = true;
    }

    protected static EventLoopGroup createEventLoop(int size, String prefix) {
        return TransportCheck.createEventLoopGroup(size, prefix);
    }

    public synchronized boolean reconnect() {
        if (this.client.isActive()) {
            return true;
        }
        for (int retry = this.reconnectTimes; retry > 0; --retry) {
            try {
                Thread.sleep(this.reconnectDelay);
                ArrayList<CoordinationProtos.DrillbitEndpoint> endpoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>(this.clusterCoordinator.getAvailableEndpoints());
                if (endpoints.isEmpty()) continue;
                this.client.close();
                Collections.shuffle(endpoints);
                this.connect(endpoints.iterator().next());
                return true;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }

    private void connect(CoordinationProtos.DrillbitEndpoint endpoint) throws RpcException {
        FutureHandler f = new FutureHandler();
        this.client.connect(f, endpoint, this.props, this.getUserCredentials());
        f.checkedGet();
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.ownsAllocator && this.allocator != null) {
            this.allocator.close();
        }
        if (this.ownsZkConnection) {
            try {
                this.clusterCoordinator.close();
            }
            catch (IOException e) {
                logger.warn("Error while closing Cluster Coordinator.", e);
            }
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
        this.connected = false;
    }

    public List<QueryDataBatch> runQuery(UserBitShared.QueryType type, String plan) throws RpcException {
        UserProtos.RunQuery query = UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build();
        ListHoldingResultsListener listener = new ListHoldingResultsListener(query);
        this.client.submitQuery(listener, query);
        return listener.getResults();
    }

    private UserBitShared.UserCredentials getUserCredentials() {
        String userName = "anonymous";
        if (this.props != null) {
            for (UserProtos.Property property : this.props.getPropertiesList()) {
                if (!property.getKey().equalsIgnoreCase("user") || Strings.isNullOrEmpty(property.getValue())) continue;
                userName = property.getValue();
                break;
            }
        }
        return UserBitShared.UserCredentials.newBuilder().setUserName(userName).build();
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling query {}", (Object)QueryIdHelper.getQueryId(id));
        }
        return this.client.send(UserProtos.RpcType.CANCEL_QUERY, id, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> resumeQuery(UserBitShared.QueryId queryId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resuming query {}", (Object)QueryIdHelper.getQueryId(queryId));
        }
        return this.client.send(UserProtos.RpcType.RESUME_PAUSED_QUERY, queryId, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public void runQuery(UserBitShared.QueryType type, String plan, UserResultsListener resultsListener) {
        this.client.submitQuery(resultsListener, UserProtos.RunQuery.newBuilder().setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setType(type).setPlan(plan).build());
    }

    private class FutureHandler
    extends AbstractCheckedFuture<Void, RpcException>
    implements RpcConnectionHandler<BasicClientWithConnection.ServerConnection>,
    DrillRpcFuture<Void> {
        protected FutureHandler() {
            super(SettableFuture.create());
        }

        @Override
        public void connectionSucceeded(BasicClientWithConnection.ServerConnection connection) {
            this.getInner().set(null);
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            this.getInner().setException(new RpcException(String.format("%s : %s", type.name(), t.getMessage()), t));
        }

        private SettableFuture<Void> getInner() {
            return (SettableFuture)this.delegate();
        }

        @Override
        protected RpcException mapException(Exception e) {
            return RpcException.mapException(e);
        }

        @Override
        public DrillBuf getBuffer() {
            return null;
        }
    }

    private class ListHoldingResultsListener
    implements UserResultsListener {
        private final Vector<QueryDataBatch> results = new Vector();
        private final SettableFuture<List<QueryDataBatch>> future = SettableFuture.create();
        private final UserProtos.RunQuery query;

        public ListHoldingResultsListener(UserProtos.RunQuery query) {
            logger.debug("Listener created for query \"\"\"{}\"\"\"", (Object)query);
            this.query = query;
        }

        @Override
        public void submissionFailed(UserException ex) {
            if (ex.getCause() instanceof ChannelClosedException) {
                if (DrillClient.this.reconnect()) {
                    try {
                        DrillClient.this.client.submitQuery(this, this.query);
                    }
                    catch (Exception e) {
                        this.fail(e);
                    }
                } else {
                    this.fail(ex);
                }
            } else {
                this.fail(ex);
            }
        }

        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            this.future.set(this.results);
        }

        private void fail(Exception ex) {
            logger.debug("Submission failed.", ex);
            this.future.setException(ex);
            this.future.set(this.results);
        }

        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            logger.debug("Result arrived:  Result: {}", (Object)result);
            this.results.add(result);
        }

        public List<QueryDataBatch> getResults() throws RpcException {
            try {
                return (List)this.future.get();
            }
            catch (Throwable t) {
                throw RpcException.mapException(t);
            }
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Query ID arrived: {}", (Object)QueryIdHelper.getQueryId(queryId));
            }
        }
    }
}

