/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Stopwatch;
import oadd.com.google.common.collect.Sets;
import oadd.org.reflections.Reflections;
import oadd.org.reflections.scanners.ResourcesScanner;
import oadd.org.reflections.scanners.SubTypesScanner;
import oadd.org.reflections.scanners.TypeAnnotationsScanner;
import oadd.org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathScanner {
    private static final Logger logger = LoggerFactory.getLogger(PathScanner.class);
    private static final SubTypesScanner subTypeScanner = new SubTypesScanner();
    private static final TypeAnnotationsScanner annotationsScanner = new TypeAnnotationsScanner();
    private static final ResourcesScanner resourcesScanner = new ResourcesScanner();
    private static final Object SYNC = new Object();
    static volatile Reflections REFLECTIONS = null;

    public static <A extends Annotation, T> Map<A, Class<? extends T>> scanForAnnotatedImplementations(Class<A> annotationClass, Class<T> baseClass, List<String> scanPackages) {
        Set<Class<T>> providerClasses = PathScanner.scanForImplementations(baseClass, scanPackages);
        HashMap<A, Class> map = new HashMap<A, Class>();
        for (Class clazz : providerClasses) {
            A annotation = clazz.getAnnotation(annotationClass);
            if (annotation == null) continue;
            map.put(annotation, clazz);
        }
        return map;
    }

    private static Reflections getReflections() {
        if (REFLECTIONS == null) {
            REFLECTIONS = new Reflections(new ConfigurationBuilder().setUrls(PathScanner.getMarkedPaths()).setScanners(subTypeScanner, annotationsScanner, resourcesScanner));
        }
        return REFLECTIONS;
    }

    public static <T> Class<?>[] scanForImplementationsArr(Class<T> baseClass, List<String> scanPackages) {
        Set<Class<Class>> imps = PathScanner.scanForImplementations(baseClass, scanPackages);
        Class[] arr = imps.toArray(new Class[imps.size()]);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<Class<? extends T>> scanForImplementations(Class<T> baseClass, List<String> scanPackages) {
        Stopwatch w = new Stopwatch().start();
        try {
            Object object = SYNC;
            synchronized (object) {
                Set<Class<T>> classes = PathScanner.getReflections().getSubTypesOf(baseClass);
                Iterator<Class<T>> i = classes.iterator();
                while (i.hasNext()) {
                    Class<T> c = i.next();
                    assert (baseClass.isAssignableFrom(c));
                    if (!Modifier.isAbstract(c.getModifiers())) continue;
                    i.remove();
                }
                Set<Class<T>> set = classes;
                return set;
            }
        }
        finally {
            logger.debug("Implementations scanning took {} ms for {}.", (Object)w.elapsed(TimeUnit.MILLISECONDS), (Object)baseClass);
        }
    }

    private static Collection<URL> getMarkedPaths() {
        Set<URL> urls = PathScanner.forResource("drill-module.conf", true, new ClassLoader[0]);
        return urls;
    }

    public static Collection<URL> getConfigURLs() {
        return PathScanner.forResource("drill-module.conf", false, new ClassLoader[0]);
    }

    public static Set<URL> forResource(String resourcePathname, boolean returnRootPathname, ClassLoader ... classLoaders) {
        HashSet<URL> resultUrlSet;
        block4: {
            logger.debug("Scanning classpath for resources with pathname \"{}\".", (Object)resourcePathname);
            resultUrlSet = Sets.newHashSet();
            ClassLoader classLoader = PathScanner.class.getClassLoader();
            try {
                Enumeration<URL> resourceUrls = classLoader.getResources(resourcePathname);
                while (resourceUrls.hasMoreElements()) {
                    URL resourceUrl = resourceUrls.nextElement();
                    logger.trace("- found a(n) {} at {}.", (Object)resourcePathname, (Object)resourceUrl);
                    int index = resourceUrl.toExternalForm().lastIndexOf(resourcePathname);
                    if (index != -1 && returnRootPathname) {
                        URL classpathRootUrl = new URL(resourceUrl.toExternalForm().substring(0, index));
                        resultUrlSet.add(classpathRootUrl);
                        logger.debug("- collected resource's classpath root URL {}.", (Object)classpathRootUrl);
                        continue;
                    }
                    resultUrlSet.add(resourceUrl);
                    logger.debug("- collected resource URL {}.", (Object)resourceUrl);
                }
            }
            catch (IOException e) {
                if (Reflections.log == null) break block4;
                Reflections.log.error("Error scanning for resources named " + resourcePathname, e);
            }
        }
        return resultUrlSet;
    }
}

