/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.types;

import oadd.com.google.protobuf.TextFormat;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Types {
    static final Logger logger = LoggerFactory.getLogger(Types.class);
    public static final TypeProtos.MajorType NULL = Types.required(TypeProtos.MinorType.NULL);
    public static final TypeProtos.MajorType LATE_BIND_TYPE = Types.optional(TypeProtos.MinorType.LATE);
    public static final TypeProtos.MajorType REQUIRED_BIT = Types.required(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType OPTIONAL_BIT = Types.optional(TypeProtos.MinorType.BIT);

    public static boolean isComplex(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case LIST: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeated(TypeProtos.MajorType type) {
        return type.getMode() == TypeProtos.DataMode.REPEATED;
    }

    public static boolean isNumericType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: {
                return true;
            }
        }
        return false;
    }

    public static String getSqlTypeName(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return "ARRAY";
        }
        switch (type.getMinorType()) {
            case BIT: {
                return "BOOLEAN";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT4: {
                return "FLOAT";
            }
            case FLOAT8: {
                return "DOUBLE";
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return "DECIMAL";
            }
            case VARCHAR: {
                return "CHARACTER VARYING";
            }
            case FIXEDCHAR: {
                return "CHARACTER";
            }
            case VAR16CHAR: {
                return "NATIONAL CHARACTER VARYING";
            }
            case FIXED16CHAR: {
                return "NATIONAL CHARACTER";
            }
            case VARBINARY: {
                return "BINARY VARYING";
            }
            case FIXEDBINARY: {
                return "BINARY";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMETZ: {
                return "TIME WITH TIME ZONE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case TIMESTAMPTZ: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case INTERVALYEAR: 
            case INTERVALDAY: {
                return "INTERVAL";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
            case MONEY: {
                return "DECIMAL";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case MAP: {
                return "MAP";
            }
            case LATE: {
                return "ANY";
            }
            case NULL: {
                return "NULL";
            }
            case UINT1: {
                return "TINYINT";
            }
            case UINT2: {
                return "SMALLINT";
            }
            case UINT4: {
                return "INTEGER";
            }
            case UINT8: {
                return "BIGINT";
            }
        }
        throw new AssertionError((Object)("Unexpected/unhandled MinorType value " + type.getMinorType()));
    }

    public static int getJdbcTypeCode(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return 2003;
        }
        switch (type.getMinorType()) {
            case BIGINT: {
                return -5;
            }
            case BIT: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return 3;
            }
            case FIXED16CHAR: {
                return -15;
            }
            case FIXEDBINARY: {
                return -2;
            }
            case FIXEDCHAR: {
                return -15;
            }
            case FLOAT4: {
                return 6;
            }
            case FLOAT8: {
                return 8;
            }
            case INT: {
                return 4;
            }
            case MAP: {
                return 2002;
            }
            case MONEY: {
                return 3;
            }
            case NULL: {
                return 0;
            }
            case INTERVALYEAR: 
            case INTERVALDAY: 
            case INTERVAL: {
                return 1111;
            }
            case LATE: {
                return 1111;
            }
            case SMALLINT: {
                return 5;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: 
            case TIMESTAMPTZ: {
                return 93;
            }
            case TIMETZ: {
                return 92;
            }
            case TINYINT: {
                return -6;
            }
            case UINT1: {
                return -6;
            }
            case UINT2: {
                return 5;
            }
            case UINT4: {
                return 4;
            }
            case UINT8: {
                return -5;
            }
            case VAR16CHAR: {
                return -9;
            }
            case VARBINARY: {
                return -3;
            }
            case VARCHAR: {
                return 12;
            }
        }
        throw new UnsupportedOperationException("Unexpected/unhandled MinorType value " + type.getMinorType());
    }

    public static boolean isJdbcSignedType(TypeProtos.MajorType type) {
        boolean isSigned;
        block0 : switch (type.getMode()) {
            case REPEATED: {
                isSigned = false;
                break;
            }
            case REQUIRED: 
            case OPTIONAL: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case DECIMAL38SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL28DENSE: 
                    case DECIMAL18: 
                    case DECIMAL9: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case INTERVALYEAR: 
                    case INTERVALDAY: 
                    case INTERVAL: {
                        isSigned = true;
                        break block0;
                    }
                    case LIST: 
                    case MAP: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case BIT: 
                    case VARCHAR: 
                    case FIXEDCHAR: 
                    case VAR16CHAR: 
                    case FIXED16CHAR: 
                    case VARBINARY: 
                    case FIXEDBINARY: 
                    case DATE: 
                    case TIME: 
                    case TIMETZ: 
                    case TIMESTAMP: 
                    case TIMESTAMPTZ: 
                    case LATE: 
                    case NULL: 
                    case GENERIC_OBJECT: {
                        isSigned = false;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unexpected/unhandled MinorType value " + type.getMinorType());
            }
            default: {
                throw new UnsupportedOperationException("Unexpected/unhandled DataMode value " + type.getMode());
            }
        }
        return isSigned;
    }

    public static boolean usesHolderForGet(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return true;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVALYEAR: {
                return false;
            }
        }
        return true;
    }

    public static boolean isFixedWidthType(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case VARCHAR: 
            case VAR16CHAR: 
            case VARBINARY: {
                return false;
            }
        }
        return true;
    }

    public static boolean isStringScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case VARCHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case FIXED16CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBytesScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case VARBINARY: 
            case FIXEDBINARY: {
                return true;
            }
        }
        return false;
    }

    public static Comparability getComparability(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return Comparability.NONE;
        }
        if (type.getMinorType() == TypeProtos.MinorType.LATE) {
            return Comparability.UNKNOWN;
        }
        switch (type.getMinorType()) {
            case LATE: {
                return Comparability.UNKNOWN;
            }
            case MAP: {
                return Comparability.NONE;
            }
            case BIT: {
                return Comparability.EQUAL;
            }
        }
        return Comparability.ORDERED;
    }

    public static boolean softEquals(TypeProtos.MajorType a, TypeProtos.MajorType b, boolean allowNullSwap) {
        if (a.getMinorType() != b.getMinorType()) {
            return false;
        }
        if (allowNullSwap) {
            switch (a.getMode()) {
                case REQUIRED: 
                case OPTIONAL: {
                    switch (b.getMode()) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return true;
                        }
                    }
                }
            }
        }
        return a.getMode() == b.getMode();
    }

    public static boolean isLateBind(TypeProtos.MajorType type) {
        return type.getMinorType() == TypeProtos.MinorType.LATE;
    }

    public static TypeProtos.MajorType withMode(TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return TypeProtos.MajorType.newBuilder().setMode(mode).setMinorType(type).build();
    }

    public static TypeProtos.MajorType withScaleAndPrecision(TypeProtos.MinorType type, TypeProtos.DataMode mode, int scale, int precision) {
        return TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).setScale(scale).setPrecision(precision).build();
    }

    public static TypeProtos.MajorType required(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType repeated(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REPEATED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType optional(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(type).build();
    }

    public static TypeProtos.MajorType overrideMinorType(TypeProtos.MajorType originalMajorType, TypeProtos.MinorType overrideMinorType) {
        switch (originalMajorType.getMode()) {
            case REPEATED: {
                return Types.repeated(overrideMinorType);
            }
            case OPTIONAL: {
                return Types.optional(overrideMinorType);
            }
            case REQUIRED: {
                return Types.required(overrideMinorType);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static TypeProtos.MajorType overrideMode(TypeProtos.MajorType originalMajorType, TypeProtos.DataMode overrideMode) {
        return Types.withScaleAndPrecision(originalMajorType.getMinorType(), overrideMode, originalMajorType.getScale(), originalMajorType.getPrecision());
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName) {
        return Types.getMajorTypeFromName(typeName, TypeProtos.DataMode.REQUIRED);
    }

    public static TypeProtos.MinorType getMinorTypeFromName(String typeName) {
        switch (typeName = typeName.toLowerCase()) {
            case "bool": 
            case "boolean": {
                return TypeProtos.MinorType.BIT;
            }
            case "tinyint": {
                return TypeProtos.MinorType.TINYINT;
            }
            case "uint1": {
                return TypeProtos.MinorType.UINT1;
            }
            case "smallint": {
                return TypeProtos.MinorType.SMALLINT;
            }
            case "uint2": {
                return TypeProtos.MinorType.UINT2;
            }
            case "integer": 
            case "int": {
                return TypeProtos.MinorType.INT;
            }
            case "uint4": {
                return TypeProtos.MinorType.UINT4;
            }
            case "bigint": {
                return TypeProtos.MinorType.BIGINT;
            }
            case "uint8": {
                return TypeProtos.MinorType.UINT8;
            }
            case "float": {
                return TypeProtos.MinorType.FLOAT4;
            }
            case "double": {
                return TypeProtos.MinorType.FLOAT8;
            }
            case "decimal": {
                return TypeProtos.MinorType.DECIMAL38SPARSE;
            }
            case "symbol": 
            case "char": 
            case "utf8": 
            case "varchar": {
                return TypeProtos.MinorType.VARCHAR;
            }
            case "utf16": 
            case "string": 
            case "var16char": {
                return TypeProtos.MinorType.VAR16CHAR;
            }
            case "timestamp": {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case "interval_year_month": {
                return TypeProtos.MinorType.INTERVALYEAR;
            }
            case "interval_day_time": {
                return TypeProtos.MinorType.INTERVALDAY;
            }
            case "date": {
                return TypeProtos.MinorType.DATE;
            }
            case "time": {
                return TypeProtos.MinorType.TIME;
            }
            case "binary": {
                return TypeProtos.MinorType.VARBINARY;
            }
            case "json": 
            case "simplejson": 
            case "extendedjson": {
                return TypeProtos.MinorType.LATE;
            }
            case "null": 
            case "any": {
                return TypeProtos.MinorType.NULL;
            }
        }
        throw new UnsupportedOperationException("Could not determine type: " + typeName);
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName, TypeProtos.DataMode mode) {
        return Types.withMode(Types.getMinorTypeFromName(typeName), mode);
    }

    public static String getNameOfMinorType(TypeProtos.MinorType type) {
        switch (type) {
            case BIT: {
                return "bool";
            }
            case TINYINT: {
                return "tinyint";
            }
            case UINT1: {
                return "uint1";
            }
            case SMALLINT: {
                return "smallint";
            }
            case UINT2: {
                return "uint2";
            }
            case INT: {
                return "int";
            }
            case UINT4: {
                return "uint4";
            }
            case BIGINT: {
                return "bigint";
            }
            case UINT8: {
                return "uint8";
            }
            case FLOAT4: {
                return "float";
            }
            case FLOAT8: {
                return "double";
            }
            case DECIMAL9: {
                return "decimal";
            }
            case DECIMAL18: {
                return "decimal";
            }
            case DECIMAL28SPARSE: {
                return "decimal";
            }
            case DECIMAL38SPARSE: {
                return "decimal";
            }
            case VARCHAR: {
                return "varchar";
            }
            case VAR16CHAR: {
                return "utf16";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case VARBINARY: {
                return "binary";
            }
            case LATE: {
                throw new DrillRuntimeException("The late type should never appear in execution or an SQL query, so it does not have a name to refer to it.");
            }
        }
        throw new DrillRuntimeException("Unrecognized type " + type);
    }

    public static String toString(TypeProtos.MajorType type) {
        return type != null ? "MajorType[" + TextFormat.shortDebugString(type) + "]" : "null";
    }

    public static enum Comparability {
        UNKNOWN,
        NONE,
        EQUAL,
        ORDERED;

    }
}

