/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.fn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.types.TypeProtos;

public class CastFunctions {
    private static Map<TypeProtos.MinorType, String> TYPE2FUNC = new HashMap<TypeProtos.MinorType, String>();
    private static Set<String> CAST_FUNC_REPLACEMENT_NEEDED = new HashSet<String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE = new HashMap<String, String>();
    private static Map<String, String> CAST_FUNC_REPLACEMENT_FROM_NULLABLE = new HashMap<String, String>();

    public static String getCastFunc(TypeProtos.MinorType targetMinorType) {
        String func = TYPE2FUNC.get(targetMinorType);
        if (func != null) {
            return func;
        }
        throw new RuntimeException(String.format("cast function for type %s is not defined", targetMinorType.name()));
    }

    public static String getReplacingCastFunction(String originalCastFunction, TypeProtos.DataMode dataMode) {
        if (dataMode == TypeProtos.DataMode.OPTIONAL) {
            return CastFunctions.getReplacingCastFunctionFromNullable(originalCastFunction);
        }
        if (dataMode == TypeProtos.DataMode.REQUIRED) {
            return CastFunctions.getReplacingCastFunctionFromNonNullable(originalCastFunction);
        }
        throw new RuntimeException(String.format("replacing cast function for datatype %s is not defined", dataMode));
    }

    public static boolean isReplacementNeeded(TypeProtos.MinorType inputType, String originalfunction) {
        return inputType == TypeProtos.MinorType.VARCHAR && CAST_FUNC_REPLACEMENT_NEEDED.contains(originalfunction);
    }

    private static String getReplacingCastFunctionFromNonNullable(String originalCastFunction) {
        if (CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.get(originalCastFunction);
        }
        throw new RuntimeException(String.format("replacing cast function for %s is not defined", originalCastFunction));
    }

    private static String getReplacingCastFunctionFromNullable(String originalCastFunction) {
        if (CAST_FUNC_REPLACEMENT_FROM_NULLABLE.containsKey(originalCastFunction)) {
            return CAST_FUNC_REPLACEMENT_FROM_NULLABLE.get(originalCastFunction);
        }
        throw new RuntimeException(String.format("replacing cast function for %s is not defined", originalCastFunction));
    }

    static {
        TYPE2FUNC.put(TypeProtos.MinorType.BIGINT, "castBIGINT");
        TYPE2FUNC.put(TypeProtos.MinorType.INT, "castINT");
        TYPE2FUNC.put(TypeProtos.MinorType.BIT, "castBIT");
        TYPE2FUNC.put(TypeProtos.MinorType.TINYINT, "castTINYINT");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT4, "castFLOAT4");
        TYPE2FUNC.put(TypeProtos.MinorType.FLOAT8, "castFLOAT8");
        TYPE2FUNC.put(TypeProtos.MinorType.VARCHAR, "castVARCHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VAR16CHAR, "castVAR16CHAR");
        TYPE2FUNC.put(TypeProtos.MinorType.VARBINARY, "castVARBINARY");
        TYPE2FUNC.put(TypeProtos.MinorType.DATE, "castDATE");
        TYPE2FUNC.put(TypeProtos.MinorType.TIME, "castTIME");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMP, "castTIMESTAMP");
        TYPE2FUNC.put(TypeProtos.MinorType.TIMESTAMPTZ, "castTIMESTAMPTZ");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALDAY, "castINTERVALDAY");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVALYEAR, "castINTERVALYEAR");
        TYPE2FUNC.put(TypeProtos.MinorType.INTERVAL, "castINTERVAL");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL9, "castDECIMAL9");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL18, "castDECIMAL18");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28SPARSE, "castDECIMAL28SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL28DENSE, "castDECIMAL28DENSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38SPARSE, "castDECIMAL38SPARSE");
        TYPE2FUNC.put(TypeProtos.MinorType.DECIMAL38DENSE, "castDECIMAL38DENSE");
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.INT));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE));
        CAST_FUNC_REPLACEMENT_NEEDED.add(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE));
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringVarCharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringVarCharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringVarCharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringVarCharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringVarCharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringVarCharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringVarCharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NONNULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringVarCharToNullableDECIMAL38SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.INT), "castEmptyStringNullableVarCharToNullableINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.BIGINT), "castEmptyStringNullableVarCharToNullableBIGINT");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT4), "castEmptyStringNullableVarCharToNullableFLOAT4");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.FLOAT8), "castEmptyStringNullableVarCharToNullableFLOAT8");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL9), "castEmptyStringNullableVarCharToNullableDECIMAL9");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL18), "castEmptyStringNullableVarCharToNullableDECIMAL18");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL28SPARSE), "castEmptyStringNullableVarCharToNullableDECIMAL28SPARSE");
        CAST_FUNC_REPLACEMENT_FROM_NULLABLE.put(TYPE2FUNC.get(TypeProtos.MinorType.DECIMAL38SPARSE), "castEmptyStringNullableVarCharToNullableDECIMAL38SPARSE");
    }
}

