/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.config;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.com.fasterxml.jackson.databind.module.SimpleModule;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Joiner;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.typesafe.config.Config;
import oadd.com.typesafe.config.ConfigFactory;
import oadd.com.typesafe.config.ConfigRenderOptions;
import oadd.org.apache.drill.common.config.NestedConfig;
import oadd.org.apache.drill.common.exceptions.DrillConfigurationException;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.FormatPluginConfigBase;
import oadd.org.apache.drill.common.logical.StoragePluginConfigBase;
import oadd.org.apache.drill.common.logical.data.LogicalOperatorBase;
import oadd.org.apache.drill.common.util.PathScanner;
import oadd.org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.VM;

public final class DrillConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(DrillConfig.class);
    private final ObjectMapper mapper;
    private final ImmutableList<String> startupArguments;
    public static final boolean ON_OSX = System.getProperty("os.name").contains("OS X");
    private static final long MAX_DIRECT_MEMORY = VM.maxDirectMemory();
    private volatile List<Queue<Object>> sinkQueues = new CopyOnWriteArrayList<Queue>(new Queue[1]);

    @VisibleForTesting
    public DrillConfig(Config config, boolean enableServerConfigs) {
        super(config);
        logger.debug("Setting up DrillConfig object.");
        logger.trace("Given Config object is:\n{}", (Object)config.root().render(ConfigRenderOptions.defaults()));
        this.mapper = new ObjectMapper();
        if (enableServerConfigs) {
            SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, new LogicalExpression.De(this)).addDeserializer(SchemaPath.class, new SchemaPath.De());
            this.mapper.registerModule(deserModule);
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.mapper.registerSubtypes(LogicalOperatorBase.getSubTypes(this));
            this.mapper.registerSubtypes(StoragePluginConfigBase.getSubTypes(this));
            this.mapper.registerSubtypes(FormatPluginConfigBase.getSubTypes(this));
        }
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        this.startupArguments = ImmutableList.copyOf(bean.getInputArguments());
        logger.debug("DrillConfig object initialized.");
    }

    public List<String> getStartupArguments() {
        return this.startupArguments;
    }

    public static DrillConfig create() {
        return DrillConfig.create(null, true);
    }

    public static DrillConfig forClient() {
        return DrillConfig.create(null, false);
    }

    public static DrillConfig create(String overrideFileResourcePathname) {
        return DrillConfig.create(overrideFileResourcePathname, true);
    }

    @VisibleForTesting
    public static DrillConfig create(Properties testConfigurations) {
        return DrillConfig.create(null, testConfigurations, true);
    }

    public static DrillConfig create(String overrideFileResourcePathname, boolean enableServerConfigs) {
        return DrillConfig.create(overrideFileResourcePathname, null, enableServerConfigs);
    }

    private static DrillConfig create(String overrideFileResourcePathname, Properties overriderProps, boolean enableServerConfigs) {
        Collection<URL> urls;
        ClassLoader[] classLoaders;
        overrideFileResourcePathname = overrideFileResourcePathname == null ? "drill-override.conf" : overrideFileResourcePathname;
        Config fallback = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0])) {
            URL url = classLoader.getResource("drill-default.conf");
            if (null == url) continue;
            logger.info("Loading base configuration file at {}.", (Object)url);
            fallback = ConfigFactory.load(classLoader, "drill-default.conf");
            break;
        }
        String lineBrokenList = (urls = PathScanner.getConfigURLs()).size() == 0 ? "" : "\n\t- " + Joiner.on("\n\t- ").join(urls);
        logger.info("Loading {} module configuration files at: {}.", (Object)urls.size(), (Object)lineBrokenList);
        for (URL url : urls) {
            fallback = ConfigFactory.parseURL(url).withFallback(fallback);
        }
        URL overrideFileUrl = Thread.currentThread().getContextClassLoader().getResource(overrideFileResourcePathname);
        if (null != overrideFileUrl) {
            logger.info("Loading override config. file at {}.", (Object)overrideFileUrl);
        }
        Config effectiveConfig = ConfigFactory.load(overrideFileResourcePathname).withFallback(fallback);
        if (overriderProps != null) {
            logger.info("Loading override Properties parameter {}.", (Object)overriderProps);
            effectiveConfig = ConfigFactory.parseProperties(overriderProps).withFallback(effectiveConfig);
        }
        return new DrillConfig(effectiveConfig.resolve(), enableServerConfigs);
    }

    public <T> Class<T> getClassAt(String location, Class<T> clazz) throws DrillConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            throw new DrillConfigurationException(String.format("No class defined at location '%s'.  Expected a definition of the class []", location, clazz.getCanonicalName()));
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t = c;
                return t;
            }
            throw new DrillConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof DrillConfigurationException) {
                throw (DrillConfigurationException)ex;
            }
            throw new DrillConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws DrillConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            T t = c.newInstance();
            return t;
        }
        catch (Exception ex) {
            throw new DrillConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    public void setSinkQueues(int number, Queue<Object> queue) {
        this.sinkQueues.set(number, queue);
    }

    public Queue<Object> getQueue(int number) {
        if (this.sinkQueues.size() <= number || number < 0 || this.sinkQueues == null) {
            throw new IllegalArgumentException(String.format("Queue %d is not available.", number));
        }
        return this.sinkQueues.get(number);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String toString() {
        return this.root().render();
    }

    public static void main(String[] args) throws Exception {
        DrillConfig config = DrillConfig.create();
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }
}

