/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import oadd.com.google.common.base.Preconditions;

public class DeferredException
implements AutoCloseable {
    private Exception exception = null;
    private boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(Exception exception) {
        Preconditions.checkNotNull(exception);
        DeferredException deferredException = this;
        synchronized (deferredException) {
            Preconditions.checkState(!this.isClosed);
            if (this.exception == null) {
                this.exception = exception;
            } else {
                this.exception.addSuppressed(exception);
            }
        }
    }

    public void addThrowable(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof Exception) {
            this.addException((Exception)throwable);
            return;
        }
        this.addException(new RuntimeException(throwable));
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public synchronized Exception getAndClear() {
        Preconditions.checkState(!this.isClosed);
        if (this.exception != null) {
            Exception local = this.exception;
            this.exception = null;
            return local;
        }
        return null;
    }

    public synchronized void throwAndClear() throws Exception {
        Exception e = this.getAndClear();
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressingClose(AutoCloseable autoCloseable) {
        DeferredException deferredException = this;
        synchronized (deferredException) {
            Preconditions.checkState(!this.isClosed);
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                this.addException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        try {
            this.throwAndClear();
        }
        finally {
            this.isClosed = true;
        }
    }
}

