/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.curator.RetryPolicy;
import oadd.org.apache.curator.ensemble.EnsembleProvider;
import oadd.org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.CuratorTempFramework;
import oadd.org.apache.curator.framework.api.ACLProvider;
import oadd.org.apache.curator.framework.api.CompressionProvider;
import oadd.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import oadd.org.apache.curator.framework.imps.CuratorTempFrameworkImpl;
import oadd.org.apache.curator.framework.imps.DefaultACLProvider;
import oadd.org.apache.curator.framework.imps.GzipCompressionProvider;
import oadd.org.apache.curator.utils.DefaultZookeeperFactory;
import oadd.org.apache.curator.utils.ZookeeperFactory;

public class CuratorFrameworkFactory {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = Integer.getInteger("curator-default-session-timeout", 60000);
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = Integer.getInteger("curator-default-connection-timeout", 15000);
    private static final byte[] LOCAL_ADDRESS = CuratorFrameworkFactory.getLocalAddress();
    private static final CompressionProvider DEFAULT_COMPRESSION_PROVIDER = new GzipCompressionProvider();
    private static final DefaultZookeeperFactory DEFAULT_ZOOKEEPER_FACTORY = new DefaultZookeeperFactory();
    private static final DefaultACLProvider DEFAULT_ACL_PROVIDER = new DefaultACLProvider();
    private static final long DEFAULT_INACTIVE_THRESHOLD_MS = (int)TimeUnit.MINUTES.toMillis(3L);

    public static Builder builder() {
        return new Builder();
    }

    public static CuratorFramework newClient(String connectString, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.newClient(connectString, DEFAULT_SESSION_TIMEOUT_MS, DEFAULT_CONNECTION_TIMEOUT_MS, retryPolicy);
    }

    public static CuratorFramework newClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.builder().connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs).retryPolicy(retryPolicy).build();
    }

    private static byte[] getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress().getBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return new byte[0];
        }
    }

    private CuratorFrameworkFactory() {
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_SESSION_TIMEOUT_MS;
    }

    static /* synthetic */ int access$200() {
        return DEFAULT_CONNECTION_TIMEOUT_MS;
    }

    static /* synthetic */ byte[] access$300() {
        return LOCAL_ADDRESS;
    }

    static /* synthetic */ CompressionProvider access$400() {
        return DEFAULT_COMPRESSION_PROVIDER;
    }

    static /* synthetic */ DefaultZookeeperFactory access$500() {
        return DEFAULT_ZOOKEEPER_FACTORY;
    }

    static /* synthetic */ DefaultACLProvider access$600() {
        return DEFAULT_ACL_PROVIDER;
    }

    public static class Builder {
        private EnsembleProvider ensembleProvider;
        private int sessionTimeoutMs = CuratorFrameworkFactory.access$100();
        private int connectionTimeoutMs = CuratorFrameworkFactory.access$200();
        private RetryPolicy retryPolicy;
        private ThreadFactory threadFactory = null;
        private String namespace;
        private String authScheme = null;
        private byte[] authValue = null;
        private byte[] defaultData = CuratorFrameworkFactory.access$300();
        private CompressionProvider compressionProvider = CuratorFrameworkFactory.access$400();
        private ZookeeperFactory zookeeperFactory = CuratorFrameworkFactory.access$500();
        private ACLProvider aclProvider = CuratorFrameworkFactory.access$600();
        private boolean canBeReadOnly = false;

        public CuratorFramework build() {
            return new CuratorFrameworkImpl(this);
        }

        public CuratorTempFramework buildTemp() {
            return this.buildTemp(DEFAULT_INACTIVE_THRESHOLD_MS, TimeUnit.MILLISECONDS);
        }

        public CuratorTempFramework buildTemp(long inactiveThreshold, TimeUnit unit) {
            return new CuratorTempFrameworkImpl(this, unit.toMillis(inactiveThreshold));
        }

        public Builder authorization(String scheme, byte[] auth) {
            this.authScheme = scheme;
            this.authValue = auth != null ? Arrays.copyOf(auth, auth.length) : null;
            return this;
        }

        public Builder connectString(String connectString) {
            this.ensembleProvider = new FixedEnsembleProvider(connectString);
            return this;
        }

        public Builder ensembleProvider(EnsembleProvider ensembleProvider) {
            this.ensembleProvider = ensembleProvider;
            return this;
        }

        public Builder defaultData(byte[] defaultData) {
            this.defaultData = defaultData != null ? Arrays.copyOf(defaultData, defaultData.length) : null;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder sessionTimeoutMs(int sessionTimeoutMs) {
            this.sessionTimeoutMs = sessionTimeoutMs;
            return this;
        }

        public Builder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder compressionProvider(CompressionProvider compressionProvider) {
            this.compressionProvider = compressionProvider;
            return this;
        }

        public Builder zookeeperFactory(ZookeeperFactory zookeeperFactory) {
            this.zookeeperFactory = zookeeperFactory;
            return this;
        }

        public Builder aclProvider(ACLProvider aclProvider) {
            this.aclProvider = aclProvider;
            return this;
        }

        public Builder canBeReadOnly(boolean canBeReadOnly) {
            this.canBeReadOnly = canBeReadOnly;
            return this;
        }

        public ACLProvider getAclProvider() {
            return this.aclProvider;
        }

        public ZookeeperFactory getZookeeperFactory() {
            return this.zookeeperFactory;
        }

        public CompressionProvider getCompressionProvider() {
            return this.compressionProvider;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public EnsembleProvider getEnsembleProvider() {
            return this.ensembleProvider;
        }

        public int getSessionTimeoutMs() {
            return this.sessionTimeoutMs;
        }

        public int getConnectionTimeoutMs() {
            return this.connectionTimeoutMs;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAuthScheme() {
            return this.authScheme;
        }

        public byte[] getAuthValue() {
            return this.authValue != null ? Arrays.copyOf(this.authValue, this.authValue.length) : null;
        }

        public byte[] getDefaultData() {
            return this.defaultData;
        }

        public boolean canBeReadOnly() {
            return this.canBeReadOnly;
        }

        private Builder() {
        }
    }
}

