/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.el;

import java.util.List;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import oadd.org.apache.commons.el.Expression;
import oadd.org.apache.commons.el.Logger;
import oadd.org.apache.commons.el.UnaryOperator;

public class UnaryOperatorExpression
extends Expression {
    UnaryOperator mOperator;
    List mOperators;
    Expression mExpression;

    public UnaryOperator getOperator() {
        return this.mOperator;
    }

    public void setOperator(UnaryOperator pOperator) {
        this.mOperator = pOperator;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List pOperators) {
        this.mOperators = pOperators;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression pExpression) {
        this.mExpression = pExpression;
    }

    public UnaryOperatorExpression(UnaryOperator pOperator, List pOperators, Expression pExpression) {
        this.mOperator = pOperator;
        this.mOperators = pOperators;
        this.mExpression = pExpression;
    }

    public String getExpressionString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (this.mOperator != null) {
            buf.append(this.mOperator.getOperatorSymbol());
            buf.append(" ");
        } else {
            int i = 0;
            while (i < this.mOperators.size()) {
                UnaryOperator operator = (UnaryOperator)this.mOperators.get(i);
                buf.append(operator.getOperatorSymbol());
                buf.append(" ");
                ++i;
            }
        }
        buf.append(this.mExpression.getExpressionString());
        buf.append(")");
        return buf.toString();
    }

    public Object evaluate(VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        Object value = this.mExpression.evaluate(pResolver, functions, pLogger);
        if (this.mOperator != null) {
            value = this.mOperator.apply(value, pLogger);
        } else {
            int i = this.mOperators.size() - 1;
            while (i >= 0) {
                UnaryOperator operator = (UnaryOperator)this.mOperators.get(i);
                value = operator.apply(value, pLogger);
                --i;
            }
        }
        return value;
    }
}

